/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.GridFlatPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.mcontrol.mobtable.MobTableAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.metadata.report.ReportListAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.util.CollectionUtils;

public class MobileGridFieldsControlPlugin
extends AbstractFormPlugin {
    private static final String CONTEXT = "context";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String VALUE = "value";
    private static final String LIST_NAME = "listname";
    private static final String IS_FREEZE = "isfreeze";
    private static final String IS_FREEZER = "isfreezer";
    private static final String FREEZE_LIST_KEY = "freezelistkey";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        List<ControlAp<?>> controlAps;
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        String modelType = propertyEditHelper.getModelType(this.getView());
        if (!propertyEditHelper.isFormDesigner(this.getView()) || StringUtils.equalsIgnoreCase((CharSequence)"ReportFormModel", (CharSequence)modelType)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            String caption = ResManager.loadKDString((String)"\u5217\u51bb\u7ed3", (String)"MobileGridFieldsControlPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]);
            entryGrid.setColumnProperty(IS_FREEZE, "header", (Object)caption);
            this.getView().setVisible(Boolean.FALSE, new String[]{IS_FREEZER});
        }
        String itemId = propertyEditHelper.getItemId(this.getView());
        Map<String, List<ControlAp<?>>> gridColumn = this.getGridColumn(propertyEditHelper);
        ArrayList<Map<String, Object>> columValues = new ArrayList(10);
        Object paramValue = propertyEditHelper.getParamValue(this.getView(), VALUE);
        if (paramValue instanceof List) {
            columValues = (List)propertyEditHelper.getParamValue(this.getView(), VALUE);
        }
        if (CollectionUtils.isNotEmpty(controlAps = gridColumn.get(itemId))) {
            this.getModel().clearNoDataRow();
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, controlAps.size());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            this.setFreeze(controlAps, entryEntity, columValues);
            this.setFreezer(controlAps, entryEntity, columValues);
        }
    }

    private Map<String, List<ControlAp<?>>> getGridColumn(PropertyEditHelper propertyEditHelper) {
        List context = new ArrayList(10);
        Object paramValue = propertyEditHelper.getParamValue(this.getView(), CONTEXT);
        if (paramValue instanceof List) {
            context = (List)paramValue;
        }
        HashMap map = new HashMap(16);
        if (CollectionUtils.isNotEmpty(context)) {
            FormMetadata formMetadata = FormTreeBuilder.deserialzeFormMetadata(context);
            formMetadata.createIndex();
            List items = formMetadata.getItems();
            for (ControlAp item : items) {
                if (!(item instanceof MobTableAp) && !(item instanceof ListGridViewAp) && !(item instanceof EntryAp) && !(item instanceof ReportListAp)) continue;
                List gridItems = ((ContainerAp)item).getItems();
                String itemId = propertyEditHelper.getItemId(this.getView());
                if (!StringUtil.equals((String)itemId, (String)item.getId())) continue;
                this.removeInvisibleItem(gridItems);
                map.put(itemId, gridItems);
            }
        }
        return map;
    }

    private void setFreeze(List<ControlAp<?>> controlAps, DynamicObjectCollection entryEntity, List<Map<String, Object>> columValues) {
        String key;
        int index = 0;
        boolean isFreeeze = false;
        for (int i = controlAps.size() - 1; i >= 0; --i) {
            key = controlAps.get(i).getKey();
            if (controlAps.get(i) instanceof ListColumnAp) {
                key = ((ListColumnAp)controlAps.get(i)).getListFieldId();
            }
            ((DynamicObject)entryEntity.get(i)).set(FREEZE_LIST_KEY, (Object)key);
            ((DynamicObject)entryEntity.get(i)).set(LIST_NAME, (Object)controlAps.get(i).getName());
            if (CollectionUtils.isNotEmpty(columValues)) {
                for (Map<String, Object> columValue : columValues) {
                    if (!StringUtil.equals((String)key, (String)String.valueOf(columValue.get(FREEZE_LIST_KEY)))) continue;
                    isFreeeze = Boolean.parseBoolean((String)columValue.get(IS_FREEZE));
                    ((DynamicObject)entryEntity.get(i)).set(IS_FREEZE, columValue.get(IS_FREEZE));
                    if (!isFreeeze) continue;
                    index = i;
                    break;
                }
            }
            if (isFreeeze) break;
        }
        block2: for (int j = 0; j <= index; ++j) {
            key = controlAps.get(j).getKey();
            if (controlAps.get(j) instanceof ListColumnAp) {
                key = ((ListColumnAp)controlAps.get(j)).getListFieldId();
            }
            ((DynamicObject)entryEntity.get(j)).set(FREEZE_LIST_KEY, (Object)key);
            ((DynamicObject)entryEntity.get(j)).set(LIST_NAME, (Object)controlAps.get(j).getName());
            if (index == 0) {
                for (Map<String, Object> columValue : columValues) {
                    if (!StringUtil.equals((String)key, (String)String.valueOf(columValue.get(FREEZE_LIST_KEY)))) continue;
                    ((DynamicObject)entryEntity.get(j)).set(IS_FREEZE, columValue.get(IS_FREEZE));
                    continue block2;
                }
                continue;
            }
            ((DynamicObject)entryEntity.get(j)).set(IS_FREEZE, (Object)Boolean.TRUE);
        }
    }

    private void setFreezer(List<ControlAp<?>> controlAps, DynamicObjectCollection entryEntity, List<Map<String, Object>> columValues) {
        String key;
        int index = controlAps.size() - 1;
        boolean isFreezer = false;
        for (int i = 0; i < controlAps.size() - 1; ++i) {
            key = controlAps.get(i).getKey();
            if (controlAps.get(i) instanceof ListColumnAp) {
                key = ((ListColumnAp)controlAps.get(i)).getListFieldId();
            }
            if (CollectionUtils.isNotEmpty(columValues)) {
                for (Map<String, Object> columValue : columValues) {
                    if (!StringUtil.equals((String)key, (String)String.valueOf(columValue.get(FREEZE_LIST_KEY)))) continue;
                    isFreezer = Boolean.parseBoolean((String)columValue.get(IS_FREEZER));
                    ((DynamicObject)entryEntity.get(i)).set(IS_FREEZER, columValue.get(IS_FREEZER));
                    if (!isFreezer) continue;
                    index = i;
                    break;
                }
            }
            if (isFreezer) break;
        }
        block2: for (int j = controlAps.size() - 1; j >= index; --j) {
            key = controlAps.get(j).getKey();
            if (controlAps.get(j) instanceof ListColumnAp) {
                key = ((ListColumnAp)controlAps.get(j)).getListFieldId();
            }
            if (index == controlAps.size() - 1) {
                for (Map<String, Object> columValue : columValues) {
                    if (!StringUtil.equals((String)key, (String)String.valueOf(columValue.get(FREEZE_LIST_KEY)))) continue;
                    ((DynamicObject)entryEntity.get(j)).set(IS_FREEZER, columValue.get(IS_FREEZER));
                    continue block2;
                }
                continue;
            }
            ((DynamicObject)entryEntity.get(j)).set(IS_FREEZER, (Object)Boolean.TRUE);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList value = new ArrayList(10);
        HashMap para = new HashMap(16);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().close();
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject dynamicObject : entryEntity) {
                HashMap<String, String> map = new HashMap<String, String>(3);
                map.put(FREEZE_LIST_KEY, dynamicObject.getString(FREEZE_LIST_KEY));
                map.put(LIST_NAME, dynamicObject.getString(LIST_NAME));
                map.put(IS_FREEZE, dynamicObject.getString(IS_FREEZE));
                map.put(IS_FREEZER, dynamicObject.getString(IS_FREEZER));
                value.add(map);
            }
        }
        para.put(VALUE, value);
        para.put("itemId", customParams.get("itemId"));
        para.put("metaType", customParams.get("metaType"));
        para.put("propertyName", customParams.get("propertyName"));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (IS_FREEZE.equalsIgnoreCase(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.getModel().beginInit();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (newValue.booleanValue()) {
                for (int i = entryCurrentRowIndex - 1; i >= 0; --i) {
                    this.getModel().setValue(IS_FREEZE, (Object)newValue, i);
                }
            } else {
                for (int i = entryCurrentRowIndex + 1; i < this.getModel().getEntryRowCount(ENTRY_ENTITY); ++i) {
                    this.getModel().setValue(IS_FREEZE, (Object)newValue, i);
                }
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        } else if (IS_FREEZER.equalsIgnoreCase(e.getProperty().getName())) {
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newValue = (Boolean)changeData.getNewValue();
            this.getModel().beginInit();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (newValue.booleanValue()) {
                for (int i = entryCurrentRowIndex + 1; i < this.getModel().getEntryRowCount(ENTRY_ENTITY); ++i) {
                    this.getModel().setValue(IS_FREEZER, (Object)newValue, i);
                }
            } else {
                for (int i = entryCurrentRowIndex - 1; i >= 0; --i) {
                    this.getModel().setValue(IS_FREEZER, (Object)newValue, i);
                }
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        if (e.getSource() instanceof FieldEdit) {
            FieldEdit fieldEdit = (FieldEdit)e.getSource();
            int rowIndex = e.getRowIndex();
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEdit.getKey(), (CharSequence)IS_FREEZE) && ((Boolean)e.getValue()).booleanValue() && ((Boolean)this.getModel().getValue(IS_FREEZER, rowIndex)).booleanValue()) {
                e.setCancel(true);
                this.getView().updateView(IS_FREEZE, rowIndex);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEdit.getKey(), (CharSequence)IS_FREEZER) && ((Boolean)e.getValue()).booleanValue() && ((Boolean)this.getModel().getValue(IS_FREEZE, rowIndex)).booleanValue()) {
                e.setCancel(true);
                this.getView().updateView(IS_FREEZER, rowIndex);
            }
        }
    }

    private void removeInvisibleItem(List<ControlAp<?>> gridItems) {
        if (CollectionUtils.isNotEmpty(gridItems)) {
            Iterator<ControlAp<?>> iterator = gridItems.iterator();
            while (iterator.hasNext()) {
                ControlAp<?> controlAp = iterator.next();
                String key = controlAp.getKey();
                if (controlAp instanceof ListColumnAp) {
                    key = ((ListColumnAp)controlAp).getListFieldId();
                }
                if (!"fseq".equals(key) && !controlAp.isInvisible() && !controlAp.isHidden() && !(controlAp instanceof GridFlatPanelAp)) continue;
                iterator.remove();
            }
        }
    }
}

