/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.CollectionUtils;

public class MultiEntrySelectPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_KEY = "entryentity";
    private static final String FCODE = "fcode";
    private static final String FNAME = "fname";
    private static final String BTNOK = "btnok";
    public static final String CUSTPARAM_ENTITY_NUMBER = "entitynumber";
    public static final String CUSTPARAM_SELECTED_ENTRYS = "selectedentrys";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String selectedentrys = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_SELECTED_ENTRYS);
        if (StringUtils.isBlank((CharSequence)selectedentrys)) {
            return;
        }
        String[] entryKeys = StringUtils.split((String)selectedentrys, (String)",");
        List<String> entryKeyList = Arrays.asList(entryKeys);
        ArrayList<Integer> rowsCheck = new ArrayList<Integer>();
        IDataModel model = this.getModel();
        int len = model.getEntryRowCount(ENTRY_KEY);
        for (int i = 0; i < len; ++i) {
            if (!entryKeyList.contains(model.getValue(FCODE, i))) continue;
            rowsCheck.add(i);
        }
        if (rowsCheck.size() > 0) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
            int[] rows = new int[rowsCheck.size()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = (Integer)rowsCheck.get(i);
            }
            grid.selectRows(rows, rows[0]);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_ENTITY_NUMBER);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ArrayList<EntryType> entryTypeList = new ArrayList<EntryType>(10);
        for (EntityType entityType : mainType.getAllEntities().values()) {
            if (!(entityType instanceof EntryType)) continue;
            entryTypeList.add((EntryType)entityType);
        }
        if (CollectionUtils.isEmpty(entryTypeList)) {
            return;
        }
        IDataModel model = this.getModel();
        int[] rows = model.batchCreateNewEntryRow(ENTRY_KEY, entryTypeList.size());
        int i = 0;
        for (EntryType entryType : entryTypeList) {
            model.setValue(FCODE, (Object)entryType.getName(), rows[i]);
            model.setValue(FNAME, (Object)entryType.getDisplayName(), rows[i]);
            ++i;
        }
    }

    public void click(EventObject evt) {
        if (BTNOK.equals(((Control)evt.getSource()).getKey())) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
            int[] rows = grid.getEntryState().getSelectedRows();
            IDataModel model = this.getModel();
            StringBuilder selectedEntryBuilder = new StringBuilder();
            for (int row : rows) {
                String entryKeys = (String)model.getValue(FCODE, row);
                if (!StringUtils.isNotEmpty((CharSequence)entryKeys)) continue;
                selectedEntryBuilder.append(",").append(entryKeys);
            }
            String selectedentrys = selectedEntryBuilder.toString();
            if (StringUtils.isNotEmpty((CharSequence)selectedentrys) && selectedentrys.length() > 1) {
                selectedentrys = selectedentrys.substring(1);
            }
            this.getView().returnDataToParent((Object)selectedentrys);
            this.getView().close();
        }
    }
}

