/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;

public class OperationColItemEditPlugin
extends AbstractFormPlugin {
    private static final String FOP_ICON = "fopicon";
    private static final String FOP_KEY = "fopkey";
    private static final String VALUE = "value";
    private static final String OPERATION_NAME = "operationName";
    private static final String FOP_NAME = "fopname";
    private static final String FPERMISSIONID = "fpermissionid";
    private static final String FVISIBLE = "fvisible";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private String entryKey = "entryentity";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", FOP_ICON});
        TextEdit opSelect = (TextEdit)this.getControl(FOP_KEY);
        opSelect.addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = null;
        if (value instanceof List) {
            items = (List)value;
        }
        if (items != null && !items.isEmpty()) {
            int[] rows = model.batchCreateNewEntryRow(this.entryKey, items.size());
            int i = 0;
            for (Map item : items) {
                model.setValue("fshowstyle", (Object)(item.get("showStyle") == null ? Integer.valueOf(0) : item.get("showStyle")), rows[i]);
                model.setValue("fopid", item.get("id"), rows[i]);
                model.setValue(FOP_KEY, item.get("operationKey"), rows[i]);
                if (item.get(OPERATION_NAME) instanceof String) {
                    model.setValue(FOP_NAME, (Object)new LocaleString((String)item.get(OPERATION_NAME)), rows[i]);
                } else if (item.get(OPERATION_NAME) instanceof Map) {
                    model.setValue(FOP_NAME, (Object)LocaleString.fromMap((Map)((Map)item.get(OPERATION_NAME))), rows[i]);
                }
                model.setValue(FOP_ICON, item.get("icon"), rows[i]);
                model.setValue(FVISIBLE, (Object)(item.get("visible") == null ? Boolean.valueOf(true) : item.get("visible")), rows[i]);
                model.setValue("fforecolor", item.get("foreColor"), rows[i]);
                model.setValue("ffontsize", item.get("fontSize"), rows[i]);
                String permissionId = (String)item.get("permissionId");
                if (StringUtils.isEmpty((String)permissionId)) {
                    permissionId = this.getItemPermissionId((String)item.get("operationKey"));
                }
                model.setValue(FPERMISSIONID, (Object)permissionId, rows[i]);
                ++i;
            }
        }
    }

    private String getItemPermissionId(String operationKey) {
        Optional value;
        List ops;
        block7: {
            if (StringUtils.isEmpty((String)operationKey)) {
                return "";
            }
            List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
            ops = null;
            try {
                ops = (List)((Map)context.get(0)).get("Operations");
            }
            catch (Exception e) {
                if (((List)context.get(1)).isEmpty()) break block7;
                ops = (List)((Map)((List)context.get(1)).get(0)).get("Operations");
            }
        }
        Optional<Object> optional = value = ops == null ? Optional.empty() : ops.stream().filter(o -> operationKey.equals(o.get("Key"))).findFirst();
        if (!value.isPresent()) {
            return "";
        }
        Map op = (Map)value.get();
        String PERMISSION_ITEM_ID = "PermissionItemId";
        if (!"submitandnew".equalsIgnoreCase((String)op.get("OperationType"))) {
            if (StringUtils.isEmpty((String)((String)op.get("PermissionItemId")))) {
                return "";
            }
            return (String)op.get("PermissionItemId");
        }
        Optional<Map> submit = ops.stream().filter(o -> "submit".equals(o.get("OperationType"))).findFirst();
        if (!submit.isPresent() || StringUtils.isEmpty((String)((String)submit.get().get("PermissionItemId")))) {
            return "";
        }
        return (String)submit.get().get("PermissionItemId");
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "fopkey": {
                this.showOperationSelector(evt);
                break;
            }
            case "fopicon": {
                this.showImageSelector(evt);
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void showOperationSelector(EventObject evt) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        this.setOperations(context);
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("context", (Object)context);
        param.setFormId("ide_operationselect");
        param.setCustomParam("designerPageId", this.getView().getFormShowParameter().getCustomParam("designerPageId"));
        param.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        param.setCustomParam("designerEntityId", this.getView().getFormShowParameter().getCustomParam("designerEntityId"));
        param.setCustomParam("lastEntityVersion", this.getView().getFormShowParameter().getCustomParam("lastEntityVersion"));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOperation"));
        this.getView().showForm(param);
    }

    private void setOperations(List<Object> context) {
        List ops;
        block4: {
            ops = null;
            try {
                ops = (List)((Map)context.get(0)).get("Operations");
            }
            catch (Exception e) {
                if (((List)context.get(1)).isEmpty()) break block4;
                ops = (List)((Map)((List)context.get(1)).get(0)).get("Operations");
            }
        }
        if (ops != null) {
            String operations = this.getPageCache().get("selectedOperations");
            if (StringUtils.isEmpty((String)operations)) {
                return;
            }
            List cachedOps = SerializationUtils.fromJsonStringToList((String)operations, Map.class);
            ops.clear();
            ops.addAll(cachedOps);
        }
    }

    private void showImageSelector(EventObject evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_vectorlist");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectImage"));
        this.getView().showForm(parameter);
    }

    private boolean isBlankLocaleVlue(ILocaleString localeString) {
        if (localeString == null || localeString.size() == 0) {
            return true;
        }
        for (Map.Entry entry : localeString.entrySet()) {
            if (!StringUtils.isNotEmpty((String)((String)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    private void returnData() {
        HashSet<String> items = new HashSet<String>(16);
        ArrayList<Map<String, Object>> currItems = new ArrayList<Map<String, Object>>(10);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(this.entryKey);
        for (int i = 0; i < rowCount; ++i) {
            Object opname = model.getValue(FOP_NAME, i);
            if (opname instanceof ILocaleString && this.isBlankLocaleVlue((ILocaleString)opname)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u64cd\u4f5c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OperationColItemEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (StringUtils.isBlank((String)((String)model.getValue(FOP_KEY, i)))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u64cd\u4f5c\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OperationColItemEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            OperationColItem item = new OperationColItem((String)model.getValue("fopid", i), Integer.parseInt(model.getValue("fshowstyle", i).toString()), LocaleString.fromMap((Map)((Map)opname)), (String)model.getValue(FOP_KEY, i), (String)model.getValue(FOP_ICON, i), model.getValue(FVISIBLE, i) == null ? true : Boolean.parseBoolean(model.getValue(FVISIBLE, i).toString()), (String)model.getValue("fforecolor", i), (String)model.getValue("ffontsize", i));
            if (items.contains(item.getOperationKey())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u64cd\u4f5c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u6dfb\u52a0\u91cd\u590d\u7684\u64cd\u4f5c\u3002", (String)"OperationColItemEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (model.getValue(FPERMISSIONID, i) != null) {
                item.setPermissionId((String)model.getValue(FPERMISSIONID, i));
            }
            items.add(item.getOperationKey());
            DcJsonSerializer serializer = new DcJsonSerializer(new DcBinder(){

                public IDataEntityType tryBindToType(String paramString, Map<String, String> paramMap) {
                    return OrmUtils.getDataEntityType(OperationColItem.class);
                }
            });
            Map serializeToMap = serializer.serializeToMap((Object)item, null);
            serializeToMap.put("visible", item.isVisible());
            currItems.add(serializeToMap);
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, currItems);
        para.put("alias", this.getAlias(currItems));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
        int rowKey = grid.getEntryState().getFocusRow();
        if ("selectOperation".equalsIgnoreCase(actionId)) {
            Object retData = evt.getReturnData();
            if (retData instanceof Map) {
                this.getModel().setValue(FOP_KEY, (Object)((String)((Map)retData).get(VALUE)), rowKey);
                this.getModel().setValue(FOP_NAME, (Object)((String)((Map)retData).get("opName")), rowKey);
                this.getModel().setValue(FPERMISSIONID, (Object)((String)((Map)retData).get("opPermissionId")), rowKey);
            } else {
                this.getModel().setValue(FOP_KEY, ((Map)((List)retData).get(0)).get(VALUE), rowKey);
                this.getModel().setValue(FOP_NAME, ((Map)((List)retData).get(0)).get("opName"), rowKey);
                this.getModel().setValue(FPERMISSIONID, ((Map)((List)retData).get(0)).get("opPermissionId"), rowKey);
            }
        } else if ("selectImage".equalsIgnoreCase(actionId)) {
            Map imgData = (Map)evt.getReturnData();
            this.getModel().setValue(FOP_ICON, imgData.get(VALUE), rowKey);
        }
    }

    private Object getAlias(List<Map<String, Object>> items) {
        if (items == null || items.isEmpty()) {
            return " ";
        }
        StringBuilder alias = new StringBuilder();
        for (Map<String, Object> item : items) {
            alias.append(alias.length() == 0 ? alias.toString() : "; ").append(item.get(OPERATION_NAME).toString());
        }
        return alias.toString();
    }
}

