/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.entity.operation.OperationTypeLoader;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class OperationTypeSelectPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String KEY_ENTRY = "entryentity";
    private static final String KEY_SEQ = "fid";
    private static final String KEY_OP_TYPE_ID = "ftype";
    private static final String KEY_NAME = "fname";
    private static final String KEY_DESC = "fcode";
    private static final String[] entityOpParams = new String[]{"fvalidruledes", "fservice", "fserviceplugin", "fservicedesc"};

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("EntryEntity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String formId = null;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        if (entityId != null) {
            formId = entityId;
        } else {
            List context = (List)this.getView().getFormShowParameter().getCustomParams().get("MetaContext");
            if (context == null || context.isEmpty() || !((Map)context.get(0)).containsKey("_Type_")) {
                return;
            }
            formId = (String)((Map)context.get(0)).get("Id");
        }
        DesignMeta designMeta = (DesignMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)OrmUtils.getDataEntityType(DesignFormMeta.class), (Boolean)false);
        String modelType = designMeta.getModelType();
        if (modelType.startsWith("ParameterFormModel")) {
            modelType = "DynamicFormModel";
        }
        String appNumber = this.readAppNumber(designMeta.getBizappId());
        String entityNumber = designMeta.getNumber();
        ArrayList<String> appNumbers = new ArrayList<String>(10);
        String bizAppId = designMeta.getBizappId();
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            this.getParentAppNUmbers(bizAppId, appNumbers);
        }
        OperationTypes opTypes = OperationTypeLoader.loadAll((String)modelType, appNumbers, (String)entityNumber);
        opTypes.getOpTypes().sort(new Comparator<OperationType>(){

            @Override
            public int compare(OperationType o1, OperationType o2) {
                return Long.compare(o1.getSeq(), o2.getSeq());
            }
        });
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY);
        if (rowCount < opTypes.getOpTypes().size()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY, opTypes.getOpTypes().size() - rowCount);
        }
        int optionIndex = -1;
        for (int i = 0; i < opTypes.getOpTypes().size(); ++i) {
            OperationType opType = (OperationType)opTypes.getOpTypes().get(i);
            if ("option".equals(opType.getId())) {
                optionIndex = i;
            }
            this.getModel().setValue(KEY_SEQ, (Object)opType.getSeq(), i);
            this.getModel().setValue(KEY_OP_TYPE_ID, (Object)opType.getId(), i);
            this.getModel().setValue(KEY_NAME, (Object)opType.getName().toString(), i);
            this.getModel().setValue(KEY_DESC, (Object)(opType.getDesc() == null ? opType.getName().toString() : opType.getDesc().toString()), i);
        }
        if (optionIndex >= 0) {
            this.getModel().getEntryEntity(KEY_ENTRY).remove(optionIndex);
        }
    }

    private void getParentAppNUmbers(String bizAppId, List<String> appNumbers) {
        Object parentId;
        DynamicObject appDynamicObject = BizAppServiceHelp.getParentIdAndNumberByAppId((String)bizAppId);
        if (appDynamicObject == null) {
            return;
        }
        Object number = appDynamicObject.get("number");
        if (StringUtils.isNotBlank((Object)number)) {
            appNumbers.add((String)number);
        }
        if (StringUtils.isNotBlank((Object)(parentId = appDynamicObject.get("parentid")))) {
            this.getParentAppNUmbers((String)parentId, appNumbers);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRY);
        int rowKey = grid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        if (rowKey >= 0) {
            HashMap<String, Object> op = new HashMap<String, Object>();
            op.put("FCode", model.getValue(KEY_OP_TYPE_ID, rowKey));
            op.put("FName", model.getValue(KEY_NAME, rowKey));
            op.put("FType", model.getValue(KEY_OP_TYPE_ID, rowKey));
            IFormView parentFormView = this.getView().getParentView();
            String operateName = (String)op.get("FCode");
            if (operateName != null) {
                parentFormView.setVisible(Boolean.valueOf(OperationTypeCache.isEntityOperation((String)operateName)), entityOpParams);
            }
            this.getView().returnDataToParent(op);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OperationTypeSelectPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent();
        this.getView().close();
    }

    private String readAppNumber(String bizAppId) {
        Object[] sqlParas = new SqlParameter[]{new SqlParameter("FID", 12, (Object)bizAppId)};
        String sql = "select FID, FNumber from t_meta_bizapp where fid = ? ";
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParas, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String appnumber = null;
                while (rs.next()) {
                    appnumber = rs.getString("FNumber");
                }
                return appnumber;
            }
        });
    }
}

