/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;

public class ParameterFormSelectorPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "formlist";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String NUMBER = "number";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "reset"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        List formList;
        super.afterCreateNewData(evt);
        String propertyName = (String)this.getView().getFormShowParameter().getCustomParam(PROPERTY_NAME);
        StringBuilder sql = new StringBuilder("select a.FID, a.FNumber,b.FNAME, a.FMODELTYPE,a.FEntityId,a.FInheritPath from T_META_FORMDESIGN a left join T_META_FORMDESIGN_L b on a.FID = b.FID and b.FLOCALEID = ?   WHERE 1=1 ");
        if ("UserOption".equals(propertyName)) {
            sql.append(" and a.FMODELTYPE = 'ParameterFormModel_option' ");
        } else if ("ListUserOption".equals(propertyName)) {
            sql.append(" and a.FMODELTYPE = 'ParameterFormModel_listoption' ");
        } else if ("BillParameter".equals(propertyName)) {
            sql.append(" and a.FMODELTYPE = 'ParameterFormModel_bill' ");
        } else if ("BillTypePara".equals(propertyName)) {
            sql.append(" and a.FMODELTYPE = 'ParameterFormModel_billtype' ");
        }
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)Lang.get().toString())}, rs -> {
                ArrayList list = new ArrayList();
                try {
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        String number = rs.getString(2);
                        String name = rs.getString(3);
                        map.put(NUMBER, number);
                        map.put("name", StringUtils.isNotBlank((CharSequence)name) ? name : number);
                        String modelType = rs.getString(4);
                        map.put("modelType", modelType);
                        map.put("entityid", rs.getString(5));
                        map.put("inheritpath", rs.getString(6));
                        list.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return list;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (formList.size() > 0) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(ENTRY_KEY);
            if (formList.size() - count > 0) {
                model.batchCreateNewEntryRow(ENTRY_KEY, formList.size() - count);
                int i = 0;
                for (Map form : formList) {
                    model.setValue(NUMBER, form.get(NUMBER), i);
                    model.setValue("name", form.get("name"), i);
                    model.setValue("modeltype", form.get("modelType"), i);
                    ++i;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        } else if ("reset".equals(key)) {
            HashMap para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put("value", null);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void returnData() {
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_KEY);
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && row >= 0) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put("value", this.getModel().getValue(NUMBER, row));
            this.getView().returnDataToParent(para);
            this.getView().close();
        } else {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c", (String)"ParameterFormSelectorPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c", (String)"ParameterFormSelectorPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnData();
    }
}

