/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PermitemsSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "reset"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isBlank(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6743\u9650\u9879\u4e3a\u7a7a\u3002", (String)"PermitemsSelectPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        List list = new ArrayList();
        if (value instanceof List) {
            list = (List)value;
        }
        ArrayList<String> ids = new ArrayList<String>(list.size());
        for (Map map : list) {
            ids.add((String)map.get("ItemId"));
        }
        List<Map<String, String>> permItems = this.getPermItemsByIds(ids);
        if (permItems.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowKeys = model.batchCreateNewEntryRow(ENTRY_KEY, permItems.size());
            int i = 0;
            for (Map<String, String> permItem : permItems) {
                model.setValue("id", (Object)permItem.get("id"), rowKeys[i]);
                model.setValue(NUMBER, (Object)permItem.get(NUMBER), rowKeys[i]);
                model.setValue("name", (Object)permItem.get("name"), rowKeys[i]);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equals(btn.getKey())) {
            this.saveData();
        } else if ("reset".equals(btn.getKey())) {
            HashMap item = new HashMap();
            HashMap para = new HashMap();
            para.put(VALUE, item);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private void saveData() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        int selRow = entryGrid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        HashMap<String, Object> item = new HashMap<String, Object>();
        if (selRow > -1 && count > 0) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRY_KEY, selRow);
            item.put("_Type_", "PermissionItem");
            item.put("ItemId", dynamicObject.get("id"));
            item.put("Index", 0);
            HashMap<String, HashMap<String, Object>> para = new HashMap<String, HashMap<String, Object>>();
            para.put(VALUE, item);
            this.getView().returnDataToParent(para);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6743\u9650\u9879\u3002", (String)"PermitemsSelectPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    private List<Map<String, String>> getPermItemsByIds(List<String> ids) {
        ArrayList<Map<String, String>> permItems = new ArrayList<Map<String, String>>(10);
        if (ids == null || ids.size() <= 0) {
            return permItems;
        }
        Map loadFromCache = BusinessDataReader.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_permitem"));
        for (Map.Entry entry : loadFromCache.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            map.put(NUMBER, dynamicObject.get(NUMBER).toString());
            permItems.add(map);
        }
        return permItems;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.saveData();
    }
}

