/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.plugin.manager.EventAction;
import kd.bos.entity.plugin.manager.EventMethod;
import kd.bos.entity.plugin.manager.EventMethodTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import org.apache.log4j.Logger;

public class PluginsPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener {
    private static Logger log = Logger.getLogger(PluginsPlugin.class);
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    public static final String PLUGIN_CLASS_NAME = "ClassName";
    public static final String PLUGIN_ENABLE_NAME = "Enabled";
    public static final String PLUGIN_DESCRIPTION_NAME = "Description";
    public static final String PLUGIN_DISPLAYNAME_NAME = "DisplayName";
    public static final String PLUGIN_TYPE_NAME = "Type";
    public static final String PLUGIN_FPK_NAME = "FPK";
    public static final String PLUGIN_BIZAPPID_NAME = "BizAppId";
    public static final String PLUGIN_ISINHERIT = "Inherit";
    public static final String ENTRY_CLASS_NAME = "classname";
    public static final String ENTRY_ENABLE_NAME = "enabled";
    public static final String ENTRY_DESCRIPTION_NAME = "description";
    public static final String ENTRY_DISPLAYNAME_NAME = "displayname";
    public static final String ENTRY_TYPE_NAME = "type";
    public static final String ENTRY_FPK_NAME = "fpk";
    public static final String ENTRY_BIZAPPID_NAME = "bizappid";
    public static final String ENTRY_ISINHERIT = "isinherit";
    public static final String ROW_KEY_NAME = "RowKey";
    private static final String BTN_REGISTER = "register";
    private static final String BTN_REGISTERJS = "registerjs";
    private static final String BTN_REGISTERTS = "registerts";
    private static final String BTN_SELECTTS = "selectts";
    private static final String VALUE = "value";
    private static final String[] ITEMS = new String[]{"edit", "moveup", "movedown", "unregister"};
    private static final String BTN_EDIT = "edit";
    private static final String BTN_MOVEUP = "moveup";
    private static final String BTN_MOVEDOWN = "movedown";
    private static final String BTN_UNREGISTER = "unregister";
    private static final String BTN_EVENTADD = "eventadd";
    private static final String BTN_EVENTEDIT = "eventedit";
    private static final String BTN_EVENTDELETE = "eventdelete";
    private static final String PARENTPLUGINSDISABLE = "parentPluginsDisable.on";
    private static final String ENTRY_KEY = "entryentity";
    private static final String PARAM_ITEM_ID = "itemId";
    private static final String PLUGIN_EVENTS = "Events";
    private static final String PLUGIN_EVENT_ID = "Id";
    private static final String PLUGIN_EVENT_ACTION = "Action";
    private static final String PLUGIN_EVENT_PARAM_CONDITION = "ParamCondition";
    private static final String PLUGIN_EVENT_SIMPLE_EXPR = "SimpleExpr";
    private static final String PLUGIN_EVENT_EXPRESSION = "Expression";
    private static final String PLUGIN_EVENT_REMARK = "Remark";
    private static final String ENTRY_EVENT_ENTRY_KEY = "entryentity1";
    private static final String ENTRY_EVENT_CLASS_NAME = "classnamecombo";
    private static final String ENTRY_EVENT_NAME = "eventname";
    private static final String ENTRY_EVENT_ID = "eventid";
    private static final String ENTRY_EVENT_SIMPLE_EXPR = "simpleexpr";
    private static final String ENTRY_EVENT_EXPRESSION = "expression";
    private static final String ENTRY_EVENT_ACTION = "eventaction";
    private static final String ENTRY_EVENT_REMARK = "remark";
    private static final String EVENT_TAB = "eventtab";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_REGISTER, BTN_REGISTERJS, BTN_EDIT, BTN_UNREGISTER, "ok", "exit", "vectorap", "labelap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals(BTN_REGISTERJS)) {
            List plugins = (List)e.getReturnData();
            for (Map plugin : plugins) {
                List<Map<String, Object>> currents = this.getPluginsFromEntryEntity();
                boolean bExist = false;
                for (Map<String, Object> current : currents) {
                    if (!plugin.get(PLUGIN_CLASS_NAME).equals(current.get(PLUGIN_CLASS_NAME))) continue;
                    bExist = true;
                    break;
                }
                if (bExist) continue;
                this.addToModel(plugin);
            }
        } else if (e.getActionId().equals(BTN_REGISTER)) {
            Map plugin = (Map)e.getReturnData();
            int iTestType = 0;
            plugin.put(ROW_KEY_NAME, iTestType);
            this.addToModel(plugin);
        } else if (BTN_REGISTERTS.equalsIgnoreCase(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            this.addToModel(plugin);
        } else if (BTN_EDIT.equals(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            int rowKey = (Integer)plugin.get(ROW_KEY_NAME);
            this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowKey);
            this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowKey);
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowKey);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowKey);
            this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowKey);
            this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowKey);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowKey);
        } else if ("addevent".equals(e.getActionId())) {
            this.addToEventModel((Map)e.getReturnData());
        } else if ("editevent".equals(e.getActionId())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_EVENT_ENTRY_KEY);
            this.editEventModel((Map)e.getReturnData(), grid.getEntryState().getFocusRow());
        }
    }

    private void addToModel(Map<String, Object> plugin) {
        plugin.put("_Type_", "Plugin");
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
        this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowIndex);
        this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowIndex);
        this.getModel().setValue(ENTRY_ISINHERIT, (Object)"1", rowIndex);
        this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
        this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowIndex);
        this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowIndex);
        this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowIndex);
        this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
        plugin.put(ROW_KEY_NAME, rowIndex);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        grid.clearEntryState();
    }

    private List<Map<String, Object>> getPluginsFromEntryEntity() {
        ArrayList<Map<String, Object>> newPlugins = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        boolean hasIsInheritProp = doc.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_ISINHERIT);
        int rowIndex = 0;
        for (DynamicObject obj : doc) {
            String isInheritValue;
            HashMap<String, Object> mapPlugin = new HashMap<String, Object>(16);
            mapPlugin.put(ROW_KEY_NAME, rowIndex++);
            mapPlugin.put(PLUGIN_ENABLE_NAME, obj.getBoolean(ENTRY_ENABLE_NAME));
            mapPlugin.put(PLUGIN_CLASS_NAME, obj.getString(ENTRY_CLASS_NAME));
            mapPlugin.put(PLUGIN_DESCRIPTION_NAME, obj.getString(ENTRY_DESCRIPTION_NAME));
            mapPlugin.put(PLUGIN_DISPLAYNAME_NAME, obj.getString(ENTRY_DISPLAYNAME_NAME));
            mapPlugin.put(PLUGIN_TYPE_NAME, obj.getInt(ENTRY_TYPE_NAME));
            mapPlugin.put(PLUGIN_FPK_NAME, obj.getString(ENTRY_FPK_NAME));
            mapPlugin.put(PLUGIN_BIZAPPID_NAME, obj.getString(ENTRY_BIZAPPID_NAME));
            if (hasIsInheritProp && (isInheritValue = (String)this.getModel().getValue(ENTRY_ISINHERIT, rowIndex - 1)) != null) {
                Boolean ish = "0".equals(isInheritValue);
                mapPlugin.put(PLUGIN_ISINHERIT, ish);
            }
            newPlugins.add(mapPlugin);
        }
        return newPlugins;
    }

    private void register() {
        this.openPluginJavaClass(BTN_REGISTER);
    }

    private void openPluginJavaClass(String sCallBackFlag) {
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put("formId", "ide_registerplugin");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID));
        showParameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sCallBackFlag));
        this.getView().showForm(showParameter);
    }

    private void registerTs() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParams().get(ENTRY_BIZAPPID_NAME);
        String id = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_kingscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REGISTERTS));
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam("bizpagenumber", (Object)this.getFormId());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
        parameter.setCustomParam("modelType", (Object)modelType);
        parameter.setCustomParam("scripttypefilter", (Object)this.getScriptTypeFilter());
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        parameter.setCustomParam("isPC", this.getView().getFormShowParameter().getCustomParam("isPC"));
        parameter.setCustomParam("formApType", this.getView().getFormShowParameter().getCustomParam("_Type_"));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCustomParam(VALUE, (Object)SerializationUtils.toJsonString(this.getPluginsFromEntryEntity()));
        this.getView().showForm(parameter);
    }

    private String getScriptTypeFilter() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParams().get("scriptfiltertype");
        if (StringUtils.isBlank((CharSequence)scriptTypeFilter)) {
            scriptTypeFilter = "MobileFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) ? "mobpage" : ("PrintModel".equals(modelType) ? "printpage" : "page");
        }
        return scriptTypeFilter;
    }

    private void registerjs() {
        this.openPluginJavaScript(BTN_REGISTERJS, BTN_REGISTERJS);
    }

    private void openPluginJavaScript(String sCallBackFlag, String type) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParams().get("scriptfiltertype");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParams().get(ENTRY_BIZAPPID_NAME);
        if (StringUtils.isBlank((CharSequence)scriptTypeFilter)) {
            scriptTypeFilter = "MobileFormModel".equals(modelType) || "MobUserGuideFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType) ? "mobpage" : ("PrintModel".equals(modelType) ? "printpage" : "page");
        }
        String engineType = BTN_REGISTERTS.equals(type) ? "1" : "0";
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)BOS_DESIGNER_PLUGIN).getLocaleValue());
        parameter.setFormId("ide_register_ks_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sCallBackFlag));
        parameter.setCustomParam("bizpagenumber", (Object)this.getFormId());
        parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
        parameter.setCustomParam("engineType", (Object)engineType);
        if ("1".equals(engineType)) {
            parameter.setCustomParam("modelType", (Object)modelType);
        }
        parameter.setCustomParam("scripttypefilter", (Object)scriptTypeFilter);
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
            parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)bizAppId);
        }
        parameter.setCustomParam(VALUE, (Object)SerializationUtils.toJsonString(this.getPluginsFromEntryEntity()));
        this.getView().showForm(parameter);
    }

    private String getFormId() {
        String formId = null;
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        IFormView designerView = propertyEditHelper.getDesignFormView(this.getView());
        if (designerView != null) {
            formId = (String)designerView.getFormShowParameter().getCustomParam("number");
        }
        if (StringUtils.isBlank(formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        if (StringUtils.isBlank(formId)) {
            formId = this.getView().getFormShowParameter().getParentFormId();
        }
        return formId;
    }

    private void unRegister() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int entryRowKey = grid.getEntryState().getFocusRow();
        if (StringUtils.isNotBlank((Object)entryRowKey) && entryRowKey != -1) {
            this.getModel().deleteEntryRow(ENTRY_KEY, entryRowKey);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PluginsPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void closeAndreturnData() {
        HashMap para = new HashMap(16);
        para.put(PARAM_ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(PARAM_ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        List<Map<String, Object>> plugins = this.getPluginsFromEntryEntity();
        this.addEvents(plugins);
        para.put(VALUE, plugins);
        para.put("alias", "");
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "ok": {
                this.closeAndreturnData();
                break;
            }
            case "exit": {
                this.getView().close();
                break;
            }
            case "vectorap": 
            case "labelap": {
                String url = "https://vip.kingdee.com/knowledge/specialDetail/218022218066869248?category=475348362024443392&id=339836302126892544&productLineId=29&lang=";
                String lang = "zh-CN";
                if (Lang.get() != Lang.zh_TW && Lang.get() != Lang.zh_CN) {
                    lang = "en-US";
                }
                url = url + lang;
                this.getView().openUrl(url);
                break;
            }
        }
    }

    private void lockAddItem() {
        String id = "";
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        id = item != null && !item.isEmpty() ? (String)((Map)item.get(0)).get(PLUGIN_EVENT_ID) : (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID);
        if (StringUtils.isBlank((CharSequence)id)) {
            id = MetadataDao.getIdByNumber((String)((String)this.getView().getFormShowParameter().getCustomParam("formId")), (MetaCategory)MetaCategory.Entity);
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        AbstractMetadata metadata = MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        if (metadata == null) {
            metadata = MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        }
        if (metadata == null) {
            return;
        }
        ExtLockTypeEnum lockType = ExtLockTypeEnum.defaults;
        String opId = (String)this.getView().getFormShowParameter().getCustomParam("opId");
        lockType = StringUtils.isNotBlank((CharSequence)opId) ? ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Operation", (String)metadata.getModelType(), (String)opId, (String)"serverplugin") : ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)metadata.getModelType(), (String)id, (String)"Plugins");
        if (lockType == ExtLockTypeEnum.lock) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_REGISTER, BTN_REGISTERJS, BTN_REGISTERTS, BTN_EDIT, BTN_MOVEUP, BTN_MOVEDOWN, BTN_UNREGISTER});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object propertyName = this.getView().getFormShowParameter().getCustomParams().get("propertyName");
        if (StringUtils.isNotBlank(propertyName) && "ReportPluginExt".equals(propertyName)) {
            this.getView().getFormShowParameter().getCustomParams().put("scriptfiltertype", "ReportPluginExt");
        }
        if (StringUtils.isNotBlank(propertyName) && "BasedataControllers".equals(propertyName)) {
            this.getView().getFormShowParameter().getCustomParams().put("scriptfiltertype", "BaseDataController");
        }
        this.getView().cacheFormShowParameter();
        this.lockAddItem();
        ArrayList<Object> valJson = new ArrayList();
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) {
            valJson = value;
        }
        List plugins = valJson;
        this.sortPlugins(plugins);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        boolean hasIsInheritProp = doc.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_ISINHERIT);
        for (Map plugin : plugins) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
            this.getModel().setValue(ENTRY_CLASS_NAME, plugin.get(PLUGIN_CLASS_NAME), rowIndex);
            if (plugin.get(PLUGIN_ENABLE_NAME) == null) {
                this.getModel().setValue(ENTRY_ENABLE_NAME, (Object)false, rowIndex);
            } else {
                this.getModel().setValue(ENTRY_ENABLE_NAME, plugin.get(PLUGIN_ENABLE_NAME), rowIndex);
            }
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, plugin.get(PLUGIN_DISPLAYNAME_NAME), rowIndex);
            this.getModel().setValue(ENTRY_TYPE_NAME, plugin.get(PLUGIN_TYPE_NAME), rowIndex);
            this.getModel().setValue(ENTRY_FPK_NAME, plugin.get(PLUGIN_FPK_NAME), rowIndex);
            this.getModel().setValue(ENTRY_BIZAPPID_NAME, plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
            if (!hasIsInheritProp) continue;
            Object obj = plugin.get(PLUGIN_ISINHERIT);
            if (obj != null) {
                boolean inherit = (Boolean)obj;
                String str = inherit ? "0" : "1";
                this.getModel().setValue(ENTRY_ISINHERIT, (Object)str, rowIndex);
                if (!inherit || !this.getParentPluginsDisable()) continue;
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ENTRY_ENABLE_NAME});
                continue;
            }
            this.getModel().setValue(ENTRY_ISINHERIT, (Object)"1", rowIndex);
        }
        this.loadEvents(plugins);
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        String modelType = propertyEditHelper.getModelType(this.getView());
        boolean eventTabVisible = false;
        if (StringUtils.isBlank((CharSequence)propertyEditHelper.getSubDesignerName(this.getView())) && (StringUtils.equalsIgnoreCase((CharSequence)modelType, (CharSequence)"BillFormModel") || StringUtils.equalsIgnoreCase((CharSequence)modelType, (CharSequence)"BaseFormModel") || StringUtils.equalsIgnoreCase((CharSequence)modelType, (CharSequence)"DynamicFormModel"))) {
            Boolean showeventtab = (Boolean)this.getView().getFormShowParameter().getCustomParam("showeventtab");
            boolean bl = eventTabVisible = showeventtab == null || showeventtab != false;
        }
        if (!eventTabVisible) {
            this.getView().updateControlMetadata(EVENT_TAB, (Map)new HashMap<String, Object>(){
                {
                    this.put("vi", 0);
                }
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String modelType = this.getModelType();
        if (Plugin.enableRegisterKingScript((String)modelType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REGISTERTS});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REGISTERJS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REGISTERTS});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REGISTERJS});
        }
    }

    private void sortPlugins(List<Map<String, Object>> plugins) {
        Collections.sort(plugins, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Integer rowkey1 = 0;
                Integer rowkey2 = 0;
                if (StringUtils.isNotBlank((Object)o1.get(PluginsPlugin.ROW_KEY_NAME))) {
                    rowkey1 = (Integer)o1.get(PluginsPlugin.ROW_KEY_NAME);
                }
                if (StringUtils.isNotBlank((Object)o2.get(PluginsPlugin.ROW_KEY_NAME))) {
                    rowkey2 = (Integer)o2.get(PluginsPlugin.ROW_KEY_NAME);
                }
                return rowkey1.compareTo(rowkey2);
            }
        });
    }

    private void editPlugin() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && rowKey >= 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            Map<String, Object> currentPlugin = this.getCurrentPlugin(rowKey);
            parameter.setCustomParam("isEdit", (Object)"isEdit");
            parameter.setCustomParam("rowKey", (Object)rowKey);
            parameter.setCustomParam("plugin", currentPlugin);
            parameter.setCustomParam("formnumber", (Object)this.getFormId());
            parameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
            int type = 0;
            if (currentPlugin.get(PLUGIN_TYPE_NAME) != null) {
                type = (Integer)currentPlugin.get(PLUGIN_TYPE_NAME);
            }
            switch (type) {
                case 1: {
                    parameter.setFormId("ide_edit_ks_plugin");
                    break;
                }
                case 4: {
                    if (!Plugin.enableRunKingScript()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"PluginsPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    String id = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID);
                    parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                    parameter.setCustomParam("id", (Object)id);
                    parameter.setCustomParam("bizpagenumber", (Object)this.getFormId());
                    parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
                    parameter.setCustomParam("scripttypefilter", (Object)this.getScriptTypeFilter());
                    parameter.setFormId("ide_register_ts_plugin");
                    String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)((String)parameter.getCustomParam(ENTRY_BIZAPPID_NAME)), (String)((String)parameter.getCustomParam("bizpagenumber")));
                    parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
                    break;
                }
                default: {
                    parameter.setFormId("ide_registerplugin");
                }
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_EDIT));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PluginsPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private Map<String, Object> getCurrentPlugin(int rowKey) {
        List<Map<String, Object>> plugins = this.getPluginsFromEntryEntity();
        return plugins.get(rowKey);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_REGISTER.equalsIgnoreCase(key)) {
            this.register();
        } else if (BTN_REGISTERJS.equalsIgnoreCase(key)) {
            this.registerjs();
        } else if (BTN_REGISTERTS.equalsIgnoreCase(key)) {
            this.registerTs();
        } else if (BTN_SELECTTS.equalsIgnoreCase(key)) {
            this.openPluginJavaScript(BTN_REGISTERJS, BTN_REGISTERTS);
        } else if (BTN_EDIT.equalsIgnoreCase(key)) {
            this.editPlugin();
        } else if (BTN_UNREGISTER.equalsIgnoreCase(key)) {
            this.unRegister();
        } else if (BTN_EVENTADD.equalsIgnoreCase(key)) {
            this.eventAdd();
        } else if (BTN_EVENTEDIT.equalsIgnoreCase(key)) {
            this.eventEdit();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), ITEMS);
        int index = evt.getRow();
        this.setItemsEnable(index);
    }

    private void setItemsEnable(int index) {
        String modelType;
        String extensible;
        if (index < 0) {
            return;
        }
        String value = (String)this.getModel().getValue(ENTRY_ISINHERIT, index);
        if ("0".equals(value) && this.getParentPluginsDisable()) {
            this.getView().setEnable(Boolean.valueOf(false), ITEMS);
        }
        if ("0".equals(extensible = (String)this.getModel().getValue(ENTRY_ISINHERIT, index - 1)) && this.getParentPluginsDisable()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_MOVEUP});
        }
        if (!Plugin.enableRegisterKingScript((String)(modelType = this.getModelType()))) {
            Map<String, Object> currentPlugin = this.getCurrentPlugin(index);
            int type = 0;
            if (currentPlugin.get(PLUGIN_TYPE_NAME) != null) {
                type = (Integer)currentPlugin.get(PLUGIN_TYPE_NAME);
            }
            if (4 == type) {
                this.getView().setEnable(Boolean.valueOf(false), ITEMS);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 0) {
            int index = selectRows[0];
            this.setItemsEnable(index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("moveentryup".equals(e.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
            int[] selectRows = entryGrid.getSelectRows();
            int currentRow = selectRows[0];
            String isInherit = (String)this.getModel().getValue(ENTRY_ISINHERIT, currentRow - 1);
            if ("0".equals(isInherit) && this.getParentPluginsDisable()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_MOVEUP});
            }
        } else if ("moveentrydown".equals(e.getOperateKey())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BTN_MOVEUP});
        }
    }

    private boolean getParentPluginsDisable() {
        return Boolean.parseBoolean(System.getProperty(PARENTPLUGINSDISABLE, "true"));
    }

    private void loadEvents(List<Map<String, Object>> plugins) {
        LinkedHashMap eventListMap = new LinkedHashMap();
        for (Map<String, Object> map : plugins) {
            List events = map.get(PLUGIN_EVENTS) != null ? (List)map.get(PLUGIN_EVENTS) : new ArrayList();
            ArrayList eventList = (ArrayList)eventListMap.get(map.get(PLUGIN_CLASS_NAME));
            for (Object event : events) {
                if (Objects.isNull(eventList)) {
                    eventList = new ArrayList();
                }
                eventList.add(event);
            }
            eventListMap.putIfAbsent(map.get(PLUGIN_CLASS_NAME), eventList);
        }
        for (Map.Entry entry : eventListMap.entrySet()) {
            Object className = entry.getKey();
            List events = (List)entry.getValue();
            if (!Objects.nonNull(events) || events.isEmpty()) continue;
            for (Object event : events) {
                Map eventMap = (Map)event;
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_EVENT_ENTRY_KEY);
                this.getModel().setValue(ENTRY_EVENT_CLASS_NAME, className, rowIndex);
                this.getModel().setValue(ENTRY_EVENT_ID, eventMap.get(PLUGIN_EVENT_ID), rowIndex);
                EventMethod eventMethod = EventMethodTypes.getEventMethod((String)String.valueOf(eventMap.get(PLUGIN_EVENT_ID)));
                this.getModel().setValue(ENTRY_EVENT_NAME, (Object)eventMethod.getMethodName(), rowIndex);
                if (eventMap.get(PLUGIN_EVENT_PARAM_CONDITION) != null && eventMap.get(PLUGIN_EVENT_PARAM_CONDITION) instanceof Map) {
                    Map paramMap = (Map)eventMap.get(PLUGIN_EVENT_PARAM_CONDITION);
                    this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, paramMap.get(PLUGIN_EVENT_SIMPLE_EXPR), rowIndex);
                    this.getModel().setValue(ENTRY_EVENT_EXPRESSION, paramMap.get(PLUGIN_EVENT_EXPRESSION), rowIndex);
                }
                this.getModel().setValue(ENTRY_EVENT_ACTION, eventMap.get(PLUGIN_EVENT_ACTION), rowIndex);
                this.getModel().setValue(ENTRY_EVENT_REMARK, eventMap.get(PLUGIN_EVENT_REMARK), rowIndex);
            }
        }
    }

    private void addEvents(List<Map<String, Object>> plugins) {
        for (Map<String, Object> mapPlugin : plugins) {
            for (Map<String, Object> eventMap : this.getEventsFromEntryEntity()) {
                if (!Objects.equals(eventMap.get(ENTRY_EVENT_CLASS_NAME), mapPlugin.get(PLUGIN_CLASS_NAME))) continue;
                ArrayList events = mapPlugin.get(PLUGIN_EVENTS);
                if (Objects.isNull(events)) {
                    events = new ArrayList();
                }
                ((List)events).add(eventMap);
                mapPlugin.putIfAbsent(PLUGIN_EVENTS, events);
            }
        }
    }

    private List<Map<String, Object>> getEventsFromEntryEntity() {
        ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection eventDoc = this.getModel().getEntryEntity(ENTRY_EVENT_ENTRY_KEY);
        if (Objects.nonNull(eventDoc) && !eventDoc.isEmpty()) {
            for (DynamicObject obj : eventDoc) {
                HashMap<String, Object> eventMap = new HashMap<String, Object>(16);
                eventMap.put(ENTRY_EVENT_CLASS_NAME, obj.getString(ENTRY_EVENT_CLASS_NAME));
                eventMap.put(PLUGIN_EVENT_ID, obj.getString(ENTRY_EVENT_ID));
                eventMap.put(ENTRY_EVENT_NAME, obj.getString(ENTRY_EVENT_NAME));
                if (StringUtils.isNotBlank((CharSequence)obj.getString(ENTRY_EVENT_EXPRESSION))) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put(PLUGIN_EVENT_SIMPLE_EXPR, obj.getString(ENTRY_EVENT_SIMPLE_EXPR));
                    paramMap.put(PLUGIN_EVENT_EXPRESSION, obj.getString(ENTRY_EVENT_EXPRESSION));
                    eventMap.put(PLUGIN_EVENT_PARAM_CONDITION, paramMap);
                }
                eventMap.put(PLUGIN_EVENT_ACTION, StringUtils.isBlank((CharSequence)obj.getString(ENTRY_EVENT_ACTION)) ? EventAction.OVERRIDE.name() : obj.getString(ENTRY_EVENT_ACTION));
                eventMap.put(PLUGIN_EVENT_REMARK, obj.getString(ENTRY_EVENT_REMARK));
                events.add(eventMap);
            }
        }
        return events;
    }

    private void addToEventModel(Map<String, Object> eventMap) {
        for (Map<String, Object> eventPluginMap : this.getEventsFromEntryEntity()) {
            if (!Objects.equals(eventMap.get(ENTRY_EVENT_ID), eventPluginMap.get(PLUGIN_EVENT_ID)) || !Objects.equals(eventMap.get(ENTRY_EVENT_CLASS_NAME), eventPluginMap.get(ENTRY_EVENT_CLASS_NAME))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u4e8b\u4ef6\u3002", (String)"PluginsPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_EVENT_ENTRY_KEY);
        this.editEventModel(eventMap, rowIndex);
    }

    private void editEventModel(Map<String, Object> eventMap, int rowIndex) {
        this.getModel().setValue(ENTRY_EVENT_NAME, eventMap.get(ENTRY_EVENT_NAME), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_ID, eventMap.get(ENTRY_EVENT_ID), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_SIMPLE_EXPR, eventMap.get(ENTRY_EVENT_SIMPLE_EXPR), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_EXPRESSION, eventMap.get(ENTRY_EVENT_EXPRESSION), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_ACTION, (Object)EventAction.OVERRIDE.name(), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_CLASS_NAME, eventMap.get(ENTRY_EVENT_CLASS_NAME), rowIndex);
        this.getModel().setValue(ENTRY_EVENT_REMARK, eventMap.get(ENTRY_EVENT_REMARK), rowIndex);
    }

    private void eventAdd() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_addevent");
        parameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID));
        parameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
        List<Map<String, Object>> events = this.getEventsFromEntryEntity();
        parameter.setCustomParam("events", events);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addevent"));
        this.getView().showForm(parameter);
    }

    private void eventEdit() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_EVENT_ENTRY_KEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_EVENT_ENTRY_KEY) > 0 && rowIndex >= 0) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("ide_addevent");
            parameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParam(PARAM_ITEM_ID));
            parameter.setCustomParam("plugins", this.getPluginsFromEntryEntity());
            List<Map<String, Object>> events = this.getEventsFromEntryEntity();
            parameter.setCustomParam("events", events);
            parameter.setCustomParam("curevent", events.get(rowIndex));
            parameter.setCustomParam("rowIndex", (Object)rowIndex);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editevent"));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e8b\u4ef6\u3002", (String)"PluginsPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Toolbar advcontoolbarap = (Toolbar)this.getControl("advcontoolbarap");
        advcontoolbarap.deleteControls(new String[]{BTN_REGISTER, BTN_REGISTERJS, BTN_EDIT, BTN_MOVEUP, BTN_MOVEDOWN, BTN_UNREGISTER, BTN_EVENTADD, BTN_EVENTEDIT, BTN_EVENTDELETE, BTN_REGISTERTS, BTN_SELECTTS});
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        if (EVENT_TAB.equals(tabSelectEvent.getTabKey())) {
            items.add(this.createBarItem(BTN_EVENTADD, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"PluginsPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_3"), new String[0]));
            items.add(this.createBarItem(BTN_EVENTEDIT, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"PluginsPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_4"), new String[0]));
            items.add(this.createBarItem(BTN_EVENTDELETE, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"PluginsPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_5"), "deleteevententry"));
        } else {
            items.add(this.createBarItem(BTN_REGISTER, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u6ce8\u518c", (String)"PluginsPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_6"), new String[0]));
            String modelType = this.getModelType();
            if (Plugin.enableRegisterKingScript((String)modelType)) {
                items.add(this.createTsBarItem());
            } else {
                items.add(this.createBarItem(BTN_REGISTERJS, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u6ce8\u518c\u811a\u672c", (String)"PluginsPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_7"), new String[0]));
            }
            items.add(this.createBarItem(BTN_EDIT, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"PluginsPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_4"), new String[0]));
            items.add(this.createBarItem(BTN_MOVEUP, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u4e0a\u79fb", (String)"PluginsPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_8"), "moveentryup"));
            items.add(this.createBarItem(BTN_MOVEDOWN, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u4e0b\u79fb", (String)"PluginsPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_9"), "moveentrydown"));
            items.add(this.createBarItem(BTN_UNREGISTER, (Tuple<String, String>)Tuple.create((Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"PluginsPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), (Object)"PluginsPlugin_5"), new String[0]));
        }
        advcontoolbarap.addControls(items);
    }

    private Map<String, Object> createBarItem(String key, Tuple<String, String> name, String ... operationKey) {
        AdvConBarItemAp advConBarItemAp = new AdvConBarItemAp();
        advConBarItemAp.setId(key);
        if (operationKey != null && operationKey.length > 0) {
            advConBarItemAp.setOperationKey(operationKey[0]);
        }
        advConBarItemAp.setKey(key);
        advConBarItemAp.setName(ResManager.getLocaleString((String)((String)name.item1), (String)((String)name.item2), (String)BOS_DESIGNER_PLUGIN));
        return advConBarItemAp.createControl();
    }

    private Map<String, Object> createTsBarItem() {
        AdvConBarItemAp advConBarItemAp = new AdvConBarItemAp();
        advConBarItemAp.setId(BTN_REGISTERTS);
        advConBarItemAp.setOperationKey(BTN_REGISTERTS);
        advConBarItemAp.setKey(BTN_REGISTERTS);
        advConBarItemAp.setName(ResManager.getLocaleString((String)"\u6ce8\u518c\u811a\u672c", (String)"PluginsPlugin_7", (String)BOS_DESIGNER_PLUGIN));
        DropdownItem itemAP = new DropdownItem();
        itemAP.setId(BTN_SELECTTS);
        itemAP.setKey(BTN_SELECTTS);
        itemAP.setOperationKey("");
        itemAP.setTitle(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"PluginsPlugin_10", (String)BOS_DESIGNER_PLUGIN));
        advConBarItemAp.getDropdownItems().add(itemAP);
        return advConBarItemAp.createControl();
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        String scriptfiltertype = (String)this.getView().getFormShowParameter().getCustomParam("scriptfiltertype");
        if ("writebackplugin".equalsIgnoreCase(scriptfiltertype)) {
            modelType = "WriteBackRuleModel";
            return modelType;
        }
        if (StringUtils.isBlank((CharSequence)modelType) && StringUtils.isBlank((CharSequence)(modelType = (String)this.getView().getFormShowParameter().getCustomParam("formModelType")))) {
            PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
            modelType = propertyEditHelper.getModelType(this.getView());
        }
        return modelType;
    }
}

