/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;

public class ProFieldIdPlugin
extends AbstractPropertyPlugin {
    private boolean fromNewFormDesigner() {
        Object r = this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner");
        return Boolean.parseBoolean(r == null ? "false" : r.toString());
    }

    public static EntityItem<?> getBindEntityItem(List<List<Map<String, Object>>> context, String formItemId, String modelType) {
        FormMetadata form = ProFieldIdPlugin.getFormMetadata(context.get(1), modelType);
        EntityMetadata entityMeta = ProFieldIdPlugin.getEntityMetadata(context.get(0), modelType);
        form.createIndex(true);
        entityMeta.createIndex(true);
        ControlAp controlAp = form.getItem(formItemId);
        if (controlAp instanceof FieldAp) {
            String fieldId = ((FieldAp)controlAp).getFieldId();
            return entityMeta.getItemById(fieldId);
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        String modelType;
        String itemId;
        List data;
        List<EntityItem<?>> fields;
        if (!this.fromNewFormDesigner()) {
            this.getView().close();
        }
        if ((fields = this.getFields(data = (List)this.getView().getFormShowParameter().getCustomParams().get("context"), itemId = (String)this.getView().getFormShowParameter().getCustomParams().get("itemId"), modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType"))).size() > 0) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount("fields");
            if (fields.size() > count) {
                model.batchCreateNewEntryRow("fields", fields.size() - count);
            }
            int i = 0;
            for (EntityItem<?> item : fields) {
                model.setValue("fid", (Object)item.getId(), i);
                model.setValue("fkey", (Object)item.getKey(), i);
                model.setValue("fname", (Object)item.getName().toString(), i);
                ++i;
            }
        }
    }

    private static FormMetadata getFormMetadata(List<Map<String, Object>> formContext, String modelType) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formMeta.put("Items", formContext);
        formMeta.put("_Type_", "FormMetadata");
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        FormMetadata formMetadata = (FormMetadata)template.deserializeFromMap(formMeta, null);
        return formMetadata;
    }

    private static EntityMetadata getEntityMetadata(List<Map<String, Object>> formContext, String modelType) {
        HashMap<String, Object> formMeta = new HashMap<String, Object>();
        formContext.get(0).remove("ReportFilterMeta");
        formMeta.put("Items", formContext);
        formMeta.put("_Type_", "EntityMetadata");
        MetadataSerializer template = new MetadataSerializer(modelType);
        return (EntityMetadata)template.deserializeFromMap(formMeta, null);
    }

    private List<EntityItem<?>> getAvailableFields(String ctlId, FormMetadata form, EntityMetadata entity) {
        ControlAp control = form.getItem(ctlId);
        if (control == null) {
            return Collections.emptyList();
        }
        String pid = control.getParentId();
        if (StringUtils.isBlank((CharSequence)pid)) {
            return Collections.emptyList();
        }
        ControlAp parent = form.getItem(pid);
        if (parent instanceof FormAp) {
            List list = ((Entity)entity.getEntitys().get(0)).getItems();
            return ((Entity)entity.getEntitys().get(0)).getItems();
        }
        if (parent instanceof EntryAp) {
            return entity.getEntryById(((EntryAp)parent).getEntryId()) == null ? Collections.emptyList() : entity.getEntryById(((EntryAp)parent).getEntryId()).getItems();
        }
        return this.getAvailableFields(parent.getId(), form, entity);
    }

    private List<EntityItem<?>> getFields(List<List<Map<String, Object>>> context, String itemId, String modelType) {
        String fieldId;
        EntityItem entityItem2;
        if (context == null || context.size() < 2) {
            return Collections.emptyList();
        }
        String fieldType = "";
        for (Map<String, Object> it : context.get(1)) {
            if (!itemId.equals(it.get("Id"))) continue;
            Object type = it.get("FieldType");
            fieldType = type == null ? "" : type.toString();
            break;
        }
        FormMetadata form = ProFieldIdPlugin.getFormMetadata(context.get(1), modelType);
        EntityMetadata entityMeta = ProFieldIdPlugin.getEntityMetadata(context.get(0), modelType);
        form.createIndex(true);
        entityMeta.createIndex(true);
        ControlAp controlAp = form.getItem(itemId);
        if (StringUtils.isBlank((CharSequence)fieldType) && controlAp instanceof FieldAp && (entityItem2 = entityMeta.getItemById(fieldId = ((FieldAp)controlAp).getFieldId())) != null) {
            fieldType = entityItem2.getClass().getSimpleName();
        }
        String filterType = fieldType;
        List<EntityItem<?>> entityItems = this.getAvailableFields(itemId, form, entityMeta);
        if (entityItems.isEmpty()) {
            return entityItems;
        }
        if (StringUtils.isNotBlank((CharSequence)fieldType)) {
            return entityItems.stream().filter(entityItem -> entityItem.getClass().getSimpleName().equals(filterType)).collect(Collectors.toList());
        }
        return entityItems;
    }

    @Override
    protected void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", row.get("id"));
            String alias = String.format("%s(%s)", row.get("name"), row.get("key"));
            para.put("alias", alias);
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        EntryGrid grid = (EntryGrid)this.getView().getControl("fields");
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount("fields") > 0 && row >= 0) {
            ret.put("id", (String)this.getModel().getValue("fid", row));
            ret.put("name", (String)this.getModel().getValue("fname", row));
            ret.put("key", (String)this.getModel().getValue("fkey", row));
            return ret;
        }
        return null;
    }
}

