/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class RefDisplayPropEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "ftargetprops";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FTNAME = "ftname";
    private static final String FT_DISPLAY_NAME = "ftdisplayname";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (item == null || item.isEmpty()) {
            return;
        }
        List refFields = (List)item.get(0);
        if (refFields == null || refFields.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"RefDisplayPropEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map refFieldData = (Map)refFields.get(0);
        String refBaseFieldId = (String)refFieldData.get("RefBaseFieldId");
        List fieldsData = (List)item.get(1);
        Map baseField = null;
        for (Map field : fieldsData) {
            if (!field.get("Id").equals(refBaseFieldId)) continue;
            baseField = field;
            break;
        }
        if (baseField == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"RefDisplayPropEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        BasedataField fld = (BasedataField)EntityMetadataUtil.getEntityItem(baseField);
        String entityId = fld.getBaseEntityId();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ed1\u5b9a\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u65e0\u6548\u3002", (String)"RefDisplayPropEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashSet<String> defRefProps = new HashSet<String>();
        String displayProp = fld.getDisplayProp();
        defRefProps.add(displayProp.split("\\,").length > 1 ? displayProp.split("\\,")[1] : displayProp);
        defRefProps.add(fld.getNumberProp());
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_KEY);
        int[] defRows = model.batchCreateNewEntryRow(ENTRY_KEY, 2);
        model.setValue(FTNAME, (Object)fld.getDisplayProp(), defRows[0]);
        model.setValue(FT_DISPLAY_NAME, (Object)ResManager.loadKDString((String)"\u540d\u79f0", (String)"RefDisplayPropEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), defRows[0]);
        model.setValue(FTNAME, (Object)fld.getNumberProp(), defRows[1]);
        model.setValue(FT_DISPLAY_NAME, (Object)ResManager.loadKDString((String)"\u7f16\u7801", (String)"RefDisplayPropEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), defRows[1]);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeAllMasterProps(true);
        option.setOnlyBillHead(true);
        TreeNode root = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entityMetadata, (EntityFieldTreeBuildOption)option);
        List refProps = (List)baseField.get("RefProps");
        if (refProps != null) {
            for (Map refProp : refProps) {
                String name = (String)refProp.get("Name");
                TreeNode node = root.getTreeNode(name, 16);
                if (node == null || defRefProps.contains(node.getId())) continue;
                int rowindex = model.createNewEntryRow(ENTRY_KEY);
                model.setValue(FTNAME, (Object)node.getId(), rowindex);
                model.setValue(FT_DISPLAY_NAME, (Object)node.getText(), rowindex);
            }
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (ENTRY_KEY.equals(source.getKey())) {
            this.returnData();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
        int index = grid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(ENTRY_KEY) == 0 || index < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"RefDisplayPropEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", model.getValue(FTNAME, index));
            para.put("alias", "");
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }
}

