/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RegistKSEditPlugin
extends AbstractFormPlugin {
    private static final String PLUGIN = "plugin";
    private static final String DESCRIPTION = "description";

    public void initialize() {
        this.addClickListeners(new String[]{"ok", "exit", "editscript"});
    }

    public void afterCreateNewData(EventObject e) {
        Map pluginList = (Map)this.getView().getFormShowParameter().getCustomParam(PLUGIN);
        if (pluginList != null) {
            this.getModel().setValue("scriptname", pluginList.get("ClassName"));
            this.getModel().setValue("enabled", pluginList.get("Enabled"));
            this.getModel().setValue(DESCRIPTION, pluginList.get("Description"));
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        switch (btnKey = ((Button)evt.getSource()).getKey()) {
            case "editscript": {
                this.openScriptIDE();
                break;
            }
            case "exit": {
                this.exit();
                break;
            }
            case "ok": {
                this.ok();
                break;
            }
        }
    }

    private void ok() {
        Map pluginList = (Map)this.getView().getFormShowParameter().getCustomParam(PLUGIN);
        boolean enabled = (Boolean)this.getModel().getValue("enabled");
        String description = (String)this.getModel().getValue(DESCRIPTION);
        String fpk = (String)pluginList.get("FPK");
        try {
            DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)fpk, (String)"ide_pluginscript");
            scriptInfo.set(DESCRIPTION, (Object)description);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{scriptInfo});
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524dks\u811a\u672c\u63d2\u4ef6\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"RegistKSEditPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
        pluginList.put("Enabled", enabled);
        pluginList.put("Description", description);
        pluginList.put("rowKey", this.getView().getFormShowParameter().getCustomParam("rowKey"));
        this.getView().returnDataToParent((Object)pluginList);
        this.getView().close();
    }

    private void exit() {
        this.getView().close();
    }

    private void openScriptIDE() {
        Map pluginList = (Map)this.getView().getFormShowParameter().getCustomParam(PLUGIN);
        String formNumber = (String)this.getView().getFormShowParameter().getCustomParam("formnumber");
        if (formNumber == null) {
            return;
        }
        DynamicObject formmeta = this.getPageIdByPageInfo(formNumber);
        String bizFormId = formmeta == null ? "" : formmeta.getString("id");
        String bizAppId = formmeta == null ? "" : formmeta.getString("bizappid");
        DynamicObject appObject = BizAppServiceHelp.getBizAppByID((String)bizAppId);
        String bizCloudId = appObject.getString("bizcloud_id");
        String bizScriptId = (String)pluginList.get("FPK");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam("bizappid", (Object)bizAppId);
        parameter.setCustomParam("bizcloudid", (Object)bizCloudId);
        parameter.setCustomParam("bizscriptid", (Object)bizScriptId);
        if (StringUtils.isNotBlank((CharSequence)bizScriptId)) {
            parameter.setCustomParam("bizformid", (Object)bizFormId);
        }
        this.getView().showForm(parameter);
    }

    private DynamicObject getPageIdByPageInfo(String formNumber) {
        QFilter q = new QFilter("number", "=", (Object)formNumber);
        QFilter[] filters = new QFilter[]{q};
        Map pageObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,bizappid", (QFilter[])filters);
        if (pageObjects.size() > 0) {
            return (DynamicObject)pageObjects.values().toArray()[0];
        }
        return null;
    }
}

