/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.annotation.AnnotatedPlugin;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.service.GenericServiceResult;
import kd.bos.service.ResultCodeEnum;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.log4j.Logger;

public class RegisterPlugin
extends AbstractFormPlugin {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String OK = "ok";
    private static Logger log = Logger.getLogger(RegisterPlugin.class);
    private static final String PLUGIN_CLASS_NAME = "ClassName";
    private static final String PLUGIN_ENABLE_NAME = "Enabled";
    private static final String PLUGIN_DESCRIPTION_NAME = "Description";
    private static final String PLUGIN_DISPLAYNAME_NAME = "DisplayName";
    private static final String ROW_KEY_NAME = "RowKey";
    private static final String ENTRY_CLASS_NAME = "classname";
    private static final String ENTRY_ENABLE_NAME = "enabled";
    private static final String ENTRY_DESCRIPTION_NAME = "description";
    private static final String ENTRY_DISPLAYNAME_NAME = "displayname";
    private static final String KD_BOS = "kd.bos.";

    public void initialize() {
        Button btn = (Button)this.getView().getControl(OK);
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("exit");
        btn.addClickListener((ClickListener)this);
    }

    private void selectPackages() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "selectpackages");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private Map<String, Object> getPluginMap() {
        HashMap<String, Object> pluginMap = new HashMap<String, Object>();
        pluginMap.put(PLUGIN_CLASS_NAME, this.getModel().getValue(ENTRY_CLASS_NAME));
        pluginMap.put(PLUGIN_ENABLE_NAME, this.getModel().getValue(ENTRY_ENABLE_NAME) == null ? "false" : this.getModel().getValue(ENTRY_ENABLE_NAME));
        Object rowKey = this.getView().getFormShowParameter().getCustomParam(ROW_KEY_NAME);
        if (rowKey == null) {
            rowKey = this.getView().getFormShowParameter().getCustomParam("rowKey");
        }
        pluginMap.put(ROW_KEY_NAME, rowKey);
        pluginMap.put(PLUGIN_DESCRIPTION_NAME, this.getModel().getValue(ENTRY_DESCRIPTION_NAME));
        pluginMap.put(PLUGIN_DISPLAYNAME_NAME, this.getModel().getValue(ENTRY_DISPLAYNAME_NAME));
        return pluginMap;
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("selectPackages".equalsIgnoreCase(btn.getKey())) {
            this.selectPackages();
        }
        if (OK.equalsIgnoreCase((btn = (Button)evt.getSource()).getKey())) {
            if (StringUtils.isBlank((Object)this.getModel().getValue(ENTRY_CLASS_NAME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(ENTRY_DESCRIPTION_NAME))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegisterPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            Map<String, Object> pluginMap = this.getPluginMap();
            List plugins = (List)this.getView().getFormShowParameter().getCustomParam("plugins");
            if (plugins != null && !plugins.isEmpty()) {
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Object isEdit = parameter.getCustomParam("isEdit");
                if (isEdit != null) {
                    int rowKey = (Integer)parameter.getCustomParam("rowKey");
                    plugins.remove(rowKey);
                }
                boolean bExist = false;
                for (Map plugin : plugins) {
                    if (!pluginMap.get(PLUGIN_CLASS_NAME).equals(plugin.get(PLUGIN_CLASS_NAME))) continue;
                    bExist = true;
                    break;
                }
                if (bExist) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u63d2\u4ef6\u8def\u5f84\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"RegisterPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            String currentIsv = ISVService.getISVInfo().getId();
            boolean isKingdee = StringUtils.equals((CharSequence)currentIsv, (CharSequence)"kingdee");
            boolean isKdtest = StringUtils.equals((CharSequence)currentIsv, (CharSequence)"kdtest");
            if (!isKingdee && !isKdtest) {
                String newClassName = (String)this.getModel().getValue(ENTRY_CLASS_NAME);
                String oldClassName = this.getPageCache().get("className_cache");
                boolean oldClassNameKdBegin = StringUtils.startsWith((CharSequence)oldClassName, (CharSequence)KD_BOS);
                boolean newClassNameKdBegin = StringUtils.startsWith((CharSequence)newClassName, (CharSequence)KD_BOS);
                if (!oldClassNameKdBegin && newClassNameKdBegin) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u63d2\u4ef6\u8def\u5f84(kd.bos)\u4e0e\u5e73\u53f0\u5185\u7f6e\u63d2\u4ef6\u8def\u5f84\u51b2\u7a81\u53ef\u80fd\u4f1a\u5f71\u54cd\u5e73\u53f0\u8fd0\u884c\uff0c\u786e\u5b9a\u8981\u6ce8\u518c\u5417\uff1f", (String)"RegisterPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("updatePlugin_confirmCallBack"));
                    return;
                }
            }
            this.getView().returnDataToParent(pluginMap);
            this.getView().close();
        } else if (btn.getKey().equalsIgnoreCase("exit")) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object plugin = this.getView().getFormShowParameter().getCustomParam("plugin");
        if (plugin instanceof Map) {
            Map pluginList = (Map)plugin;
            this.getModel().setValue(ENTRY_CLASS_NAME, pluginList.get(PLUGIN_CLASS_NAME));
            this.getModel().setValue(ENTRY_ENABLE_NAME, pluginList.get(PLUGIN_ENABLE_NAME));
            this.getModel().setValue(ENTRY_DESCRIPTION_NAME, pluginList.get(PLUGIN_DESCRIPTION_NAME));
            this.getModel().setValue(ENTRY_DISPLAYNAME_NAME, pluginList.get(PLUGIN_DISPLAYNAME_NAME));
        }
    }

    public void afterBindData(EventObject e) {
        String className = (String)this.getModel().getValue(ENTRY_CLASS_NAME);
        this.getPageCache().put("className_cache", className);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        try {
            if (ENTRY_CLASS_NAME.equals(args.getProperty().getName())) {
                Object pluginClassName = args.getChangeSet()[0].getNewValue();
                if (StringUtils.isBlank((Object)pluginClassName)) {
                    return;
                }
                String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
                String formId = DesignerData.getNumberById(DesignerData.getMasterId(id));
                HashMap<String, String> para = new HashMap<String, String>();
                para.put("formId", formId);
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
                String appId = showParameter.getServiceAppId();
                Object resultObj = DispatchServiceHelper.invokeBOSService((String)appId, (String)"PluginFormService", (String)"getAnnotatedPlugin", (Object[])new Object[]{pluginClassName});
                GenericServiceResult result = (GenericServiceResult)resultObj;
                if (result.getSuccess().booleanValue()) {
                    AnnotatedPlugin annotatedPlugin = (AnnotatedPlugin)result.getData();
                    this.getModel().setValue(ENTRY_DESCRIPTION_NAME, (Object)annotatedPlugin.getDescription());
                } else if (ResultCodeEnum.CLASS_NOT_FOUND_EXCEPTION.getCode().equals(result.getCode())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u672a\u90e8\u7f72\u3002", (String)"RegisterPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"\u63d2\u4ef6\u8def\u5f84\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mes) {
        String callBackId = mes.getCallBackId();
        String resultValue = mes.getResultValue();
        if ("updatePlugin_confirmCallBack".equals(callBackId) && "Cancel".equals(resultValue)) {
            this.getModel().setValue(ENTRY_CLASS_NAME, (Object)this.getPageCache().get("className_cache"));
        } else if ("updatePlugin_confirmCallBack".equals(callBackId) && "Yes".equals(resultValue)) {
            this.getView().returnDataToParent(this.getPluginMap());
            this.getView().close();
        }
    }
}

