/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.subsystem.query.SubSystemReader;
import kd.bos.subsystem.query.SubSystemWriter;
import org.apache.log4j.Logger;

public class SVNLibChosePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static Logger log = Logger.getLogger(SVNLibChosePlugin.class);
    private final String entryKey = "EntryEntity";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnrelogin"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("EntryEntity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        String subFnumber = (String)this.getView().getFormShowParameter().getCustomParam("subFnumber");
        SubSystemReader query = new SubSystemReader();
        Map map = query.getSubSystem();
        if (map != null) {
            int row = model.createNewEntryRow("EntryEntity");
            model.setValue("subsystem", (Object)subFnumber, row);
            model.setValue("libname", map.get("libName"), row);
            model.setValue("libaddress", map.get("libAddress"), row);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.saveLibChosen();
                break;
            }
            case "btnrelogin": {
                this.relogin();
                break;
            }
        }
    }

    private void relogin() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_svn_login");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void saveLibChosen() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("EntryEntity");
        int rowKey = grid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        if (rowKey >= 0) {
            String libAddress = (String)model.getValue("libaddress", rowKey);
            String libName = (String)model.getValue("libname", rowKey);
            String subNumber = (String)model.getValue("subsystem", rowKey);
            SubSystemWriter query = new SubSystemWriter();
            query.updateSVNPath(libAddress, subNumber, libName);
            this.getView().returnDataToParent((Object)libAddress);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c", (String)"SVNLibChosePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.saveLibChosen();
        this.getView().close();
    }
}

