/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SelectComparePlugin
extends AbstractFormPlugin {
    private static final String F_COMPARE = "fcompare";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        this.setCompareTypes();
        super.initialize();
    }

    private void setCompareTypes() {
        String compareGroupId = (String)this.getView().getFormShowParameter().getCustomParam("comparegroupid");
        ComboEdit comboField = (ComboEdit)this.getControl(F_COMPARE);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        List compareTypes = FilterMetadata.get().getCompareTypes(compareGroupId);
        for (CompareType compareType : compareTypes) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(compareType.getName());
            comboItem.setValue(compareType.getId());
            comboItems.add(comboItem);
        }
        comboField.setComboItems(comboItems);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.closeAndreturnData();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
        super.click(evt);
    }

    private void closeAndreturnData() {
        String compare = this.getModel().getValue(F_COMPARE) == null ? "" : this.getModel().getValue(F_COMPARE).toString();
        String value = null;
        String compareGroupId = (String)this.getView().getFormShowParameter().getCustomParam("comparegroupid");
        List compareTypes = FilterMetadata.get().getCompareTypes(compareGroupId);
        for (CompareType compareType : compareTypes) {
            if (!compare.equals(compareType.getId())) continue;
            value = compareType.getId() + "$" + compareType.getName();
        }
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", value);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

