/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FilenameUtils;

public class SelectPackages
extends AbstractFormPlugin
implements ClickListener {
    String entryKey = "EntryEntity";
    String packagePath = "plugin";
    private static final Log log = LogFactory.getLog(SelectPackages.class);
    Collection<File> fileCollection = new ArrayList<File>();

    private Collection<File> loadJarFile(Path path) throws IOException {
        return this.fileCollection;
    }

    private Collection<File> loadZipFile(Path path) throws IOException {
        return this.fileCollection;
    }

    private void loadPackageList() throws IOException {
        Path dir = Paths.get(FilenameUtils.getName((String)this.packagePath), new String[0]);
        Collection<File> jarFileCollection = this.loadJarFile(dir);
        Collection<File> zipFileCollection = this.loadZipFile(dir);
        this.fileCollection.addAll(jarFileCollection);
        this.fileCollection.addAll(zipFileCollection);
    }

    public void initialize() {
        Button btn = (Button)this.getControl("ok");
        btn.addClickListener((ClickListener)this);
        try {
            this.loadPackageList();
        }
        catch (IOException e) {
            log.info(e.getMessage());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void closeAndReturn() {
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", "");
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("ok".equalsIgnoreCase(btn.getKey())) {
            this.closeAndReturn();
        }
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        if (this.fileCollection.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(this.entryKey, this.fileCollection.size());
            int i = 0;
            for (File file : this.fileCollection) {
                model.setValue("PackageName", (Object)file.getName(), i);
                model.setValue("PackageDesc", (Object)file.getPath(), i);
                ++i;
            }
        }
    }
}

