/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.SummaryToField;
import kd.bos.entity.Tips;
import kd.bos.entity.list.SummaryType;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class SelectSummaryFieldPlugin
extends AbstractPropertyPlugin {
    private static final String COMBO_KEY = "amountcombo";
    private static final String FID = "fid";
    private static final String FNAME = "fname";
    private static final String FKEY = "fkey";
    private static final String FIELD_ID = "FieldId";
    private static final String FIELD_KEY = "FieldKey";
    private static final String FIELD_NAME = "FieldName";
    private static final String SUM_TYPE = "SumType";
    private static final String SUMMARY_TO_FIELD = "SummaryToField";
    private static final String TYPE = "_Type_";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String ALIAS = "alias";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void afterCreateNewData(EventObject e) {
        List<DecimalField> rootFieldList;
        PropertyEditHelper helper = new PropertyEditHelper();
        if (helper.getEntityMeta(this.getView()) == null) {
            return;
        }
        EntityItem curEntityItem = EntityMetadataUtil.getEntityItem(helper.getItem(this.getView()));
        if (!(curEntityItem instanceof DecimalField)) {
            return;
        }
        EntityMetadata entityMeta = EntityMetadataUtil.getEntityMetadata(helper.getEntityMeta(this.getView()));
        HashMap<String, String> summaryAmountMap = new HashMap<String, String>();
        for (EntityItem item : entityMeta.getItems()) {
            EntityItem summaryAmountItem;
            DecimalField field;
            SummaryToField summaryToField;
            if (!(item instanceof DecimalField) || StringUtils.isBlank((CharSequence)item.getParentId()) || StringUtils.equals((CharSequence)curEntityItem.getId(), (CharSequence)item.getId()) || (summaryToField = (field = (DecimalField)item).getSummaryToField()) == null || !StringUtils.isNotBlank((CharSequence)summaryToField.getFieldId()) || !(entityMeta.getItemById(item.getParentId()) instanceof EntryEntity) || (summaryAmountItem = entityMeta.getItemById(summaryToField.getFieldId())) == null) continue;
            summaryAmountMap.put(summaryAmountItem.getId(), String.format(ResManager.loadKDString((String)"%1$s\u5df2\u88ab%2$s\u7ed1\u5b9a\u6620\u5c04\u3002", (String)"SelectSummaryFieldPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), summaryAmountItem.getName() + "(" + summaryAmountItem.getKey() + ")", field.getName() + "(" + field.getKey() + ")"));
        }
        if (!summaryAmountMap.isEmpty()) {
            this.getPageCache().put(summaryAmountMap);
        }
        if ((rootFieldList = this.getRootFieldList(entityMeta, curEntityItem)).size() > 0) {
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
            String curAmountValue = null;
            for (DecimalField amountField : rootFieldList) {
                HashMap<String, String> amountMap = new HashMap<String, String>();
                amountMap.put(FID, amountField.getId());
                amountMap.put(FKEY, amountField.getKey());
                String localName = amountField.getName().getLocaleValue();
                amountMap.put(FNAME, localName);
                String amountMapVal = SerializationUtils.toJsonString(amountMap);
                SummaryToField bindSummaryField = ((DecimalField)curEntityItem).getSummaryToField();
                if (bindSummaryField != null && StringUtils.equals((CharSequence)bindSummaryField.getFieldKey(), (CharSequence)amountField.getKey())) {
                    curAmountValue = amountMapVal;
                }
                ComboItem item = new ComboItem(new LocaleString(localName + "(" + amountField.getKey() + ")"), amountMapVal);
                comboItemList.add(item);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(COMBO_KEY);
            comboEdit.setComboItems(comboItemList);
            if (StringUtils.isNotBlank(curAmountValue)) {
                this.getModel().setValue(COMBO_KEY, curAmountValue);
            }
        }
        this.updateTitleTips(curEntityItem);
    }

    private List<DecimalField> getRootFieldList(EntityMetadata entityMeta, EntityItem<?> curEntityItem) {
        ArrayList<DecimalField> rootFieldList = new ArrayList<DecimalField>();
        for (EntityItem item : entityMeta.getRootEntity().getItems()) {
            if (curEntityItem instanceof AmountField) {
                if (!(item instanceof AmountField) && !item.getClass().equals(DecimalField.class)) continue;
                rootFieldList.add((DecimalField)item);
                continue;
            }
            if (curEntityItem instanceof IntegerField) {
                if (!item.getClass().equals(IntegerField.class) && !item.getClass().equals(BigIntField.class) && !item.getClass().equals(DecimalField.class)) continue;
                rootFieldList.add((DecimalField)item);
                continue;
            }
            if (curEntityItem instanceof QtyField) {
                if (!item.getClass().equals(DecimalField.class) && !item.getClass().equals(QtyField.class)) continue;
                rootFieldList.add((DecimalField)item);
                continue;
            }
            if (!curEntityItem.getClass().equals(DecimalField.class) || !item.getClass().equals(DecimalField.class)) continue;
            rootFieldList.add((DecimalField)item);
        }
        return rootFieldList;
    }

    private void updateTitleTips(EntityItem<?> curEntityItem) {
        Label labelap = (Label)this.getControl("labelap");
        Tips tips = new Tips();
        if (curEntityItem instanceof AmountField) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u91d1\u989d\u5b57\u6bb5\u7684\u6570\u503c\u53ef\u6c47\u603b\u81f3\u5355\u636e\u5934\u91d1\u989d\u5b57\u6bb5\uff0c\u4f46\u53cc\u65b9\u7684\u5e01\u79cd\u5c5e\u6027\u9700\u7ed1\u5b9a\u5355\u636e\u5934\u540c\u4e00\u5e01\u79cd\u5b57\u6bb5\u3002", (String)"SelectSummaryFieldPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        } else if (curEntityItem.getClass().equals(IntegerField.class)) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7684\u6574\u6570\u5b57\u6bb5\u7684\u6570\u503c\u53ef\u6c47\u603b\u81f3\u5355\u636e\u5934\u7684\u5c0f\u6570\u3001\u6574\u6570\u3001\u957f\u6574\u6570\u5b57\u6bb5\u3002", (String)"SelectSummaryFieldPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        } else if (curEntityItem.getClass().equals(BigIntField.class)) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u957f\u6574\u6570\u5b57\u6bb5\u652f\u6301\u6c47\u603b\u81f3\u5355\u636e\u5934\u5c0f\u6570\u3001\u6574\u6570\u3001\u957f\u6574\u6570\u5b57\u6bb5", (String)"SelectSummaryFieldPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        } else if (curEntityItem.getClass().equals(DecimalField.class)) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5c0f\u6570\u5b57\u6bb5\u7684\u6570\u503c\u53ef\u6c47\u603b\u81f3\u5355\u636e\u5934\u5c0f\u6570\u5b57\u6bb5\u3002", (String)"SelectSummaryFieldPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        } else if (curEntityItem.getClass().equals(QtyField.class)) {
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u6570\u91cf\u5b57\u6bb5\u7684\u6570\u503c\u53ef\u6c47\u603b\u81f3\u5355\u636e\u5934\u5c0f\u6570\u5b57\u6bb5\u3002", (String)"SelectSummaryFieldPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        }
        tips.setType("text");
        labelap.addTips(tips);
    }

    @Override
    protected void returnData() {
        String amountMapVal = (String)this.getModel().getValue(COMBO_KEY);
        if (StringUtils.isBlank((CharSequence)amountMapVal)) {
            ArrayList paras = new ArrayList(5);
            HashMap para = new HashMap(10);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            para.put(ITEM_ID, customParams.get(ITEM_ID));
            para.put(META_TYPE, customParams.get(META_TYPE));
            para.put(PROPERTY_NAME, customParams.get(PROPERTY_NAME));
            para.put(VALUE, new HashMap(1));
            para.put(ALIAS, "");
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
            return;
        }
        Map amountMap = (Map)SerializationUtils.fromJsonString((String)amountMapVal, Map.class);
        String summaryFieldId = (String)amountMap.get(FID);
        String summaryFieldKey = (String)amountMap.get(FKEY);
        String summaryFieldName = (String)amountMap.get(FNAME);
        Map summaryAmountMap = this.getPageCache().getAll();
        if (summaryAmountMap.containsKey(summaryFieldId)) {
            this.getView().showTipNotification((String)summaryAmountMap.get(summaryFieldId), Integer.valueOf(3000));
            return;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put(TYPE, SUMMARY_TO_FIELD);
        value.put(FIELD_ID, summaryFieldId);
        value.put(FIELD_KEY, summaryFieldKey);
        value.put(FIELD_NAME, summaryFieldName);
        value.put(SUM_TYPE, SummaryType.SUM.getValue());
        ArrayList paras = new ArrayList(5);
        HashMap para = new HashMap(10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        para.put(ITEM_ID, customParams.get(ITEM_ID));
        para.put(META_TYPE, customParams.get(META_TYPE));
        para.put(PROPERTY_NAME, customParams.get(PROPERTY_NAME));
        para.put(VALUE, value);
        para.put(ALIAS, summaryFieldName + "(" + SummaryType.SUM.getDesc() + ")");
        paras.add(para);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fieldId = (String)this.getView().getFormShowParameter().getCustomParam(ITEM_ID);
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        String entityId = "";
        if (context.get(0) instanceof List) {
            List data = (List)context.get(0);
            entityId = (String)((Map)data.get(0)).get("Id");
        }
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            DecimalField decimalField;
            SummaryToField summaryToField;
            ExtLockTypeEnum lockType;
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            EntityMetadata oriEntityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityMetadata.getMasterId(), (MetaCategory)MetaCategory.Entity);
            if (oriEntityMetadata == null) {
                return;
            }
            EntityItem item = oriEntityMetadata.getItemById(fieldId);
            if (item != null && ExtLockTypeEnum.speciallock.equals((Object)(lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)fieldId, (String)SUMMARY_TO_FIELD))) && item instanceof DecimalField && (summaryToField = (decimalField = (DecimalField)item).getSummaryToField()) != null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{COMBO_KEY, "btnok"});
            }
        }
    }
}

