/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.kingscript.KingScriptType;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SelectTSPlugin
extends AbstractFormPlugin {
    private static final String KEY_TDE = "tde";
    private List<Integer> selectRows = null;
    public static final String PLUGIN_CLASS_NAME = "ClassName";
    public static final String PLUGIN_FPK_NAME = "FPK";
    public static final String PLUGIN_BIZAPPID_NAME = "BizAppId";
    public static final String PLUGIN_DESCRIPTION_NAME = "Description";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_TDE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            int i;
            List plugins = SerializationUtils.fromJsonStringToList((String)value, Map.class);
            DynamicObjectCollection entryRows = this.getModel().getEntryEntity("entryentity");
            HashMap<String, Integer> rowIndexMap = new HashMap<String, Integer>(entryRows.size());
            for (i = 0; i < entryRows.size(); ++i) {
                DynamicObject row = (DynamicObject)entryRows.get(i);
                rowIndexMap.put(row.getString("scriptnumber"), i);
            }
            this.selectRows = new ArrayList<Integer>(8);
            for (i = plugins.size() - 1; i >= 0; --i) {
                Integer rowIndex;
                String className = (String)((Map)plugins.get(i)).get(PLUGIN_CLASS_NAME);
                if (!StringUtils.isNotBlank((CharSequence)className) || (rowIndex = (Integer)rowIndexMap.get(className)) == null) continue;
                this.getModel().setEntryRowTop("entryentity", new int[]{rowIndex});
                this.selectRows.add(this.selectRows.size());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap"});
        if (this.selectRows != null && !this.selectRows.isEmpty()) {
            int[] rows = new int[this.selectRows.size()];
            for (int i = 0; i < this.selectRows.size(); ++i) {
                rows[i] = this.selectRows.get(i);
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.selectRows(rows, 0);
        }
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "tde": {
                this.registerTs();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (KEY_TDE.equalsIgnoreCase(e.getActionId())) {
            Map plugin = (Map)e.getReturnData();
            this.addToModel(plugin);
        }
    }

    private void gotoTDE() {
        String bizAppId;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (modelType != null) {
            parameter.setCustomParam("modelType", (Object)modelType);
        }
        if ((bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid")) != null) {
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)bizAppId, null);
            parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TDE));
        this.getView().showForm(parameter);
    }

    private void registerTs() {
        String bizAppId;
        String scripttypefilter;
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_kingscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_TDE));
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (modelType != null) {
            parameter.setCustomParam("modelType", (Object)modelType);
        }
        if (StringUtils.isNotEmpty((CharSequence)(scripttypefilter = (String)this.getView().getFormShowParameter().getCustomParam("scripttypefilter")))) {
            parameter.setCustomParam("scripttypefilter", (Object)scripttypefilter);
        }
        if ((bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid")) != null) {
            parameter.setCustomParam("bizappid", (Object)bizAppId);
            String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)bizAppId, null);
            parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        }
        this.getView().showForm(parameter);
    }

    private void afterAddNewTs(Map<String, Object> plugin) {
        DynamicObjectType dt;
        DynamicObject[] scriptInfos;
        this.getModel().insertEntryRow("entryentity", 0);
        this.getModel().setValue("scriptnumber", plugin.get(PLUGIN_CLASS_NAME), 0);
        this.getModel().setValue("description", plugin.get(PLUGIN_DESCRIPTION_NAME), 0);
        this.getModel().setValue("bizappid", plugin.get(PLUGIN_BIZAPPID_NAME), 0);
        String scriptId = (String)plugin.get(PLUGIN_FPK_NAME);
        this.getModel().setValue("scriptid", (Object)scriptId, 0);
        if (StringUtils.isNotBlank((CharSequence)scriptId) && (scriptInfos = BusinessDataServiceHelper.load((Object[])new Object[]{scriptId}, (DynamicObjectType)(dt = EntityMetadataCache.getSubDataEntityType((String)"ide_pluginscript", Arrays.asList("id", "txt_scriptname", "txt_scriptnumber", "description", "cbox_script_type", "classname", "bizunitid", "bizappid"))))) != null && scriptInfos.length != 0) {
            DynamicObject scriptInfo = scriptInfos[0];
            this.getModel().setValue("scripttype", (Object)KingScriptType.getScriptNameByIndex((String)scriptInfo.getString("cbox_script_type")), 0);
            this.getModel().setValue("number", scriptInfo.get("txt_scriptnumber"), 0);
            this.getModel().setValue("scriptname", (Object)scriptInfo.getString("txt_scriptname"), 0);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(0);
    }

    private void addToModel(Map<String, Object> plugin) {
        DynamicObjectType dt;
        DynamicObject[] scriptInfos;
        int rowIndex = 0;
        this.getModel().insertEntryRow("entryentity", rowIndex);
        this.getModel().setValue("scriptnumber", plugin.get(PLUGIN_CLASS_NAME), rowIndex);
        this.getModel().setValue("description", plugin.get(PLUGIN_DESCRIPTION_NAME), rowIndex);
        this.getModel().setValue("bizappid", plugin.get(PLUGIN_BIZAPPID_NAME), rowIndex);
        Object scriptId = plugin.get(PLUGIN_FPK_NAME);
        this.getModel().setValue("scriptid", scriptId, rowIndex);
        if (StringUtils.isNotBlank((Object)scriptId) && (scriptInfos = BusinessDataServiceHelper.load((Object[])new Object[]{scriptId}, (DynamicObjectType)(dt = EntityMetadataCache.getSubDataEntityType((String)"ide_pluginscript", Arrays.asList("id", "txt_scriptname", "txt_scriptnumber", "description", "cbox_script_type", "classname", "bizunitid", "bizappid"))))) != null && scriptInfos.length != 0) {
            DynamicObject scriptInfo = scriptInfos[0];
            this.getModel().setValue("scripttype", (Object)KingScriptType.getScriptNameByIndex((String)scriptInfo.getString("cbox_script_type")), 0);
            this.getModel().setValue("number", scriptInfo.get("txt_scriptnumber"), 0);
            this.getModel().setValue("scriptname", (Object)scriptInfo.getString("txt_scriptname"), 0);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(0);
    }
}

