/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SelectableRangeEditPlugin
extends AbstractPropertyPlugin {
    private static final String VALUE = "value";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String META_TYPE = "metaType";
    private static final String ITEM_ID = "itemId";
    private static final String EXPR_ENDDATE = "expr_enddate";
    private static final String EXPR_STARTDATE = "expr_startdate";
    private static final String MIN_DATE = "MinDate";
    private static final String MAX_DATE = "MaxDate";
    private static final String EXPR_TODAY = "now()";
    private static final String EXPR_YESTERDAY = "dateAdd(now(), -1)";
    private static final String EXPR_THIS_SATURDAY = "dateAdd(now(), 6 - weekday(now()))";
    private static final String EXPR_THIS_MONTH_FIRST_DAY = "dateAdd(now(), 1 - monthday(now()))";
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Log log = LogFactory.getLog(SelectableRangeEditPlugin.class);
    private static final String TYPE = "_Type_";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String COMMON = "common";
    private static final String END_DATE_COMMON_PANEL = "enddatecommonpanel";
    private static final String FORMULA = "formula";
    private static final String END_DATE_FORMULA_PANEL = "enddateformulapanel";
    private static final String CONSTANT = "constant";
    private static final String END_DATE_CONST_PANEL = "enddateconstpanel";
    private static final String START_DATE_COMMON_PANEL = "startdatecommonpanel";
    private static final String START_DATE_FORMULA_PANEL = "startdateformulapanel";
    private static final String START_DATE_CONST_PANEL = "startdateconstpanel";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String START_TIME = "starttime";
    private static final String END_TIME = "endtime";
    private static final String START_DATE_FORMULA = "startdateformula";
    private static final String END_DATE_FORMULA = "enddateformula";
    private List<Predicate<String[]>> matchFunctions = new ArrayList<Predicate<String[]>>();

    private boolean match() {
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value instanceof Date) {
            Date newValue = (Date)value;
            switch (name) {
                case "startdateconst": 
                case "enddateconst": {
                    if (!"DateField".equals(this.getView().getPageCache().get(TYPE))) break;
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(newValue);
                    int hour = calendar.get(11);
                    int minute = calendar.get(12);
                    int second = calendar.get(13);
                    if (hour + minute + second <= 0) break;
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    this.getModel().beginInit();
                    this.getModel().setValue(name, (Object)calendar.getTime());
                    this.getModel().endInit();
                    this.getView().updateView(name);
                    break;
                }
            }
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String newValue = (String)value;
        switch (name) {
            case "startdate": {
                this.hideStartPanel();
                this.switchStartPanel(newValue);
                break;
            }
            case "enddate": {
                this.hideEndPanel();
                this.switchEndPanel(newValue);
                break;
            }
        }
    }

    private void switchEndPanel(String newValue) {
        String panel = null;
        switch (newValue) {
            case "null": {
                break;
            }
            case "common": {
                panel = END_DATE_COMMON_PANEL;
                break;
            }
            case "formula": {
                panel = END_DATE_FORMULA_PANEL;
                break;
            }
            case "constant": {
                panel = END_DATE_CONST_PANEL;
                break;
            }
        }
        if (panel != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{panel});
        }
    }

    private void switchStartPanel(String newValue) {
        String panel = null;
        switch (newValue) {
            case "null": {
                break;
            }
            case "common": {
                panel = START_DATE_COMMON_PANEL;
                break;
            }
            case "formula": {
                panel = START_DATE_FORMULA_PANEL;
                break;
            }
            case "constant": {
                panel = START_DATE_CONST_PANEL;
                break;
            }
        }
        if (panel != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{panel});
        }
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject context = Optional.ofNullable((JSONArray)this.getView().getFormShowParameter().getCustomParam("context")).map(arr -> arr.getJSONObject(0)).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u65e5\u671f\u5b57\u6bb5\u4e0a\u4e0b\u6587\u3002", (String)"SelectableRangeEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        String minDateExpr = context.getString(MIN_DATE);
        String maxDateExpr = context.getString(MAX_DATE);
        this.getModel().setValue(EXPR_ENDDATE, (Object)maxDateExpr);
        this.getModel().setValue(EXPR_STARTDATE, (Object)minDateExpr);
        this.getModel().setValue(START_DATE, (Object)"null");
        this.getModel().setValue(END_DATE, (Object)"null");
        this.hideAllPanel();
        this.loadResult();
        this.getView().getPageCache().put(TYPE, context.getString(TYPE));
        String type = context.getString(TYPE);
        if ("DateField".equals(type)) {
            this.getModel().setValue(START_TIME, (Object)0);
            this.getModel().setValue(END_TIME, (Object)0);
            this.getView().setEnable(Boolean.FALSE, new String[]{START_TIME, END_TIME});
        }
    }

    private void hideStartPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{START_DATE_COMMON_PANEL, START_DATE_FORMULA_PANEL, START_DATE_CONST_PANEL});
    }

    private void hideEndPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{END_DATE_COMMON_PANEL, END_DATE_FORMULA_PANEL, END_DATE_CONST_PANEL});
    }

    private void hideAllPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{START_DATE_COMMON_PANEL, START_DATE_FORMULA_PANEL, START_DATE_CONST_PANEL, END_DATE_COMMON_PANEL, END_DATE_FORMULA_PANEL, END_DATE_CONST_PANEL});
    }

    private void loadResult() {
        String exprStartDate = (String)this.getModel().getValue(EXPR_STARTDATE);
        String exprEndDate = (String)this.getModel().getValue(EXPR_ENDDATE);
        this.matchFunctions = new ArrayList<Predicate<String[]>>(10);
        this.matchFunctions.add(this::isConstantDate);
        this.matchFunctions.add(this::isCommonDate);
        this.matchFunctions.add(this::isCommonDateTime);
        this.matchFunctions.add(this::isFormula);
        for (Predicate<String[]> func : this.matchFunctions) {
            if (!func.test(new String[]{exprStartDate, "start"})) continue;
            break;
        }
        for (Predicate<String[]> func : this.matchFunctions) {
            if (!func.test(new String[]{exprEndDate, "end"})) continue;
            break;
        }
    }

    private String secondToTime(int second) {
        if (second < 0) {
            return "";
        }
        int hours = second / 3600;
        int minutes = (second %= 3600) / 60;
        return String.format("%02d:%02d:%02d", hours, minutes, second %= 60);
    }

    private void storeResult() {
        Object startDate = this.getModel().getValue(START_DATE);
        if (CONSTANT.equals(startDate)) {
            this.getModel().setValue(EXPR_STARTDATE, (Object)this.processDateConst("startdateconst"));
        } else if (COMMON.equals(startDate)) {
            this.getModel().setValue(EXPR_STARTDATE, this.commonToExpr((String)this.getModel().getValue("startdatecommon"), this.secondToTime((Integer)this.getModel().getValue(START_TIME))));
        } else if (FORMULA.equals(startDate)) {
            this.getModel().setValue(EXPR_STARTDATE, this.getModel().getValue(START_DATE_FORMULA));
        } else {
            this.getModel().setValue(EXPR_STARTDATE, (Object)"");
        }
        Object endDate = this.getModel().getValue(END_DATE);
        if (CONSTANT.equals(endDate)) {
            this.getModel().setValue(EXPR_ENDDATE, (Object)this.processDateConst("enddateconst"));
        } else if (COMMON.equals(endDate)) {
            this.getModel().setValue(EXPR_ENDDATE, this.commonToExpr((String)this.getModel().getValue("enddatecommon"), this.secondToTime((Integer)this.getModel().getValue(END_TIME))));
        } else if (FORMULA.equals(endDate)) {
            this.getModel().setValue(EXPR_ENDDATE, this.getModel().getValue(END_DATE_FORMULA));
        } else {
            this.getModel().setValue(EXPR_ENDDATE, (Object)"");
        }
    }

    private String processDateConst(String dateConstKey) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT);
        Object date = this.getModel().getValue(dateConstKey);
        if (date instanceof Date) {
            return simpleDateFormat.format(date);
        }
        return "";
    }

    private Object commonToExpr(String datecommonValue, String timeValue) {
        if (StringUtils.isNotEmpty((CharSequence)timeValue)) {
            return String.format("left(%s, 11) + \"%s\"", this.commonValueToExpr(datecommonValue), timeValue);
        }
        return this.commonValueToExpr(datecommonValue);
    }

    private String commonValueToExpr(String dateCommonValue) {
        Map<String, String> map = this.getCommonValueMap();
        return map.getOrDefault(dateCommonValue, "");
    }

    private Map<String, String> getCommonValueMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("today", EXPR_TODAY);
        map.put("yesterday", EXPR_YESTERDAY);
        map.put("thisSaturday", EXPR_THIS_SATURDAY);
        map.put("thisMonthFirstDay", EXPR_THIS_MONTH_FIRST_DAY);
        return map;
    }

    private boolean isConstantDate(String[] strings) {
        String expr = strings[0];
        String type = strings[1];
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT);
        try {
            simpleDateFormat.format(simpleDateFormat.parse(expr));
            this.getModel().setValue(type + "date", (Object)CONSTANT);
            this.getModel().setValue(type + "dateconst", (Object)expr);
            this.getView().setVisible(Boolean.TRUE, new String[]{type + "dateconstpanel"});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isCommonDate(String[] strings) {
        String expr = strings[0];
        String type = strings[1];
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return false;
        }
        Map<String, String> commonValueMap = this.getCommonValueMap();
        for (Map.Entry<String, String> entry : commonValueMap.entrySet()) {
            String commonValue = entry.getKey();
            String commonValueExpr = entry.getValue();
            if (!expr.equals(commonValueExpr)) continue;
            this.getModel().setValue(type + "date", (Object)COMMON);
            this.getModel().setValue(type + "datecommon", (Object)commonValue);
            this.getModel().setValue(type + "time", (Object)-1);
            this.getView().setVisible(Boolean.TRUE, new String[]{type + "datecommonpanel"});
            return true;
        }
        return false;
    }

    private boolean isCommonDateTime(String[] strings) {
        String expr = strings[0];
        String type = strings[1];
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return false;
        }
        Map<String, String> commonValueMap = this.getCommonValueMap();
        for (Map.Entry<String, String> entry : commonValueMap.entrySet()) {
            int second;
            String commonValue = entry.getKey();
            String commonValueExpr = entry.getValue();
            String prefix = String.format("left(%s, 11) + ", commonValueExpr);
            if (!expr.startsWith(prefix) || (second = this.timeToSec(expr.substring(prefix.length()))) <= -1) continue;
            this.getModel().setValue(type + "date", (Object)COMMON);
            this.getModel().setValue(type + "datecommon", (Object)commonValue);
            this.getModel().setValue(type + "time", (Object)second);
            this.getView().setVisible(Boolean.TRUE, new String[]{type + "datecommonpanel"});
            return true;
        }
        return false;
    }

    private boolean isFormula(String[] strings) {
        String expr = strings[0];
        String type = strings[1];
        if (StringUtils.isEmpty((CharSequence)expr)) {
            return false;
        }
        try {
            FormulaEngine.runFormula((String)expr, new HashMap());
            this.getModel().setValue(type + "date", (Object)FORMULA);
            this.getModel().setValue(type + "dateformula", (Object)expr);
            this.getView().setVisible(Boolean.TRUE, new String[]{type + "dateformulapanel"});
            return true;
        }
        catch (RunFormulaException exp) {
            return false;
        }
    }

    private int timeToSec(String s) {
        String regex = "\"\\d\\d:\\d\\d:\\d\\d\"";
        boolean matches = Pattern.matches(regex, s);
        if (!matches) {
            return -1;
        }
        int start = 1;
        int end = 9;
        String[] numbers = s.substring(start, end).split(":");
        return Integer.parseInt(numbers[0]) * 3600 + Integer.parseInt(numbers[1]) * 60 + Integer.parseInt(numbers[2]);
    }

    @Override
    protected void returnData() {
        this.storeResult();
        if (!this.check()) {
            return;
        }
        ArrayList paras = new ArrayList();
        HashMap<String, Object> minDatePara = new HashMap<String, Object>();
        minDatePara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        minDatePara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        minDatePara.put(PROPERTY_NAME, MIN_DATE);
        minDatePara.put(VALUE, this.getModel().getValue(EXPR_STARTDATE));
        paras.add(minDatePara);
        HashMap<String, Object> maxDatePara = new HashMap<String, Object>();
        maxDatePara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        maxDatePara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        maxDatePara.put(PROPERTY_NAME, MAX_DATE);
        maxDatePara.put(VALUE, this.getModel().getValue(EXPR_ENDDATE));
        paras.add(maxDatePara);
        HashMap selectableRange = new HashMap();
        StringBuilder aliasBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(EXPR_STARTDATE)) || StringUtils.isNotBlank((Object)this.getModel().getValue(EXPR_ENDDATE))) {
            aliasBuilder.append("[ ").append(this.getModel().getValue(EXPR_STARTDATE)).append(" , ").append(this.getModel().getValue(EXPR_ENDDATE)).append(" ] ");
        }
        selectableRange.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        selectableRange.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        selectableRange.put(PROPERTY_NAME, "SelectableRange");
        selectableRange.put(VALUE, aliasBuilder.toString());
        selectableRange.put("alias", aliasBuilder.toString());
        paras.add(selectableRange);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private boolean check() {
        String endDateCommon;
        String startDateCommon;
        Object startDateObj = this.getModel().getValue(START_DATE);
        if (COMMON.equals(startDateObj) && StringUtils.isBlank((CharSequence)(startDateCommon = (String)this.getModel().getValue("startdatecommon")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\uff1a\u5e38\u7528\u65e5\u671f\uff08\u5f00\u59cb\uff09\u3002", (String)"SelectableRangeEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        Object endDateObj = this.getModel().getValue(END_DATE);
        if (COMMON.equals(endDateObj) && StringUtils.isBlank((CharSequence)(endDateCommon = (String)this.getModel().getValue("enddatecommon")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\uff1a\u5e38\u7528\u65e5\u671f\uff08\u7ed3\u675f\uff09\u3002", (String)"SelectableRangeEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        Object startDate = this.eval(this.getModel().getValue(EXPR_STARTDATE).toString());
        Object endDate = this.eval(this.getModel().getValue(EXPR_ENDDATE).toString());
        if (startDate == null || endDate == null) {
            return false;
        }
        if (StringUtils.isBlank((Object)startDate) || StringUtils.isBlank((Object)endDate)) {
            return true;
        }
        if (startDate.toString().compareTo(endDate.toString()) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"SelectableRangeEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        String actionId = closedCallBackEvent.getActionId();
        if ((START_DATE_FORMULA.equals(actionId) || END_DATE_FORMULA.equals(actionId)) && (map = (Map)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue(actionId, map.get("expr"));
        }
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (key.equals(END_DATE_FORMULA) || key.equals(START_DATE_FORMULA)) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("ide_dateformulasettings");
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            para.setCustomParam("expr", this.getModel().getValue(key));
            this.getView().showForm(para);
        }
    }

    private Object eval(String exprString) {
        if (StringUtils.isBlank((CharSequence)exprString)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT);
        try {
            return simpleDateFormat.format(simpleDateFormat.parse(exprString));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            Object result = null;
            try {
                result = FormulaEngine.runFormula((String)exprString, new HashMap());
            }
            catch (Exception e2) {
                result = null;
            }
            if (result == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6548\uff1a%s\u3002", (String)"SelectableRangeEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), exprString));
            }
            try {
                simpleDateFormat.parse(String.valueOf(result));
            }
            catch (Exception e3) {
                result = null;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u65e0\u6548\uff1a%s\u3002", (String)"SelectableRangeEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), exprString));
            }
            return result;
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{END_DATE_FORMULA, START_DATE_FORMULA});
    }
}

