/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class SelectedDisplayFieldPlugin
extends AbstractFormPlugin {
    private static final String MAIN_FIELD = "mfield";
    private static final String SECOND_FIELD = "sfield";
    private static final String MT = "mt";
    private static final String ST = "st";
    private static final String VALUE = "value";
    private static final String BTN_OK = "btnok";
    private static final String KEY = "Key";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String IDE_SELECTING_FIELD = "ide_selectingfield";
    private static final String SELECTED_DISPLAY_FIELD = "SelectedDisplayField";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String TYPE = "_Type_";
    private static final String SELECTED_DISPLAY_FIELD_PLUGIN_0 = "SelectedDisplayFieldPlugin_0";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnData();
        } else if (MAIN_FIELD.equalsIgnoreCase(key)) {
            this.selectDisplayField(MAIN_FIELD);
        } else if (SECOND_FIELD.equalsIgnoreCase(key)) {
            this.selectDisplayField(SECOND_FIELD);
        }
    }

    public void registerListener(EventObject e) {
        TextEdit mainField = (TextEdit)this.getView().getControl(MAIN_FIELD);
        mainField.addButtonClickListener((ClickListener)this);
        TextEdit secondField = (TextEdit)this.getView().getControl(SECOND_FIELD);
        secondField.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (value == null) {
            return;
        }
        JSONObject dataValue = JSON.parseObject((String)value.toString());
        this.getModel().setValue(MAIN_FIELD, dataValue.get((Object)MT));
        this.getModel().setValue(SECOND_FIELD, dataValue.get((Object)ST));
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString(value));
    }

    protected void returnData() {
        Object mainField = this.getModel().getValue(MAIN_FIELD);
        if (StringUtils.isBlank((Object)mainField)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e3b\u663e\u793a\u5b57\u6bb5\u3002", (String)SELECTED_DISPLAY_FIELD_PLUGIN_0, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put(TYPE, SELECTED_DISPLAY_FIELD);
        value.put(MT, this.getModel().getValue(MAIN_FIELD));
        value.put(ST, this.getModel().getValue(SECOND_FIELD));
        HashMap para = new HashMap();
        ArrayList paras = new ArrayList();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        para.put(VALUE, value);
        paras.add(para);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        Map op = (Map)evt.getReturnData();
        if (MAIN_FIELD.equalsIgnoreCase(actionId)) {
            this.getModel().setValue(MAIN_FIELD, op.get(KEY));
        } else if (SECOND_FIELD.equalsIgnoreCase(actionId)) {
            this.getModel().setValue(SECOND_FIELD, op.get(KEY));
        }
    }

    private void selectDisplayField(String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(IDE_SELECTING_FIELD);
        parameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }
}

