/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;

public class SelectingFieldPlugin
extends AbstractPropertyPlugin {
    private static final String ENTRY_KEY = "entryentity";
    private static final String BASE_ENTITY_ID = "BaseEntityId";
    private static final String TYPE = "_Type_";
    private static final String FID = "fid";
    private static final String ID = "Id";
    private static final String F_NAME = "fname";
    private static final String NAME = "Name";
    private static final String F_KEY = "fkey";
    private static final String KEY = "Key";
    private static final String CONTEXT = "context";

    public void afterCreateNewData(EventObject e) {
        List data = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (data == null || data.isEmpty() || ((List)data.get(0)).isEmpty()) {
            return;
        }
        Object key = ((Map)((List)data.get(0)).get(0)).get(KEY);
        Object entityId = ((List)data.get(1)).stream().filter(m -> key.toString().equals(m.get(KEY)) && StringUtils.isNotBlank(m.get(BASE_ENTITY_ID))).findFirst().map(m -> m.get(BASE_ENTITY_ID)).orElse(null);
        if (StringUtils.isBlank(entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId.toString(), (MetaCategory)MetaCategory.Entity);
        ArrayList<Map<String, Object>> entryFields = new ArrayList<Map<String, Object>>();
        for (EntityItem entityItem : entityMetadata.getItems()) {
            if (StringUtils.isNotBlank((CharSequence)entityItem.getParentId())) continue;
            if (entityItem instanceof TextField && this.isTextType(entityItem) && !((TextField)entityItem).isPassword()) {
                this.addEntryFields(entryFields, entityItem.getId(), entityItem.getKey(), entityItem.getName().toString(), entityItem.getClass().getName());
                continue;
            }
            if (!(entityItem instanceof BasedataField)) continue;
            this.parseAndAddBaseDataField(entryFields, (BasedataField)entityItem);
        }
        IDataModel model = this.getModel();
        for (Map map : entryFields) {
            int row = this.getModel().createNewEntryRow(ENTRY_KEY);
            model.setValue(FID, map.get(ID), row);
            model.setValue(F_KEY, map.get(KEY) == null ? map.get(ID) : map.get(KEY), row);
            model.setValue(F_NAME, map.get(NAME), row);
        }
    }

    @Override
    protected void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            HashMap<String, Object> value = new HashMap<String, Object>(10);
            value.put(KEY, row.get(KEY));
            value.put(NAME, row.get(NAME));
            this.getView().returnDataToParent(value);
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>(10);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) <= 0 || row < 0) {
            return null;
        }
        ret.put(ID, this.getModel().getValue(FID, row));
        ret.put(KEY, this.getModel().getValue(F_KEY, row));
        ret.put(NAME, this.getModel().getValue(F_NAME, row));
        return ret;
    }

    private void parseAndAddBaseDataField(List<Map<String, Object>> entryFields, BasedataField basedataField) {
        String number = MetadataDao.getEntityNumberById((String)basedataField.getBaseEntityId());
        BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)basedataField.getRuntimeRefProps());
        Map fields = dt.getFields();
        for (IDataEntityProperty fieldProp : fields.values()) {
            if (!(fieldProp instanceof IFieldHandle) || !this.isTextType(fieldProp) || ((TextProp)fieldProp).isPassword()) continue;
            this.addEntryFields(entryFields, basedataField.getId(), this.getFormatName(basedataField.getKey(), fieldProp.getName()), this.getFormatName(basedataField.getName().toString(), fieldProp.getDisplayName().toString()), fieldProp.getClass().getName());
        }
    }

    private void addEntryFields(List<Map<String, Object>> entryFields, String id, String key, String name, String type) {
        HashMap<String, String> item = new HashMap<String, String>(16);
        item.put(ID, id);
        item.put(KEY, key);
        item.put(NAME, name);
        item.put(TYPE, type);
        entryFields.add(item);
    }

    private String getFormatName(String parentName, String name) {
        if (StringUtils.isBlank((CharSequence)parentName)) {
            return name;
        }
        return String.format("%s.%s", parentName, name);
    }

    private boolean isTextType(Object fieldProp) {
        if (fieldProp instanceof TextProp && fieldProp.getClass().isAssignableFrom(TextProp.class) || fieldProp instanceof MuliLangTextProp) {
            return true;
        }
        return fieldProp instanceof TextField && fieldProp.getClass().isAssignableFrom(TextField.class) || fieldProp instanceof MuliLangTextField;
    }
}

