/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ShortCutPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_KEY = "shortcutentry";
    private static final String BTN_OK = "btnok";
    private static final String F_ENABLE = "enable";
    private static final String F_LABEL = "label";
    private static final String F_SHORT_CUT = "shortcut";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Object val = this.getView().getFormShowParameter().getCustomParam("value");
        if (val != null) {
            List shortCutList = (List)val;
            this.getModel().batchCreateNewEntryRow(ENTRY_KEY, shortCutList.size());
            int i = 0;
            for (Map shortCut : shortCutList) {
                this.getModel().setValue(F_ENABLE, shortCut.get("Enable"), i);
                this.getModel().setValue(F_LABEL, shortCut.get("ShortCutName"), i);
                this.getModel().setValue(F_SHORT_CUT, shortCut.get("ShortCuts"), i++);
            }
        }
    }

    public void afterBindData(EventObject e) {
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (BTN_OK.equals(btn.getKey())) {
            this.returnDataToParent();
        }
    }

    private List<Map<String, Object>> getShortCuts() {
        ArrayList<Map<String, Object>> shortCutList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item = null;
        DynamicObjectCollection queryResult = this.getModel().getEntryEntity(ENTRY_KEY);
        for (DynamicObject shortCut : queryResult) {
            item = new HashMap<String, Object>();
            item.put("_Type_", "ShortCut");
            item.put("Enable", (Boolean)shortCut.get(F_ENABLE));
            item.put("ShortCutName", (String)shortCut.get(F_LABEL));
            item.put("ShortCuts", (String)shortCut.get(F_SHORT_CUT));
            shortCutList.add(item);
        }
        return shortCutList;
    }

    private void returnDataToParent() {
        HashMap result = new HashMap();
        result.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        result.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        result.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        List<Map<String, Object>> shortCuts = this.getShortCuts();
        result.put("value", shortCuts);
        result.put("alias", "");
        this.getView().returnDataToParent(result);
        this.getView().close();
    }
}

