/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class SplitTableBelongPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRYKEY = "EntryEntity";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYKEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List suffixs;
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        List list = suffixs = formContext != null ? formContext : new ArrayList();
        if (!suffixs.isEmpty()) {
            IDataModel model = this.getModel();
            List splittableList = (List)((Map)suffixs.get(0)).get("SplitTables");
            if (splittableList != null && !splittableList.isEmpty()) {
                int[] rowkey = model.batchCreateNewEntryRow(ENTRYKEY, splittableList.size());
                int i = 0;
                for (Map s : splittableList) {
                    if (s.isEmpty()) continue;
                    model.setValue("suffix", s.get("Suffix"), rowkey[i]);
                    model.setValue("description", s.get("Description"), rowkey[i]);
                    ++i;
                }
                this.getView().updateView();
            }
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.returnDataToParent();
                break;
            }
            case "btncancel": {
                this.cancel();
                break;
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowKey = grid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        HashMap<String, Object> parent = new HashMap<String, Object>();
        if (rowKey >= 0) {
            parent.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            parent.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            parent.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            parent.put("value", model.getValue("Suffix", rowKey));
            this.getView().returnDataToParent(parent);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c", (String)"SplitTableBelongPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnDataToParent();
        this.getView().close();
    }
}

