/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.ExtensibleDao;

public class SplitTableListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRYKEY = "EntryEntity";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_DEL = "btndel";
    private static final String SUF_FIX = "suffix";
    private static final String SUF_FIX_1 = "Suffix";
    private static final String DESCRIPTION = "Description";
    private static final String ID = "id";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_NEW, BTN_DEL, "btnok", "btncancel"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.oriItemSplitTableLockType();
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        List splittableList = (List)(value instanceof List ? value : new ArrayList());
        if (!splittableList.isEmpty()) {
            String cache = this.getPageCache().get("OriItemSplitTableLockType_cache");
            Map mapping = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYKEY, splittableList.size());
            int i = 0;
            for (Map list : splittableList) {
                model.setValue(SUF_FIX, list.get(SUF_FIX_1), i);
                model.setValue("description", list.get(DESCRIPTION), i);
                if (StringUtils.isNotBlank(list.get("Id"))) {
                    if ("lock".equals(mapping.get(list.get("Id"))) || "speciallock".equals(mapping.get(list.get("Id")))) {
                        grid.setRowLock(Boolean.TRUE.booleanValue(), new int[]{i});
                    }
                    model.setValue(ID, list.get("Id"), i);
                }
                ++i;
            }
        } else {
            this.addOperation();
        }
    }

    private void oriItemSplitTableLockType() {
        HashMap map = new HashMap(16);
        Object va = this.getView().getFormShowParameter().getCustomParam("value");
        if (va != null) {
            String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
            String billEntityId = (String)((Map)((List)this.getView().getFormShowParameter().getCustomParam("context")).get(0)).get("Id");
            String entityId = "";
            entityId = !itemId.equals(billEntityId) ? billEntityId : itemId;
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            String lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)itemId, (String)"SplitTables").toString();
            if ("lock".equals(lockType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_NEW, BTN_DEL});
            } else if ("speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DEL});
            }
            List isvList = DesignerUtils.ISV_LIST;
            List value = va instanceof List ? (List)va : new ArrayList(1);
            HashMap<String, String> stIsv = new HashMap<String, String>(value.size());
            for (Map map2 : value) {
                stIsv.put(String.valueOf(map2.get("Id")), String.valueOf(map2.get("IsvFlag")));
            }
            for (Map.Entry entry : stIsv.entrySet()) {
                if (!isvList.contains(entry.getValue()) || ((String)entry.getValue()).equals(entityMetadata.getIsv())) continue;
                map.put(entry.getKey(), lockType);
            }
        }
        this.getPageCache().put("OriItemSplitTableLockType_cache", SerializationUtils.toJsonString(map));
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnnew": {
                this.addOperation();
                break;
            }
            case "btndel": {
                this.deleteOperation();
                break;
            }
            case "btnok": {
                this.close();
                break;
            }
            case "btncancel": {
                this.cancel();
                break;
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void close() {
        DynamicObjectCollection suffixList = this.getModel().getEntryEntity(ENTRYKEY);
        ArrayList items = new ArrayList();
        for (DynamicObject list : suffixList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(SUF_FIX_1, list.get(SUF_FIX));
            map.put(DESCRIPTION, list.get("description"));
            map.put("_Type_", "SplitTable");
            if (StringUtils.isNotBlank((Object)list.get(ID))) {
                map.put("Id", list.get(ID));
            } else {
                map.put("Id", list.get("seq"));
            }
            items.add(map);
        }
        String suffix = null;
        String description = null;
        HashSet<String> suffixSet = new HashSet<String>();
        HashMap parent = new HashMap();
        parent.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        parent.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        parent.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        if (!items.isEmpty()) {
            for (Map map : items) {
                description = (String)map.get(DESCRIPTION);
                suffix = (String)map.get(SUF_FIX_1);
                if (StringUtils.isBlank((CharSequence)suffix)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540e\u7f00\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SplitTableListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (suffix.length() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e\u4e00\u3002", (String)"SplitTableListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isBlank((CharSequence)description)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SplitTableListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)suffix, (CharSequence)"L")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u4ee5L\u7ed3\u5c3e\uff0c\u4e0e\u591a\u8bed\u8a00\u8868\u51b2\u7a81\u3002", (String)"SplitTableListPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (!suffixSet.add(suffix.toUpperCase())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540e\u7f00\u5df2\u5b58\u5728\u3002", (String)"SplitTableListPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (suffix.matches("[A-Za-z]")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540e\u7f00\u5fc5\u987b\u4e3a\u5b57\u6bcd\u3002", (String)"SplitTableListPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            parent.put("value", items);
        }
        this.getView().returnDataToParent(parent);
        this.getView().close();
    }

    private void addOperation() {
        int index = this.getModel().createNewEntryRow(ENTRYKEY);
        this.getModel().setValue(ID, (Object)Uuid16.create().toString(), index);
    }

    private void deleteOperation() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey >= 0) {
            String suffix = (String)this.getModel().getValue(SUF_FIX, rowKey);
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
                for (Map formMap : formContext) {
                    String suffixExist = (String)formMap.get(SUF_FIX_1);
                    if (!StringUtils.isNotBlank((CharSequence)suffixExist) || !suffix.equals(suffixExist)) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8868\u5df2\u88ab\u5f15\u7528\u3002", (String)"SplitTableListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
            this.getModel().deleteEntryRow(ENTRYKEY, rowKey);
            this.entryRowClick(new RowClickEvent((Object)this, rowKey - 1));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SplitTableListPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnnew": {
                this.addOperation();
                break;
            }
            case "btndel": {
                this.deleteOperation();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_NEW, BTN_DEL});
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            DynamicObject dyn;
            Object id;
            String cache = this.getPageCache().get("OriItemSplitTableLockType_cache");
            Map mapping = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            if ("lock".equals(mapping.get(id = (dyn = (DynamicObject)entryEntity.get(evt.getRow())).get(ID)))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_NEW, BTN_DEL});
            } else if ("speciallock".equals(mapping.get(id))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DEL});
            }
        }
    }
}

