/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class StatusIconEditPlugin
extends AbstractFormPlugin {
    private static final String PROCESS = "process";
    private static final String FINISH = "finish";
    private static final String ERROR = "error";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String[] statusArray = new String[]{"wait", "process", "finish", "error"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"wait", PROCESS, FINISH, ERROR, "btnok"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("ide_vectorList");
            formShowParameter.setCustomParam(PROPERTY_NAME, (Object)key);
            CloseCallBack callback = new CloseCallBack((IFormPlugin)this, key);
            formShowParameter.setCloseCallBack(callback);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map para = (Map)closedCallBackEvent.getReturnData();
        if (para == null) {
            return;
        }
        String value = (String)para.get(VALUE);
        String propertyName = (String)para.get(PROPERTY_NAME);
        this.getModel().setValue(propertyName, (Object)value);
        this.updateIconShowStatus(propertyName, value);
    }

    public void afterCreateNewData(EventObject e) {
        Map map;
        this.updateAllIconShowStatus();
        String value = (String)this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        try {
            map = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
        }
        catch (Exception e1) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("wait", map.get("wait"));
        model.setValue(PROCESS, map.get(PROCESS));
        model.setValue(FINISH, map.get(FINISH));
        model.setValue(ERROR, map.get(ERROR));
        this.updateAllIconShowStatus();
    }

    private void updateIconShowStatus(String name, Object value) {
        boolean notBlank = StringUtils.isNotBlank((Object)value);
        String vectorName = "icon_" + name;
        this.getView().setVisible(Boolean.valueOf(notBlank), new String[]{vectorName});
        if (notBlank) {
            Vector vector = (Vector)this.getControl(vectorName);
            vector.setFontClass(value.toString());
        }
    }

    private void updateAllIconShowStatus() {
        for (String status : statusArray) {
            Object value = this.getModel().getValue(status);
            this.updateIconShowStatus(status, value);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.updateIconShowStatus(e.getProperty().getName(), e.getChangeSet()[0].getNewValue());
    }

    private void returnData() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        para.put(VALUE, this.getStatusIconOptions());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private Object getStatusIconOptions() {
        IDataModel model = this.getModel();
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("wait", this.convertNullToEmptyString(model.getValue("wait")));
        map.put(PROCESS, this.convertNullToEmptyString(model.getValue(PROCESS)));
        map.put(FINISH, this.convertNullToEmptyString(model.getValue(FINISH)));
        map.put(ERROR, this.convertNullToEmptyString(model.getValue(ERROR)));
        if (StringUtils.isBlank((CharSequence)(map.get("wait").toString() + map.get(PROCESS).toString() + map.get(FINISH).toString() + map.get(ERROR).toString()))) {
            return "";
        }
        return SerializationUtils.toJsonString(map);
    }

    private String convertNullToEmptyString(Object obj) {
        if (!(obj instanceof String)) {
            return "";
        }
        if (StringUtils.isNotBlank((Object)obj)) {
            return (String)obj;
        }
        return "";
    }
}

