/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.designer.property.alias.StatusListPropertyConverter;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.url.UrlService;

public class StatusListPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String STATUS_IMAGE = "statusimage";
    private static final String VALUE = "value";
    private static final String STATUS_KEY = "statuskey";
    private static final String STATUS_NAME = "statusname";
    private static final String OPERATIONER_KEY = "operationerkey";
    private static final String OPERATION_DATE_KEY = "operationdatekey";
    private static final String CLEAR_OPERATION_KEY = "clearoperationkey";
    private static final String TYPE = "_Type_";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private List<List<Map<String, Object>>> context;
    private Map<String, Object> mapEntrys = new HashMap<String, Object>();
    private Map<String, Object> operationer = new HashMap<String, Object>();
    private Map<String, Object> operationDate = new HashMap<String, Object>();
    public static final String entryStatusControlKey = "entrystatuscontrol";
    private static final Log LOG = LogFactory.getLog(StatusListPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnnew", "btnok", "btncancel", "btnselect", "btnselectall", "btnselectnone", STATUS_IMAGE});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid grid = (AbstractGrid)this.getControl(entryStatusControlKey);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
        Object value = this.getView().getFormShowParameter().getCustomParam(VALUE);
        List statusList = value instanceof List ? (List)value : this.getBillStatuControlInfo();
        if (!statusList.isEmpty()) {
            int[] rowKey = this.getModel().batchCreateNewEntryRow(entryStatusControlKey, statusList.size());
            int i = 0;
            String rootUrl = UrlService.getDomainContextUrl();
            for (Map mapItem : statusList) {
                int index = rowKey[i];
                if (StringUtils.isNotBlank(mapItem.get(STATUS_IMAGE))) {
                    this.getModel().setValue(STATUS_IMAGE, (Object)(rootUrl + mapItem.get(STATUS_IMAGE)), index);
                }
                this.getModel().setValue(STATUS_KEY, mapItem.get(STATUS_KEY), index);
                this.getModel().setValue(STATUS_NAME, mapItem.get(STATUS_NAME), index);
                this.getModel().setValue(OPERATIONER_KEY, mapItem.get(OPERATIONER_KEY), index);
                this.getModel().setValue(OPERATION_DATE_KEY, mapItem.get(OPERATION_DATE_KEY), index);
                this.getModel().setValue(CLEAR_OPERATION_KEY, mapItem.get(CLEAR_OPERATION_KEY), index);
                this.getModel().setValue("trueid", mapItem.get("Id"), index);
                ++i;
            }
            this.initCombo();
            IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            viewProxy.invokeControlMethod(entryStatusControlKey, "selectRows", new Object[]{0});
            viewProxy.getEntryState(entryStatusControlKey).selectRow(0);
            try {
                this.initLockByBizExt();
            }
            catch (Exception exception) {
                LOG.info("initLockByBizExt error", (Object)exception);
            }
        }
    }

    private void initLockByBizExt() {
        Map<String, Object> map = this.getLockRowDataAndCache();
        if (!map.isEmpty()) {
            List statusItems = new ArrayList(10);
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
            String parentId = this.getPageCache().get("parentId");
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                EntityItem entityItem;
                EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)parentId, (MetaCategory)MetaCategory.Entity);
                String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
                if (metadata != null && (entityItem = metadata.getItemById(itemId)) instanceof BillStatusField) {
                    statusItems = ((BillStatusField)entityItem).getStatusItems();
                }
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryStatusControlKey);
            int j = 0;
            for (DynamicObject en : entryEntity) {
                Optional<StatusItem> first;
                String trueId = en.getString("trueid");
                if (map.containsKey(trueId) && (first = statusItems.stream().filter(s -> s.getId().equals(trueId)).findFirst()).isPresent()) {
                    StatusItem item = first.get();
                    String operationDateKey = item.getOperationDateKey();
                    String operationerKey = item.getOperationerKey();
                    this.getView().setEnable(Boolean.valueOf(StringUtils.isBlank((CharSequence)operationDateKey)), j, new String[]{OPERATION_DATE_KEY});
                    this.getView().setEnable(Boolean.valueOf(StringUtils.isBlank((CharSequence)operationerKey)), j, new String[]{OPERATIONER_KEY});
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{STATUS_KEY});
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{CLEAR_OPERATION_KEY});
                }
                ++j;
            }
        }
    }

    private Map<String, Object> getLockRowDataAndCache() {
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        if (this.context.get(0) == null) {
            return Collections.emptyMap();
        }
        List<Map<String, Object>> listCustData = this.context.get(0);
        String mainEntityId = (String)listCustData.get(0).get("Id");
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)mainEntityId)) {
            ExtLockTypeEnum lockType;
            List isvList;
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)mainEntityId, (MetaCategory)MetaCategory.Entity);
            if (entityMetadata == null || !"2".equals(entityMetadata.getDevType())) {
                return Collections.emptyMap();
            }
            this.getPageCache().put("parentId", entityMetadata.getParentId());
            EntityItem item = entityMetadata.getItemById(itemId);
            String fieldIsv = "";
            if (item instanceof BillStatusField && (isvList = DesignerUtils.ISV_LIST).contains(fieldIsv = item.getIsv()) && !StringUtils.equals((CharSequence)fieldIsv, (CharSequence)entityMetadata.getIsv()) && ExtLockTypeEnum.speciallock.equals((Object)(lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)itemId, (String)"StatusItems")))) {
                List statusItems = ((BillStatusField)item).getStatusItems();
                for (StatusItem statusItem : statusItems) {
                    if (!isvList.contains(statusItem.getIsv()) || StringUtils.equals((CharSequence)statusItem.getIsv(), (CharSequence)entityMetadata.getIsv())) continue;
                    map.put(statusItem.getId(), lockType.toString());
                }
            }
        }
        this.getPageCache().put("lockStatusItems_cache", SerializationUtils.toJsonString(map));
        return map;
    }

    public void entryRowClick(RowClickEvent e) {
        if (e.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
        String cache = this.getPageCache().get("lockStatusItems_cache");
        Map mapping = StringUtils.isNotBlank((CharSequence)cache) ? (Map)SerializationUtils.fromJsonString((String)cache, Map.class) : new HashMap(16);
        String id = (String)this.getModel().getValue("trueid", e.getRow());
        String lockType = (String)mapping.get(id);
        String lastRowValue = (String)this.getModel().getValue("trueid", e.getRow() - 1);
        String lastRowLockType = (String)mapping.get(lastRowValue);
        if ("lock".equals(lastRowLockType) || "speciallock".equals(lastRowLockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconbaritemap2"});
        }
        if ("speciallock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("deleteentry".equals(e.getOperateKey())) {
            String cache = this.getPageCache().get("lockStatusItems_cache");
            Map mapping = StringUtils.isNotBlank((CharSequence)cache) ? (Map)SerializationUtils.fromJsonString((String)cache, Map.class) : new HashMap(16);
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryStatusControlKey);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                int currentRow = selectRows[0];
                String id = (String)this.getModel().getValue("trueid", currentRow);
                if (mapping.containsKey(id)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"advconbaritemap1"});
                }
            }
        } else if ("moveentryup".equals(e.getOperateKey())) {
            String cache = this.getPageCache().get("lockStatusItems_cache");
            Map mapping = StringUtils.isNotBlank((CharSequence)cache) ? (Map)SerializationUtils.fromJsonString((String)cache, Map.class) : new HashMap(16);
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryStatusControlKey);
            int[] selectRows = entryGrid.getSelectRows();
            int currentRow = selectRows[0];
            String id = (String)this.getModel().getValue("trueid", currentRow - 1);
            String lockType = (String)mapping.get(id);
            if ("lock".equals(lockType) || "speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"moveup"});
            }
            this.entryRowClick(new RowClickEvent((Object)this, currentRow));
        } else if ("moveentrydown".equals(e.getOperateKey())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"moveup"});
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.close();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        } else if (STATUS_IMAGE.equalsIgnoreCase(((Control)src).getKey())) {
            this.showImageSelector(evt);
        }
    }

    private void init() {
        String type;
        this.context = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        if (this.context == null) {
            return;
        }
        for (Map<String, Object> field : this.context.get(0)) {
            type = (String)field.get(TYPE);
            String name = (String)field.get("Name");
            String id = (String)field.get("Id");
            if (!type.equalsIgnoreCase("EntryEntity") && !type.equalsIgnoreCase("SubEntryEntity") && !type.equalsIgnoreCase("BillEntity") && !type.equalsIgnoreCase("BaseEntity")) continue;
            if (type.equalsIgnoreCase("BillEntity") || type.equalsIgnoreCase("BaseEntity")) {
                this.mapEntrys.put(id, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"StatusListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                continue;
            }
            this.mapEntrys.put(id, name);
        }
        for (Map<String, Object> field : this.context.get(0)) {
            type = (String)field.get(TYPE);
            String key = (String)field.get("Key");
            String name = (String)field.get("Name");
            String parentId = (String)field.get("ParentId");
            String id = (String)field.get("Id");
            if (!type.contains("Field")) continue;
            if (type.equalsIgnoreCase("UserField")) {
                if (StringUtils.isBlank((CharSequence)parentId)) {
                    this.operationer.put(key, String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%s", (String)"StatusListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name));
                    continue;
                }
                this.operationer.put(key, this.mapEntrys.get(parentId) + "." + name);
                continue;
            }
            if (!type.equalsIgnoreCase("DateField") && !type.equalsIgnoreCase("DateTimeField")) continue;
            if (StringUtils.isBlank((CharSequence)parentId)) {
                this.operationDate.put(key, String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%s", (String)"StatusListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name));
                continue;
            }
            this.operationDate.put(key, this.mapEntrys.get(parentId) + "." + name);
        }
    }

    private List<Map<String, Object>> getBillStatuControlInfo() {
        ArrayList<Map<String, Object>> statusList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> mapCJ = new HashMap<String, Object>();
        mapCJ.put(STATUS_KEY, "A");
        mapCJ.put(STATUS_NAME, ResManager.loadKDString((String)"\u521b\u5efa", (String)"StatusListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        mapCJ.put(OPERATIONER_KEY, "");
        mapCJ.put(OPERATION_DATE_KEY, "");
        mapCJ.put(CLEAR_OPERATION_KEY, false);
        statusList.add(mapCJ);
        HashMap<String, Object> mapSHZ = new HashMap<String, Object>();
        mapSHZ.put(STATUS_KEY, "B");
        mapSHZ.put(STATUS_NAME, ResManager.loadKDString((String)"\u5ba1\u6838\u4e2d", (String)"StatusListPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        mapSHZ.put(OPERATIONER_KEY, "");
        mapSHZ.put(OPERATION_DATE_KEY, "");
        mapSHZ.put(CLEAR_OPERATION_KEY, false);
        statusList.add(mapSHZ);
        HashMap<String, Object> mapYSH = new HashMap<String, Object>();
        mapYSH.put(STATUS_KEY, "C");
        mapYSH.put(STATUS_NAME, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"StatusListPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        mapYSH.put(OPERATIONER_KEY, "");
        mapYSH.put(OPERATION_DATE_KEY, "");
        mapYSH.put(CLEAR_OPERATION_KEY, false);
        statusList.add(mapYSH);
        HashMap<String, Object> mapCXSH = new HashMap<String, Object>();
        mapCXSH.put(STATUS_KEY, "D");
        mapCXSH.put(STATUS_NAME, ResManager.loadKDString((String)"\u91cd\u65b0\u5ba1\u6838", (String)"StatusListPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        mapCXSH.put(OPERATIONER_KEY, "");
        mapCXSH.put(OPERATION_DATE_KEY, "");
        mapCXSH.put(CLEAR_OPERATION_KEY, true);
        statusList.add(mapCXSH);
        return statusList;
    }

    private void cancel() {
        this.getView().close();
    }

    private void close() {
        DynamicObjectCollection dyc;
        DynamicObjectCollection lstItem = dyc = this.getModel().getEntryEntity(entryStatusControlKey);
        int size = dyc.getDynamicObjectType().getProperties().size();
        ArrayList<Map<String, Object>> statusList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dynamicObject : lstItem) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            for (int i = 0; i < size; ++i) {
                String propName = ((IDataEntityProperty)dyc.getDynamicObjectType().getProperties().get(i)).getName();
                Object obj = dynamicObject.get(propName);
                if (STATUS_IMAGE.equals(propName) && null != obj) {
                    String temp = (String)obj;
                    String rootUrl = UrlService.getDomainContextUrl();
                    if (null == temp || !temp.contains(rootUrl)) continue;
                    map.put(propName, temp.substring(rootUrl.length()));
                    continue;
                }
                map.put(propName, obj);
            }
            statusList.add(map);
        }
        if (this.checkData(statusList)) {
            for (Map map : statusList) {
                String trueId = (String)map.get("trueid");
                String id = StringUtils.isBlank((CharSequence)trueId) ? Uuid16.create().toString() : trueId;
                map.put(TYPE, "StatusItem");
                map.put("Id", id);
            }
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("StatusItems", SerializationUtils.toJsonString(statusList));
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put(VALUE, statusList);
            para.put("alias", new StatusListPropertyConverter().convert(statusList));
            ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
            arrayList.add(para);
            this.getView().returnDataToParent(arrayList);
            this.getView().close();
        }
    }

    private void initCombo() {
        ComboItem comboItem;
        ArrayList<ComboItem> operationerList = new ArrayList<ComboItem>(16);
        ArrayList<ComboItem> operationDateList = new ArrayList<ComboItem>(16);
        ComboEdit comboOperationer = (ComboEdit)this.getView().getControl(OPERATIONER_KEY);
        ComboEdit comboOperationDate = (ComboEdit)this.getView().getControl(OPERATION_DATE_KEY);
        ComboItem comboItemNone = new ComboItem(new LocaleString(""), "");
        operationerList.add(comboItemNone);
        operationDateList.add(comboItemNone);
        for (Map.Entry<String, Object> set : this.operationer.entrySet()) {
            comboItem = new ComboItem(new LocaleString((String)set.getValue()), set.getKey());
            operationerList.add(comboItem);
        }
        for (Map.Entry<String, Object> set : this.operationDate.entrySet()) {
            comboItem = new ComboItem(new LocaleString((String)set.getValue()), set.getKey());
            operationDateList.add(comboItem);
        }
        comboOperationer.setComboItems(operationerList);
        comboOperationDate.setComboItems(operationDateList);
    }

    private boolean checkData(List<Map<String, Object>> statusList) {
        if (statusList != null && statusList.size() > 0) {
            HashSet<String> keySet = new HashSet<String>();
            HashSet<String> nameSet = new HashSet<String>();
            for (Map<String, Object> map : statusList) {
                if (StringUtils.isBlank((Object)map.get(STATUS_KEY))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StatusListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return false;
                }
                if (StringUtils.isBlank((Object)map.get(STATUS_NAME))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StatusListPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return false;
                }
                if (!keySet.add(((String)map.get(STATUS_KEY)).toLowerCase().trim())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u503c\u91cd\u590d\u3002", (String)"StatusListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return false;
                }
                if (nameSet.add(((String)map.get(STATUS_NAME)).toLowerCase().trim())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u540d\u79f0\u91cd\u590d\u3002", (String)"StatusListPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void showImageSelector(EventObject evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectImage"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectImage".equalsIgnoreCase(actionId)) {
            Map imgData = (Map)evt.getReturnData();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(entryStatusControlKey);
            int rowKey = grid.getEntryState().getFocusRow();
            String rootUrl = UrlService.getDomainContextUrl();
            if (StringUtils.isBlank(imgData.get(VALUE))) {
                this.getModel().setValue(STATUS_IMAGE, (Object)"", rowKey);
            } else {
                this.getModel().setValue(STATUS_IMAGE, (Object)(rootUrl + imgData.get(VALUE)), rowKey);
            }
        }
    }
}

