/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.TabLayout;
import kd.bos.metadata.TabLayoutItem;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;

public class TabLayoutPlugin
extends AbstractFormPlugin {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TXT_NAME = "txtname";
    private static final String TXT_KEY = "txtkey";
    private static final String CMB_GROUP = "cmbgroup";
    private static final String BTN_OK = "btnok";
    private static final String LBL_RESET = "lblreset";
    private static final String ENABLE_CFG = "enablecfg";
    private static final String SPLIT_POS = "splitpos";
    private static final String _TAB_LAYOUT = "TabLayout";
    private static final String _ENABLED = "Enabled";
    private static final String _SPLIT_POS = "SplitPos";
    private static final String _PanelKey = "PanelKey";
    private static final String _Order = "Order";
    private static final String _Group = "Group";
    private static final String _TabLayoutItems = "TabLayoutItems";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String _TYPE_ = "_Type_";
    private static final String VALUE = "value";
    private static final String ALIAS = "alias";
    private static final String _40 = "40%";
    private static final String BLANK = "";
    private static final int GROUP_NONE = -1;
    private static final String STR_FALSE = "false";
    private static final String STR_TRUE = "true";

    public void initialize() {
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", STR_FALSE);
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", STR_TRUE);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, LBL_RESET});
    }

    public void afterCreateNewData(EventObject e) {
        PropertyEditHelper helper = new PropertyEditHelper();
        List<Map<String, Object>> formItems = helper.getFormMeta(this.getView());
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(formItems);
        formMetadata.createIndex(true);
        FormAp formAp = formMetadata.getRootAp();
        TabLayout tabLayout = formAp.getTabLayout();
        if (tabLayout != null) {
            this.getModel().setValue(ENABLE_CFG, (Object)tabLayout.isEnabled());
            this.getModel().setValue(SPLIT_POS, (Object)tabLayout.getSplitPos());
            List tabLayoutItems = tabLayout.getTabLayoutItems();
            tabLayoutItems.sort(Comparator.comparingInt(item -> item.getGroup() != -1 ? item.getGroup() : 2).thenComparingInt(TabLayoutItem::getOrder));
            if (!tabLayoutItems.isEmpty()) {
                ControlAp parent;
                int row;
                String parentId = null;
                for (Object tabLayoutItem2 : tabLayoutItems) {
                    ControlAp controlAp = this.getControlAp(formMetadata, tabLayoutItem2.getPanelKey());
                    row = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                    if (controlAp != null) {
                        if (parentId == null) {
                            parentId = controlAp.getParentId();
                        } else if (!BLANK.equals(parentId) && !parentId.equals(controlAp.getParentId())) {
                            parentId = BLANK;
                        }
                        this.getModel().setValue(TXT_NAME, (Object)controlAp.getName().getLocaleValue(), row);
                    } else {
                        this.getModel().setValue(TXT_NAME, (Object)tabLayoutItem2.getPanelKey(), row);
                    }
                    this.getModel().setValue(TXT_KEY, (Object)tabLayoutItem2.getPanelKey(), row);
                    this.getModel().setValue(CMB_GROUP, (Object)(tabLayoutItem2.getGroup() == -1 ? null : Integer.valueOf(tabLayoutItem2.getGroup())), row);
                }
                if (StringUtils.isNotBlank(parentId) && (parent = formMetadata.getItem(parentId)) instanceof ContainerAp) {
                    for (ControlAp controlAp : ((ContainerAp)parent).getItems()) {
                        if (!tabLayoutItems.stream().noneMatch(tabLayoutItem -> StringUtils.equals((CharSequence)controlAp.getKey(), (CharSequence)tabLayoutItem.getPanelKey())) || !this.isCollapsible(controlAp) || controlAp.isHidden() || controlAp.isInvisible()) continue;
                        row = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                        this.getModel().setValue(TXT_NAME, (Object)controlAp.getName().getLocaleValue(), row);
                        this.getModel().setValue(TXT_KEY, (Object)controlAp.getKey(), row);
                        this.getModel().setValue(CMB_GROUP, null, row);
                    }
                }
            }
            return;
        }
        HashMap collapPanelMap = new HashMap();
        List items = formAp.getItems();
        if (!items.isEmpty()) {
            this.getCollapPanel(items, collapPanelMap);
        }
        for (Map.Entry entry : collapPanelMap.entrySet()) {
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                ControlAp controlAp = (ControlAp)((List)entry.getValue()).get(i);
                this.getModel().setValue(TXT_NAME, (Object)controlAp.getName().getLocaleValue(), i);
                this.getModel().setValue(TXT_KEY, (Object)controlAp.getKey(), i);
            }
        }
    }

    private void getCollapPanel(List<ControlAp<?>> items, Map<String, List<ControlAp<?>>> map) {
        ArrayList controlAps = new ArrayList();
        for (ControlAp<?> controlAp : items) {
            List items1;
            if (this.isCollapsible(controlAp)) {
                if (controlAp.isHidden() || controlAp.isInvisible()) continue;
                String parentId = controlAp.getParentId();
                List<ControlAp<?>> flexPanelAps = map.get(parentId);
                if (flexPanelAps == null) {
                    flexPanelAps = new ArrayList();
                }
                flexPanelAps.add(controlAp);
                map.put(parentId, flexPanelAps);
            }
            if (!(controlAp instanceof ContainerAp) || (items1 = ((ContainerAp)controlAp).getItems()).isEmpty()) continue;
            controlAps.addAll(items1);
        }
        if (!controlAps.isEmpty() && map.isEmpty()) {
            this.getCollapPanel(controlAps, map);
        }
    }

    private boolean isCollapsible(ControlAp<?> controlAp) {
        if ((controlAp instanceof FlexPanelAp || controlAp instanceof FieldsetPanelAp || controlAp instanceof AdvConAp) && ((ContainerAp)controlAp).isCollapsible()) {
            return true;
        }
        return controlAp instanceof AttachmentPanelAp && ((AttachmentPanelAp)controlAp).isCollapsible();
    }

    private ControlAp<?> getControlAp(FormMetadata formMetadata, String panelKey) {
        for (ControlAp item : formMetadata.getItems()) {
            if (!item.getKey().equals(panelKey)) continue;
            return item;
        }
        return null;
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (BTN_OK.equals(ctl.getKey())) {
            this.closeAndReturnData();
        }
        if (LBL_RESET.equals(ctl.getKey())) {
            this.resetPanels();
        }
    }

    private void closeAndReturnData() {
        String splitPosStr;
        HashMap para = new HashMap(16);
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put(_TYPE_, _TAB_LAYOUT);
        Object enablecfg = this.getModel().getValue(ENABLE_CFG);
        value.put(_ENABLED, enablecfg);
        Object splitPos = this.getModel().getValue(SPLIT_POS);
        String string = splitPosStr = StringUtils.isBlank((Object)splitPos) ? _40 : String.valueOf(splitPos);
        if (StringUtils.isBlank((Object)splitPos) || !TabLayoutPlugin.isValidNumber(splitPosStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5272\u4f4d\u7f6e\u53d6\u503c\u8303\u56f41~2000px\u62161~100%\u3002", (String)"TabLayoutPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        value.put(_SPLIT_POS, splitPosStr);
        ArrayList list = new ArrayList();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (dynamicObjects.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u7b7e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TabLayoutPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put(_PanelKey, dynamicObject.getString(TXT_KEY));
            map2.put(_Order, index);
            Object grpObj = dynamicObject.get(CMB_GROUP);
            map2.put(_Group, StringUtils.isBlank((Object)grpObj) ? Integer.valueOf(-1) : grpObj);
            list.add(map2);
            ++index;
        }
        value.put(_TabLayoutItems, list);
        para.put(VALUE, value);
        para.put(ALIAS, BLANK);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void resetPanels() {
        PropertyEditHelper helper = new PropertyEditHelper();
        List<Map<String, Object>> formItems = helper.getFormMeta(this.getView());
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(formItems);
        formMetadata.createIndex(true);
        FormAp formAp = formMetadata.getRootAp();
        HashMap collapPanelMap = new HashMap();
        this.getCollapPanel(formAp.getItems(), collapPanelMap);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        for (Map.Entry entry : collapPanelMap.entrySet()) {
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                ControlAp controlAp = (ControlAp)((List)entry.getValue()).get(i);
                this.getModel().setValue(TXT_NAME, (Object)controlAp.getName().getLocaleValue(), i);
                this.getModel().setValue(TXT_KEY, (Object)controlAp.getKey(), i);
            }
        }
        this.getModel().setValue(SPLIT_POS, (Object)_40);
        this.getModel().setValue(ENABLE_CFG, (Object)Boolean.FALSE);
    }

    private static boolean isValidNumber(String str) {
        Pattern pattern = Pattern.compile("^([\\d]*)(%|px)$");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            int i = Integer.parseInt(matcher.group(1));
            if (i <= 0) {
                return false;
            }
            String suffix = matcher.group(2);
            if (StringUtils.isBlank((CharSequence)suffix)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)suffix, (CharSequence)"%")) {
                return i <= 100;
            }
            if (StringUtils.equals((CharSequence)suffix, (CharSequence)"px")) {
                return i <= 2000;
            }
        }
        return false;
    }
}

