/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.util.StringUtils;

public class TabPageOperationPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String F_OPERATION_KEY = "foperationkey";
    private static final String VALUE = "value";
    private static final String CONTEXT = "context";
    private static final String ITEM_ID = "itemId";
    private String entryKey = "entryentity";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        TextEdit opSelect = (TextEdit)this.getControl(F_OPERATION_KEY);
        opSelect.addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)(value instanceof List ? value : new ArrayList());
        if (items != null && items.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow(this.entryKey, items.size());
            int i = 0;
            for (Map item : items) {
                model.setValue("fid", item.get("Id"), rowIndexs[i]);
                model.setValue("fkey", item.get("Key"), rowIndexs[i]);
                model.setValue(F_OPERATION_KEY, item.get("OperationKey"), rowIndexs[i]);
                model.setValue("ftitle", item.get("Title"), rowIndexs[i]);
                model.setValue("lock", item.get("Lock"), rowIndexs[i]);
                model.setValue("visible", item.get("Visible"), rowIndexs[i]);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "foperationkey": {
                this.showOperationSelector(evt);
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void showOperationSelector(EventObject evt) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_operationselect");
        parameter.setCustomParam(CONTEXT, (Object)context);
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        parameter.setCustomParam("designerEntityId", this.getView().getFormShowParameter().getCustomParam("designerEntityId"));
        parameter.setCustomParam("lastEntityVersion", this.getView().getFormShowParameter().getCustomParam("lastEntityVersion"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOperation"));
        parameter.setCustomParam("designerPageId", this.getView().getFormShowParameter().getCustomParam("designerPageId"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectOperation".equalsIgnoreCase(actionId)) {
            Object retData = evt.getReturnData();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
            int rowKey = grid.getEntryState().getFocusRow();
            if (retData instanceof Map) {
                this.getModel().setValue(F_OPERATION_KEY, (Object)((String)((Map)retData).get(VALUE)), rowKey);
            } else {
                this.getModel().setValue(F_OPERATION_KEY, ((Map)((List)retData).get(0)).get(VALUE), rowKey);
            }
        }
    }

    private void returnData() {
        HashSet<String> allItems = new HashSet<String>(16);
        String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID);
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (context.size() >= 2 && context.get(1) instanceof List) {
            List formItems = (List)context.get(1);
            formItems.forEach(formItem -> {
                List dropdownItems = (List)formItem.get("DropdownItems");
                if (dropdownItems != null && !dropdownItems.isEmpty() && !itemId.equals(formItem.get("Id"))) {
                    dropdownItems.forEach(item -> {
                        if (item.containsKey("Key")) {
                            allItems.add((String)item.get("Key"));
                        }
                    });
                }
            });
        }
        ArrayList<DropdownItem> currItems = new ArrayList<DropdownItem>(10);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(this.entryKey);
        for (int i = 0; i < rowCount; ++i) {
            String key = (String)model.getValue("fkey", i);
            String title = (String)model.getValue("ftitle", i);
            String opkey = (String)model.getValue(F_OPERATION_KEY, i);
            String lock = (String)model.getValue("lock", i);
            String visible = (String)model.getValue("visible", i);
            if (visible == null) {
                visible = "";
            }
            String id = (String)model.getValue("fid", i);
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)title)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5b58\u5728\u7a7a\u6570\u636e\uff0c\u8bf7\u586b\u5199\u3002", (String)"TabPageOperationPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]), i + 1));
                return;
            }
            DropdownItem item = new DropdownItem(key, title, null, opkey, null, lock, visible);
            if (allItems.contains(item.getKey())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0cKey\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TabPageOperationPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]), i + 1));
                return;
            }
            item.setId(id);
            allItems.add(item.getKey());
            currItems.add(item);
        }
        DropdownMenuJsonSerializer dropdownJson = new DropdownMenuJsonSerializer();
        dropdownJson.setItems(currItems);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(DropdownMenuJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapCombo = serializer.serializeToMap((Object)dropdownJson, null);
        HashMap para = new HashMap();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, mapCombo.containsKey("Items") ? mapCombo.get("Items") : currItems);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "foperationkey": {
                this.showOperationSelector((EventObject)evt);
                break;
            }
        }
    }

    public static class DropdownMenuJsonSerializer {
        private List<DropdownItem> items = new ArrayList<DropdownItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=DropdownItem.class)
        public List<DropdownItem> getItems() {
            return this.items;
        }

        public void setItems(List<DropdownItem> items) {
            this.items = items;
        }
    }
}

