/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class TimelineOptionsEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "EntryEntity";
    private static final int RETURN_DATA_MAP_SIZE = 16;
    private static final String TITLE = "Title";
    private static final String DESCRIPTION = "Description";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (!(value instanceof List)) {
            return;
        }
        List items = (List)value;
        IDataModel model = this.getModel();
        int[] rowIndexs = model.batchCreateNewEntryRow(ENTRY_ENTITY, items.size());
        int i = 0;
        for (Map item : items) {
            Map label = (Map)item.get("Label");
            Map content = (Map)item.get("Content");
            model.setValue("label_title", label.get(TITLE), rowIndexs[i]);
            model.setValue("label_desc", label.get(DESCRIPTION), rowIndexs[i]);
            model.setValue("content_title", content.get(TITLE), rowIndexs[i]);
            model.setValue("content_desc", content.get(DESCRIPTION), rowIndexs[i]);
            model.setValue("id", item.get("Id"), rowIndexs[i]);
            ++i;
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        HashMap<String, Object> para = new HashMap<String, Object>(16);
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", this.getStepsOptions());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private Object getStepsOptions() {
        DynamicObjectCollection objects = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList list = new ArrayList(objects.size());
        for (DynamicObject object : objects) {
            HashMap<String, Object> label = new HashMap<String, Object>(16);
            label.put(TITLE, object.get("label_title"));
            label.put(DESCRIPTION, object.get("label_desc"));
            HashMap<String, Object> content = new HashMap<String, Object>(16);
            content.put(TITLE, object.get("content_title"));
            content.put(DESCRIPTION, object.get("content_desc"));
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("Label", label);
            map.put("Content", content);
            map.put("Seq", object.get("seq"));
            map.put("Id", object.get("id"));
            list.add(map);
        }
        return list;
    }
}

