/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.TipLinkTitle;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;

public class TipsSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final List<String> canModifyShowIconControl = Arrays.asList("ButtonAp", "LabelAp", "ImageAp", "VectorAp", "BarItemAp");
    private static final String ICON_CLASSNAME = "iconclassname";
    private static final String VALUE = "value";
    private static final String SHOW_ICON = "ShowIcon";
    private static final String SHOW_ICON_1 = "showicon";
    private static final String ICON_CLASS_NAME = "IconClassName";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String SHOW_TYPE = "showtype";
    private static final String TRIGGER_TYPE_TEXT = "triggertypetext";
    private static final String TRIGGER_TYPE = "TriggerType";
    private static final String HOVER = "hover";
    private static final String BILL_NO = "billno";
    private static final String TRIGGER_TYPE_BILL = "triggertypebill";
    private static final String ADVCONAP = "advconap";
    private static final String TYPE = "_Type_";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FIELD_ISCONFIRM = "isconfirm";
    private static final String INDEX = "index";
    private static final String CLICKTYPE = "click";
    private static final String PLACE = "place";
    private static final String Link = "link";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnadd", "btndelete", ICON_CLASSNAME});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control ctl = this.getControl(BILL_NO);
        if (ctl instanceof BasedataEdit) {
            ((BasedataEdit)ctl).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.returnDataToParentAndClose();
        } else if (ICON_CLASSNAME.equals(key)) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("ide_vectorlist");
            para.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "choosefontclass");
            para.setCloseCallBack(callBack);
            this.getView().showForm(para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String value;
        String actionId = event.getActionId();
        Map data = (Map)event.getReturnData();
        if ("choosefontclass".equals(actionId) && data != null && data.size() > 0 && StringUtils.isNotBlank((CharSequence)(value = (String)data.get(VALUE)))) {
            this.getModel().setValue(ICON_CLASSNAME, (Object)value);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("btnadd".equalsIgnoreCase(key)) {
            this.addComboItem();
        } else if ("btndelete".equalsIgnoreCase(key)) {
            this.deleteComboItem();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map tipsMap = null;
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isNotBlank(value)) {
            Map map = tipsMap = value instanceof Map ? (Map)value : (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
        }
        if (tipsMap != null) {
            String type = (String)tipsMap.get("Type");
            String place = (String)tipsMap.get("Place");
            this.getModel().setValue(PLACE, (Object)(place == null ? "0" : place));
            boolean showIcon = tipsMap.get(SHOW_ICON) != null ? (Boolean)tipsMap.get(SHOW_ICON) : true;
            this.getModel().setValue(SHOW_ICON_1, (Object)showIcon);
            this.getModel().setValue(FIELD_ISCONFIRM, tipsMap.get("IsConfirm"));
            if (showIcon) {
                this.getModel().setValue(ICON_CLASSNAME, (Object)(tipsMap.get(ICON_CLASS_NAME) != null ? (String)tipsMap.get(ICON_CLASS_NAME) : ""));
            }
            if ("text".equals(type)) {
                Object _link = tipsMap.get("Link");
                boolean link = _link == null ? false : (Boolean)_link;
                this.getModel().setValue(TITLE, tipsMap.get("Title"));
                this.getModel().setValue(CONTENT, tipsMap.get("Content"));
                this.getModel().setValue(SHOW_TYPE, (Object)"1");
                this.getModel().setValue(Link, (Object)link);
                this.getModel().setValue(TRIGGER_TYPE_TEXT, tipsMap.get(TRIGGER_TYPE) != null ? tipsMap.get(TRIGGER_TYPE) : HOVER);
                if (link) {
                    List linkData = (List)tipsMap.get("LinkData");
                    DcJsonSerializer serializer = this.getSerializer();
                    Tips tipsEntity = (Tips)serializer.deserializeFromMap(tipsMap, null);
                    Map<String, TipLinkTitle> titleMap = tipsEntity.getLinkTitles().stream().collect(Collectors.toMap(t -> t.getIndex(), t -> t));
                    if (linkData != null && linkData.size() > 0) {
                        int[] rowIndexes = this.getModel().batchCreateNewEntryRow(ENTRY_KEY, linkData.size());
                        int i = 0;
                        for (Map data : linkData) {
                            String index = data.get(INDEX).toString();
                            TipLinkTitle title = titleMap.get(index);
                            Object oldName = data.get("name");
                            this.getModel().setValue("findex", data.get(INDEX), rowIndexes[i]);
                            this.getModel().setValue("fname", title == null ? oldName : title.getDisplayName().toString(), rowIndexes[i]);
                            this.getModel().setValue("fcode", data.get("code"), rowIndexes[i]);
                            if (oldName instanceof String) {
                                this.getModel().setValue("fname1", data.get("name"), rowIndexes[i]);
                            } else if (oldName instanceof JSONObject) {
                                this.getModel().setValue("fname1", (Object)((JSONObject)data.get("name")).getString(Lang.get().name()), rowIndexes[i]);
                            } else if (oldName == null) {
                                this.getModel().setValue("fname1", (Object)(title == null ? "" : title.getDisplayName().toString()), rowIndexes[i]);
                            }
                            ++i;
                        }
                    }
                }
                this.textShow();
            } else {
                this.getModel().setValue(SHOW_TYPE, (Object)"2");
                this.getModel().setValue(BILL_NO, tipsMap.get("Billno"));
                this.getModel().setValue(TRIGGER_TYPE_BILL, tipsMap.get(TRIGGER_TYPE) != null ? tipsMap.get(TRIGGER_TYPE) : CLICKTYPE);
                this.billShow();
            }
        } else {
            this.getModel().setValue(SHOW_TYPE, (Object)"1");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_NO});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADVCONAP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TRIGGER_TYPE_BILL});
        }
        this.getView().setVisible(Boolean.valueOf(this.showIconConfigVisiable()), new String[]{SHOW_ICON_1});
        if (this.isFromMobile()) {
            this.mobileChange();
        }
    }

    private void mobileChange() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ADVCONAP, Link, SHOW_ICON_1, FIELD_ISCONFIRM, TRIGGER_TYPE_TEXT, TRIGGER_TYPE_BILL, PLACE});
        this.getModel().setValue(TRIGGER_TYPE_TEXT, (Object)CLICKTYPE);
        this.getModel().setValue(TRIGGER_TYPE_BILL, (Object)CLICKTYPE);
    }

    private boolean isFromMobile() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("isPC");
        boolean isPC = StringUtils.isBlank((Object)customParam) || Boolean.parseBoolean(customParam.toString());
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        return "MobileBillFormModel".equals(modelType) || "MobileFormModel".equals(modelType) || "BillFormModel".equals(modelType) && !isPC;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object data = e.getChangeSet()[0].getNewValue();
        String propName = e.getProperty().getName();
        if (SHOW_TYPE.equals(propName)) {
            String value = (String)data;
            if ("1".equals(value)) {
                this.textShow();
            } else if ("2".equals(value)) {
                this.billShow();
            }
            if (this.isFromMobile()) {
                this.mobileChange();
            }
        } else if (Link.equals(propName)) {
            boolean value = (Boolean)data;
            this.getView().setVisible(Boolean.valueOf(value), new String[]{ADVCONAP});
        } else if (SHOW_ICON_1.equals(propName)) {
            boolean value = (Boolean)data;
            this.getView().setVisible(Boolean.valueOf(value), new String[]{ICON_CLASSNAME});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{TRIGGER_TYPE_BILL});
        } else if (FIELD_ISCONFIRM.equals(propName) && ((Boolean)data).booleanValue()) {
            this.getModel().setValue(TRIGGER_TYPE_TEXT, (Object)CLICKTYPE);
        }
    }

    private void lockBillTriggerByControlType(boolean showIocn) {
        JSONArray context = (JSONArray)this.getView().getFormShowParameter().getCustomParam("context");
        if (context != null && context.size() > 0) {
            JSONObject item = context.getJSONObject(0);
            String type = item.getString(TYPE);
            if (!"LabelAp".equals(type) && canModifyShowIconControl.contains(type) && !showIocn) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{TRIGGER_TYPE_BILL});
                this.getModel().setValue(TRIGGER_TYPE_BILL, (Object)HOVER);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{TRIGGER_TYPE_BILL});
            }
        }
    }

    private void billShow() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TITLE});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{CONTENT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ADVCONAP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{Link});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TRIGGER_TYPE_TEXT});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BILL_NO});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TRIGGER_TYPE_BILL});
        boolean showIcon = (Boolean)this.getModel().getValue(SHOW_ICON_1);
        this.getView().setVisible(Boolean.valueOf(showIcon), new String[]{ICON_CLASSNAME});
    }

    private void textShow() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TITLE});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{CONTENT});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{Link});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TRIGGER_TYPE_TEXT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BILL_NO});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TRIGGER_TYPE_BILL});
        boolean showIcon = (Boolean)this.getModel().getValue(SHOW_ICON_1);
        this.getView().setVisible(Boolean.valueOf(showIcon), new String[]{ICON_CLASSNAME});
        boolean hasLink = (Boolean)this.getModel().getValue(Link);
        this.getView().setVisible(Boolean.valueOf(hasLink), new String[]{ADVCONAP});
    }

    private List<Map<String, Object>> getComboItems() {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyobjs = model.getEntryEntity(ENTRY_KEY);
        boolean needWaring = false;
        if (rowKeyobjs != null) {
            for (DynamicObject rowKeyObj : rowKeyobjs) {
                String index = rowKeyObj.getString("findex");
                OrmLocaleValue name = (OrmLocaleValue)rowKeyObj.getLocaleString("fname");
                String name1 = rowKeyObj.getString("fname1");
                if (name != null) {
                    name.setItem(Lang.get().name(), name1);
                    if (StringUtils.isNotEmpty((CharSequence)name.getItem(Lang.zh_CN.name())) && StringUtils.isEmpty((CharSequence)name.getItem(Lang.en_US.name()))) {
                        name.setItem(Lang.en_US.name(), name.getItem(Lang.zh_CN.name()));
                    }
                }
                String code = rowKeyObj.getString("fcode");
                if (StringUtils.isBlank((CharSequence)index) || name == null || StringUtils.isBlank((CharSequence)name.toString()) || StringUtils.isBlank((CharSequence)code)) {
                    needWaring = true;
                    break;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (Pattern.compile("[0-9]*").matcher(String.valueOf(index)).matches()) {
                    map.put(INDEX, Integer.parseInt(index));
                } else {
                    map.put(INDEX, index);
                }
                map.put("name", name);
                map.put("code", code);
                items.add(map);
            }
        }
        return needWaring ? Collections.EMPTY_LIST : items;
    }

    private void returnDataToParentAndClose() {
        HashMap para = new HashMap();
        HashMap<String, Object> data = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        String radioValue = (String)this.getModel().getValue(SHOW_TYPE);
        String fontClass = (String)this.getModel().getValue(ICON_CLASSNAME);
        Object showicon = this.getModel().getValue(SHOW_ICON_1);
        Boolean isConfirm = (Boolean)this.getModel().getValue(FIELD_ISCONFIRM);
        String place = (String)this.getModel().getValue(PLACE);
        if (!"0".equals(place)) {
            data.put("Place", place);
        }
        data.put(TYPE, "Tips");
        if (StringUtils.isNotBlank((CharSequence)fontClass)) {
            data.put(ICON_CLASS_NAME, fontClass);
        }
        data.put(SHOW_ICON, showicon == null ? Boolean.TRUE : (Boolean)showicon);
        if ("1".equals(radioValue)) {
            boolean link;
            String title = (String)this.getModel().getValue(TITLE);
            String content = (String)this.getModel().getValue(CONTENT);
            String triggerType = (String)this.getModel().getValue(TRIGGER_TYPE_TEXT);
            Object _link = this.getModel().getValue(Link);
            boolean bl = link = _link == null ? false : (Boolean)_link;
            if (content == null || StringUtils.isBlank((CharSequence)content.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8981\u6c42\u7684\u5185\u5bb9\u3002", (String)"TipsSettingPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            data.put("Title", title);
            data.put("Type", "text");
            data.put("Content", content);
            data.put(TRIGGER_TYPE, StringUtils.isNotBlank((CharSequence)triggerType) ? triggerType : HOVER);
            data.put("IsConfirm", isConfirm);
            if (link) {
                data.put("Link", link);
                List<Map<String, Object>> items = this.getComboItems();
                String str = null;
                Iterator<Map<String, Object>> iterator = items.iterator();
                if (items.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u94fe\u63a5\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TipsSettingPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                Boolean flag = true;
                while (iterator.hasNext()) {
                    Map<String, Object> m = iterator.next();
                    str = m.get(INDEX).toString();
                    if (Pattern.compile("[0-9]*").matcher(String.valueOf(str)).matches()) continue;
                    flag = false;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7d22\u5f15\u201d\u53ea\u80fd\u662f\u6570\u5b57\u3002", (String)"TipsSettingPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                ArrayList<Map> linkTitles = new ArrayList<Map>(items.size());
                DcJsonSerializer serializer = this.getSerializer();
                for (Map<String, Object> item : items) {
                    Map titleName = (Map)item.remove("name");
                    String index = item.get(INDEX).toString();
                    TipLinkTitle titleObj = new TipLinkTitle();
                    titleObj.setIndex(index);
                    titleObj.setDisplayName(LocaleString.fromMap((Map)titleName));
                    linkTitles.add(serializer.serializeToMap((Object)titleObj, null));
                }
                if (flag.booleanValue()) {
                    data.put("LinkData", items);
                    data.put("LinkTitles", linkTitles);
                }
            }
        } else {
            Object value = this.getModel().getValue(BILL_NO);
            String billno = "";
            if (value instanceof DynamicObject) {
                billno = ((DynamicObject)value).getString("number");
            }
            String triggerType = (String)this.getModel().getValue(TRIGGER_TYPE_BILL);
            if (StringUtils.isBlank((CharSequence)billno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TipsSettingPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!MetadataDao.checkNumber((String)billno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5165\u6709\u6548\u7684\u8868\u5355\u53f7\u3002", (String)"TipsSettingPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            data.put("Type", "bill");
            data.put("Billno", billno);
            data.put(TRIGGER_TYPE, StringUtils.isNotBlank((CharSequence)triggerType) ? triggerType : CLICKTYPE);
        }
        para.put(VALUE, data);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private DcJsonSerializer getSerializer() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>(1);
        dts.add(OrmUtils.getDataEntityType(Tips.class));
        dts.add(OrmUtils.getDataEntityType(TipLinkTitle.class));
        ListDcxmlBinder binder = new ListDcxmlBinder(false, dts);
        return new DcJsonSerializer((DcBinder)binder);
    }

    private void deleteComboItem() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        int[] rowIndexs = proxy.getEntryState(ENTRY_KEY).getSelectedRows();
        if (rowIndexs.length > 0 && rowIndexs[0] != -1) {
            model.deleteEntryRows(ENTRY_KEY, rowIndexs);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TipsSettingPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void addComboItem() {
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        model.getDataEntity(true);
        int newRowKey = model.createNewEntryRow(ENTRY_KEY);
        grid.selectRows(newRowKey, true);
    }

    private boolean showIconConfigVisiable() {
        String listType = (String)this.getView().getFormShowParameter().getCustomParam(TYPE);
        if (StringUtils.isNotBlank((CharSequence)listType)) {
            return canModifyShowIconControl.contains(listType);
        }
        JSONArray context = (JSONArray)this.getView().getFormShowParameter().getCustomParam("context");
        if (context != null && context.size() > 0) {
            JSONObject item = context.getJSONObject(0);
            String type = item.getString(TYPE);
            return canModifyShowIconControl.contains(type);
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (this.isFromMobile()) {
            ArrayList<String> filterParm = new ArrayList<String>(2);
            filterParm.add("MobileBillFormModel");
            filterParm.add("MobileFormModel");
            QFilter qFilter = new QFilter("modeltype", "in", filterParm);
            evt.addCustomQFilter(qFilter);
        }
    }
}

