/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class TransferContainerSettingPlugin
extends AbstractFormPlugin {
    private static final String SIZE_WIDTH = "size_width";
    private static final String SIZE_HEIGHT = "size_height";
    private static final String TITLE_LIFT = "title_lift";
    private static final String TITLE_RIGHT = "title_right";
    private static final String BUTTON_OK = "button_ok";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_OK});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BUTTON_OK.equals(control.getKey())) {
            this.returnDataToParentAndClose();
        }
        super.click(evt);
    }

    private void returnDataToParentAndClose() {
        HashMap para = new HashMap();
        HashMap<String, Cloneable> allData = new HashMap<String, Cloneable>();
        HashMap<String, Integer> sizeData = new HashMap<String, Integer>();
        ArrayList<LocaleString> titleData = new ArrayList<LocaleString>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        IDataModel model = this.getModel();
        Integer width = (Integer)model.getValue(SIZE_WIDTH);
        Integer height = (Integer)model.getValue(SIZE_HEIGHT);
        OrmLocaleValue titleLift = (OrmLocaleValue)model.getValue(TITLE_LIFT);
        OrmLocaleValue titleRight = (OrmLocaleValue)model.getValue(TITLE_RIGHT);
        sizeData.put(WIDTH, width);
        sizeData.put(HEIGHT, height);
        titleData.add(LocaleString.fromMap((Map)titleLift));
        titleData.add(LocaleString.fromMap((Map)titleRight));
        allData.put("size", sizeData);
        allData.put("title", titleData);
        para.put("value", allData);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        Map settingMap = null;
        if (value != null) {
            Map map = settingMap = value instanceof Map ? (Map)value : (Map)SerializationUtils.fromJsonString((String)value.toString(), Map.class);
        }
        if (settingMap != null) {
            List title;
            Map size = (Map)settingMap.get("size");
            if (size != null) {
                if (size.get(WIDTH) != null) {
                    this.getModel().setValue(SIZE_WIDTH, size.get(WIDTH));
                }
                if (size.get(HEIGHT) != null) {
                    this.getModel().setValue(SIZE_HEIGHT, size.get(HEIGHT));
                }
            }
            if ((title = (List)settingMap.get("title")) != null && title.size() == 2) {
                LocaleString titleLeft = null;
                LocaleString titleRight = null;
                Object left = title.get(0);
                Object right = title.get(1);
                if (left instanceof String && right instanceof String) {
                    titleLeft = new LocaleString((String)left);
                    titleRight = new LocaleString((String)right);
                } else {
                    titleLeft = LocaleString.fromMap((Map)((Map)left));
                    titleRight = LocaleString.fromMap((Map)((Map)right));
                }
                this.getModel().setValue(TITLE_LIFT, (Object)titleLeft);
                this.getModel().setValue(TITLE_RIGHT, (Object)titleRight);
            }
        }
    }
}

