/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class TreeSelectToList
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String FIELD_TREE = "FieldTree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String NUMBER = "number";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndelete", "btndelnode"});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map fieldTree = (Map)this.getView().getFormShowParameter().getCustomParam("treeinfos");
        if (fieldTree == null || fieldTree.isEmpty()) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        TreeNode root = TreeNode.Parse((String)"", (Map)fieldTree, (String)"Id", (String)"Name", (String)"Items");
        tree.addNode(root);
        root.setIsOpened(true);
        Object entryinfos = this.getView().getFormShowParameter().getCustomParams().get("entryinfos");
        if (entryinfos == null || StringUtils.isBlank(entryinfos)) {
            entryinfos = new ArrayList();
        }
        List refProps = (List)entryinfos;
        ArrayList<String> checkNodeIds = new ArrayList<String>();
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        for (String refprop : refProps) {
            if (refprop == null) continue;
            checkNodeIds.add(refprop);
            checkNodes.add(root.getTreeNode(refprop, 16));
        }
        tree.checkNodes(checkNodes);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        for (String refProp : refProps) {
            TreeNode node = root.getTreeNode(refProp, 16);
            if (node == null) continue;
            int rowindex = model.createNewEntryRow(ENTRY_ENTITY);
            model.setValue("name", (Object)node.getText(), rowindex);
            model.setValue(NUMBER, (Object)node.getId(), rowindex);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (ENTRY_ENTITY.equals(source.getKey())) {
            this.delete();
        }
    }

    public void click(EventObject evt) {
        TreeView tree;
        List selNodes;
        String key = ((Control)evt.getSource()).getKey();
        if ("btndelete".equals(key)) {
            this.delete();
        } else if ("btnok".equals(key)) {
            this.returnData();
        } else if ("btndelnode".equals(key) && (selNodes = (tree = (TreeView)this.getView().getControl(FIELD_TREE)).getTreeState().getCheckedNodeIds()) != null && !selNodes.isEmpty()) {
            tree.deleteNodes(selNodes);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        ArrayList currChecks = new ArrayList(tree.getTreeState().getCheckedNodeIds());
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        IDataModel model = this.getModel();
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null || node.getChildren() != null) continue;
                    int row = model.createNewEntryRow(ENTRY_ENTITY);
                    model.setValue(NUMBER, (Object)node.getId(), row);
                    model.setValue("name", (Object)node.getText(), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            int[] rows = new int[checkNodes.size()];
            int j = 0;
            for (int i = model.getEntryRowCount(ENTRY_ENTITY) - 1; i >= 0; --i) {
                if (!checkNodes.contains(model.getValue(NUMBER, i))) continue;
                rows[j++] = i;
            }
            model.deleteEntryRows(ENTRY_ENTITY, rows);
        }
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    protected void returnData() {
        ArrayList<String> fieldList = new ArrayList<String>();
        DynamicObjectCollection lstItem = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (DynamicObject dyItem : lstItem) {
            String number = dyItem.get(NUMBER).toString();
            fieldList.add(number);
        }
        this.getView().returnDataToParent(fieldList);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"TreeSelectToList_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue(NUMBER, row));
        }
        model.deleteEntryRows(ENTRY_ENTITY, rows);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.uncheckNodes(nodeIds);
    }
}

