/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class UserGuideFormSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "formlist";
    private static final String BTN_OK = "btnok";
    private static final String RESET = "reset";
    private static final String NUMBER = "number";
    private static final String VALUE = "value";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, RESET});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        List formList;
        super.afterCreateNewData(evt);
        List context = (List)this.getView().getFormShowParameter().getCustomParam("context");
        String formType = "";
        String modelType = "";
        if (context == null || context.isEmpty()) {
            return;
        }
        formType = (String)((Map)context.get(0)).get("_Type_");
        modelType = formType.startsWith("Mobile") || formType.equals("BillEntity") || formType.equals("BaseEntity") ? "MobUserGuideFormModel" : "UserGuideFormModel";
        String sql = "select a.FID, b.FNumber,a.FNAME, b.FMODELTYPE,b.FEntityId,b.FInheritPath from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID and b.FMODELTYPE ='" + modelType + "' and a.FLOCALEID='" + RequestContext.get().getLang().getLocale().toString() + "'";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        map.put(UserGuideFormSelectPlugin.NUMBER, rs.getString(2));
                        map.put("name", rs.getString(3));
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (!formList.isEmpty()) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(ENTRY_KEY);
            if (formList.size() - count > 0) {
                String selectGuide = (String)this.getView().getFormShowParameter().getCustomParam(VALUE);
                model.batchCreateNewEntryRow(ENTRY_KEY, formList.size() - count);
                int i = 0;
                for (Map form : formList) {
                    Object number = form.get(NUMBER);
                    if (String.valueOf(number).equals(selectGuide)) {
                        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
                        entryGrid.selectRows(i);
                    }
                    model.setValue("id", form.get("id"), i);
                    model.setValue(NUMBER, number, i);
                    model.setValue("name", form.get("name"), i);
                    ++i;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnData(key);
        } else if (RESET.equalsIgnoreCase(key)) {
            this.returnData(key);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void returnData(String operationKey) {
        HashMap<String, Object> para;
        block4: {
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
            int row = grid.getEntryState().getFocusRow();
            para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            if (BTN_OK.equals(operationKey)) {
                if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && row >= 0) {
                    para.put(VALUE, this.getModel().getValue(NUMBER, row));
                    break block4;
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"UserGuideFormSelectPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (RESET.equals(operationKey)) {
                para.put(VALUE, null);
            }
        }
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnData(BTN_OK);
    }
}

