/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.entity.validation.AbstractValidationParamPlugin;
import kd.bos.metadata.entity.validation.CustValidation;
import kd.bos.metadata.entity.validation.MustInputValidation;
import kd.bos.metadata.entity.validation.PreCondition;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;

public class ValidRuleEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String KEY_TYPE = "ftype";
    private static final String KEY_PRE_CONDITION = "fprecondition";
    private static final String KEY_PRE_CONDITION_DESC = "fpreconditiondesc";
    private static final String KEY_ERROR_LEVEL = "fvalidlevel";
    private static final String KEY_OK = "btnok";
    private static final String KEY_CLEAR_PRE_COND = "btnclearprecond";
    private static final String F_TYPE = "FType";
    private static final String F_DESC = "FDesc";
    private static final String META_CONTEXT = "MetaContext";
    private static final String VALID_TYPE_PAGE_ID = "ValidType_PageId";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_OK, KEY_CLEAR_PRE_COND});
        this.addClickListeners(new String[]{KEY_TYPE, KEY_PRE_CONDITION, KEY_PRE_CONDITION_DESC});
    }

    public void afterCreateNewData(EventObject arg0) {
        Map rule;
        Object ruleObj;
        String isLock = (String)this.getView().getFormShowParameter().getCustomParam("isLock");
        if ("true".equals(isLock)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_OK});
        }
        if ((ruleObj = this.getView().getFormShowParameter().getCustomParam("Rule")) != null && (rule = (Map)SerializationUtils.fromJsonString((String)ruleObj.toString(), Map.class)) != null) {
            IDataModel model = this.getModel();
            String ruleType = (String)rule.get("RuleType");
            this.showValidateOption(ruleType, rule);
            model.setValue(F_TYPE, (Object)ruleType);
            model.setValue(F_DESC, rule.get("Description"));
            Object preCondition = rule.get("PreCondition");
            if (preCondition == null) {
                model.setValue(KEY_PRE_CONDITION, (Object)"");
                model.setValue(KEY_PRE_CONDITION_DESC, (Object)"");
            } else {
                Map preCondMap = (Map)preCondition;
                model.setValue(KEY_PRE_CONDITION, (Object)SerializationUtils.toJsonString(preCondition));
                model.setValue(KEY_PRE_CONDITION_DESC, preCondMap.get("RuleDescription"));
            }
            Object errorLevel = rule.get("LevelId");
            model.setValue("FValidLevel", (Object)(errorLevel == null ? "0" : String.valueOf(errorLevel)));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_TYPE});
        }
    }

    public void click(EventObject evt) {
        String key;
        IDataModel model = this.getModel();
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ftype": {
                FormShowParameter showValidTypePara = new FormShowParameter();
                showValidTypePara.getOpenStyle().setShowType(ShowType.Modal);
                showValidTypePara.setFormId("ide_validruletype");
                showValidTypePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectValidType"));
                showValidTypePara.setCustomParam("op", this.getView().getFormShowParameter().getCustomParams().get("op"));
                this.getView().showForm(showValidTypePara);
                break;
            }
            case "fprecondition": 
            case "fpreconditiondesc": {
                FormShowParameter showPreConditionPara = new FormShowParameter();
                showPreConditionPara.getOpenStyle().setShowType(ShowType.Modal);
                showPreConditionPara.setFormId("ide_preconditiondesign");
                List context = (List)this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT);
                showPreConditionPara.setCustomParam("context", (Object)context);
                Object preCondition = model.getValue("FPreCondition");
                showPreConditionPara.setCustomParam("value", StringUtils.isNotBlank((Object)preCondition) ? SerializationUtils.fromJsonString((String)((String)preCondition), Map.class) : new HashMap());
                showPreConditionPara.setCustomParam("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
                showPreConditionPara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setPreCondition"));
                this.getView().showForm(showPreConditionPara);
                break;
            }
            case "btnclearprecond": {
                model.setValue(KEY_PRE_CONDITION, (Object)"");
                model.setValue(KEY_PRE_CONDITION_DESC, (Object)"");
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void returnData() {
        AbstractValidationParamPlugin<?> validateOptPlug;
        String forbidMsg = this.getView().getPageCache().get("ForBiddenSavedMsg");
        if (StringUtils.isNotBlank((CharSequence)forbidMsg)) {
            this.getView().showErrorNotification(forbidMsg);
            return;
        }
        Object validation = null;
        IDataModel model = this.getModel();
        String validType = (String)model.getValue(F_TYPE);
        if (StringUtils.isBlank((CharSequence)validType)) {
            this.getView().close();
            return;
        }
        String validLevel = (String)model.getValue(KEY_ERROR_LEVEL);
        if ("MustInput".equals(validType) && "1".equals(validLevel)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6821\u9a8c\u7ea7\u522b\u201d\u3002", (String)"ValidRuleEditPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        String pageId = this.getPageCache().get(VALID_TYPE_PAGE_ID);
        IFormView optFormView = null;
        if (pageId != null) {
            optFormView = this.getView().getView(pageId);
        }
        if ((validateOptPlug = this.getValidateOptPlug(optFormView)) != null) {
            StringBuilder sBuilder = new StringBuilder();
            if (!validateOptPlug.checkValidation(sBuilder)) {
                this.getView().showTipNotification(sBuilder.toString());
                return;
            }
            validation = validateOptPlug.getValidation();
        } else {
            validation = StringUtils.equals((CharSequence)validType, (CharSequence)"MustInput") ? new MustInputValidation() : new CustValidation();
        }
        if (validation != null) {
            Map rule;
            Object ruleObj = this.getView().getFormShowParameter().getCustomParam("Rule");
            if (ruleObj != null && (rule = (Map)SerializationUtils.fromJsonString((String)ruleObj.toString(), Map.class)) != null) {
                validation.setId(rule.get("Id"));
            }
            if (StringUtils.isBlank((CharSequence)validation.getId())) {
                validation.setId(Uuid16.create().toString());
            }
            validation.setRuleType(validType);
            validation.setDescription(new LocaleString(Lang.get().toString(), model.getValue(F_DESC)));
            String preCondition = (String)model.getValue("FPreCondition");
            ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
            dts.add(OrmUtils.getDataEntityType(PreCondition.class));
            validation.setPreCondition(StringUtils.isBlank((CharSequence)preCondition) ? null : (PreCondition)new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts)).deserializeFromString(preCondition, null));
            validation.setLevelId(model.getValue("FValidLevel"));
            this.getView().returnDataToParent(validation);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        IDataModel model = this.getModel();
        if ("selectValidType".equals(e.getActionId())) {
            Map rule = (Map)e.getReturnData();
            String ruleType = (String)rule.get("RuleType");
            model.setValue(F_TYPE, (Object)ruleType);
            model.setValue(F_DESC, rule.get("Name"));
            this.showValidateOption(ruleType, null);
        } else if ("setPreCondition".equals(e.getActionId())) {
            Map precondition = (Map)e.getReturnData();
            model.setValue(KEY_PRE_CONDITION, (Object)SerializationUtils.toJsonString((Object)precondition));
            model.setValue(KEY_PRE_CONDITION_DESC, precondition.get("RuleDescription"));
        }
    }

    private void showValidateOption(Object ruleType, Map<String, Object> parameter) {
        String pageId;
        String formid = null;
        ValidationType validationType = this.geValidationType(ruleType.toString());
        if (validationType != null) {
            formid = validationType.getSettingFormId();
            this.setErrLevelItems(validationType.getErrorLevel());
            if (parameter != null) {
                Object classType = parameter.get("_Type_");
                Object ruleIdType = parameter.get("RuleType");
                if (StringUtils.equals((CharSequence)String.valueOf(classType), (CharSequence)CustValidation.class.getSimpleName()) && StringUtils.equals((CharSequence)String.valueOf(ruleIdType), (CharSequence)"MustInput")) {
                    formid = null;
                    String forbidMsg = ResManager.loadKDString((String)"\u5408\u89c4\u6027\u6821\u9a8c\u5668\u53c2\u6570\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u663e\u793a\u914d\u7f6e\u8be6\u60c5\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u6dfb\u52a0\u6821\u9a8c\u5668\u3002", (String)"ValidRuleEditPlugin_2", (String)"bos-designer-plugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(forbidMsg);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_OK});
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().getPageCache().put("ForBiddenSavedMsg", forbidMsg);
                }
            }
        }
        if ((pageId = this.getPageCache().get(VALID_TYPE_PAGE_ID)) != null) {
            HashMap<String, String> arg = new HashMap<String, String>(2);
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(VALID_TYPE_PAGE_ID);
        }
        if (formid != null) {
            List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT);
            FormShowParameter paraSettings = new FormShowParameter();
            paraSettings.getOpenStyle().setShowType(ShowType.InContainer);
            paraSettings.getOpenStyle().setTargetKey("FValidPanel");
            paraSettings.setFormId(formid);
            paraSettings.setCustomParam(META_CONTEXT, (Object)formContext);
            paraSettings.setCustomParam("Parameter", parameter);
            this.getView().showForm(paraSettings);
            this.getPageCache().put(VALID_TYPE_PAGE_ID, paraSettings.getPageId());
        }
    }

    private void setErrLevelItems(String errorLevel) {
        IDataEntityProperty property = this.getModel().getDataEntityType().findProperty(KEY_ERROR_LEVEL);
        if (property instanceof ComboProp) {
            ComboProp errorLevelProp = (ComboProp)property;
            HashSet<String> levelItems = new HashSet<String>();
            if (StringUtils.isBlank((CharSequence)errorLevel)) {
                for (Object item : errorLevelProp.getComboItems()) {
                    levelItems.add(item.getValue());
                }
            } else {
                ValueMapItem arr = StringUtils.split((String)errorLevel, (String)",");
                for (ValueMapItem item : arr) {
                    if (!StringUtils.isNotBlank((CharSequence)item)) continue;
                    levelItems.add((String)item);
                }
            }
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            for (ValueMapItem item : errorLevelProp.getComboItems()) {
                if (!levelItems.contains(item.getValue())) continue;
                ComboItem comboItem = new ComboItem(item.getName(), item.getValue(), item.getImageKey());
                comboItems.add(comboItem);
            }
            ComboEdit editor = (ComboEdit)this.getView().getControl(KEY_ERROR_LEVEL);
            editor.setComboItems(comboItems);
        }
    }

    private AbstractValidationParamPlugin<?> getValidateOptPlug(IFormView view) {
        if (view == null) {
            return null;
        }
        FormViewPluginProxy proxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        if (proxy != null) {
            for (IFormPlugin plugin : proxy.getPlugIns()) {
                if (!(plugin instanceof AbstractValidationParamPlugin)) continue;
                return (AbstractValidationParamPlugin)plugin;
            }
        }
        return null;
    }

    private ValidationType geValidationType(String ruleTypeId) {
        ValidationTypes types = ValidationTypeLoader.load();
        for (ValidationType type : types.getTypes()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ruleTypeId, (CharSequence)type.getId())) continue;
            return type;
        }
        return null;
    }
}

