/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.CultureInfoUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.validation.Validation;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class ValidRulesPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "EntryEntity";
    private static final String BTN_OK = "btnok";
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String F_RULE = "FRule";
    private static final String IDE_VALID_RULE_EDIT = "ide_validruleedit";
    private static final String META_TYPE = "metaType";
    private static final String META_CONTEXT = "MetaContext";
    private static final String NEW_VALID_RULE = "newValidRule";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String EDIT_VALID_RULE = "editValidRule";
    private static final String[] ITEMS = new String[]{"btnedit", "btndel", "btnmoveup", "btnmovedown"};
    private static final String[] ALL_ITEMS = new String[]{"btnadd", "btnedit", "btndel", "btnmoveup", "btnmovedown"};
    private static final String ENTRY_IS_INHERIT = "isinherit";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, BTN_ADD, BTN_EDIT, BTN_DEL});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject arg0) {
        String lockType = this.getValidRulesExtensible();
        if ("lock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, ALL_ITEMS);
        } else if ("speciallock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, ITEMS);
        }
        Object rulesObj = this.getView().getFormShowParameter().getCustomParam("Rules");
        if (StringUtils.isNotBlank((Object)rulesObj)) {
            List isvList = DesignerUtils.ISV_LIST;
            List rules = SerializationUtils.fromJsonStringToList((String)rulesObj.toString(), Map.class);
            if (rules.size() > 0) {
                IDataModel model = this.getModel();
                for (Map rule : rules) {
                    int rowKey = this.getModel().createNewEntryRow(ENTRY_KEY);
                    model.setValue("FEnabled", (Object)Boolean.TRUE.equals(rule.get("Enabled")), rowKey);
                    model.setValue("FDesc", rule.get("Description"), rowKey);
                    model.setValue(F_RULE, (Object)SerializationUtils.toJsonString((Object)rule), rowKey);
                    DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
                    boolean hasIsInheritProp = doc.getDynamicObjectType().getProperties().containsKey((Object)ENTRY_IS_INHERIT);
                    if (!hasIsInheritProp) continue;
                    Object obj = rule.get("IsvFlag");
                    if (obj != null) {
                        String ruleIsv = String.valueOf(obj);
                        String billIsv = (String)this.getView().getFormShowParameter().getCustomParam("billIsv");
                        boolean inherit = isvList.contains(ruleIsv) && !StringUtils.equals((CharSequence)ruleIsv, (CharSequence)billIsv);
                        model.setValue(ENTRY_IS_INHERIT, (Object)inherit, rowKey);
                        if (!inherit || !"lock".equals(lockType) && !"speciallock".equals(lockType)) continue;
                        this.getView().setEnable(Boolean.FALSE, rowKey, new String[]{"fenabled"});
                        continue;
                    }
                    model.setValue(ENTRY_IS_INHERIT, (Object)false, rowKey);
                }
            }
        }
    }

    private String getValidRulesExtensible() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        String opId = (String)this.getView().getFormShowParameter().getCustomParam("opId");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return "";
        }
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((String)entityId, (String)"Operation", (String)modelType, (String)opId, (String)"validation");
        return lockType.toString();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        switch (key) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "btnadd": {
                FormShowParameter addValidRulePara = new FormShowParameter();
                addValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
                addValidRulePara.setFormId(IDE_VALID_RULE_EDIT);
                addValidRulePara.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                addValidRulePara.setCustomParam(META_CONTEXT, this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT));
                addValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEW_VALID_RULE));
                this.getView().showForm(addValidRulePara);
                break;
            }
            case "btnedit": {
                FormShowParameter editValidRulePara = new FormShowParameter();
                editValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
                editValidRulePara.setFormId(IDE_VALID_RULE_EDIT);
                if (rowKey <= -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ValidRulesPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (rowKey >= 0) {
                    editValidRulePara.setCustomParam("Rule", this.getModel().getValue(F_RULE, rowKey));
                }
                editValidRulePara.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                editValidRulePara.setCustomParam(META_CONTEXT, this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT));
                editValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_VALID_RULE));
                this.getView().showForm(editValidRulePara);
                break;
            }
            case "btndel": {
                if (rowKey >= 0) {
                    this.getModel().deleteEntryRow(ENTRY_KEY, rowKey);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ValidRulesPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Validation rule = (Validation)e.getReturnData();
        IDataModel model = this.getModel();
        int rowKey = -1;
        if (NEW_VALID_RULE.equals(e.getActionId())) {
            rowKey = model.createNewEntryRow(ENTRY_KEY);
        } else if (EDIT_VALID_RULE.equals(e.getActionId())) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
            rowKey = grid.getEntryState().getFocusRow();
        }
        if (rowKey >= 0) {
            model.setValue("FDesc", rule.getDescription().getItem(CultureInfoUtils.getDefaultLCId()), rowKey);
            model.setValue(ENTRY_IS_INHERIT, (Object)false, rowKey);
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, new ArrayList()));
            model.setValue(F_RULE, (Object)dcJsonSerializer.serializeToString((Object)rule, null), rowKey);
        }
    }

    private void returnData() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRY_KEY);
        ArrayList<Map> validRules = new ArrayList<Map>();
        for (DynamicObject row : rows) {
            Map rule = (Map)SerializationUtils.fromJsonString((String)((String)row.get(F_RULE)), Map.class);
            rule.put("Enabled", row.get("FEnabled"));
            rule.put("Inherit", row.get(ENTRY_IS_INHERIT));
            validRules.add(rule);
        }
        this.getView().returnDataToParent(validRules);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent arg0) {
        if (arg0.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), ALL_ITEMS);
        int index = arg0.getRow();
        this.setItemsEnable(index);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("moveentryup".equals(e.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
            int[] selectRows = entryGrid.getSelectRows();
            int currentRow = selectRows[0];
            Object extensible = this.getModel().getValue(ENTRY_IS_INHERIT, currentRow - 1);
            boolean b = extensible != null && (Boolean)extensible != false;
            String lockType = this.getValidRulesExtensible();
            if (b && ("lock".equals(lockType) || "speciallock".equals(lockType))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnmoveup"});
            }
        } else if ("moveentrydown".equals(e.getOperateKey())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnmoveup"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 0) {
            int index = selectRows[0];
            this.setItemsEnable(index);
        }
    }

    private void setItemsEnable(int index) {
        Object extensible;
        boolean b;
        Object value = this.getModel().getValue(ENTRY_IS_INHERIT, index);
        boolean a = value != null && (Boolean)value != false;
        String lockType = this.getValidRulesExtensible();
        if (a) {
            if ("lock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), ALL_ITEMS);
            } else if ("speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), ITEMS);
            }
        }
        boolean bl = b = (extensible = this.getModel().getValue(ENTRY_IS_INHERIT, index - 1)) != null && (Boolean)extensible != false;
        if (b && ("lock".equals(lockType) || "speciallock".equals(lockType))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnmoveup"});
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.editValidRule();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "btnadd": {
                FormShowParameter addValidRulePara = new FormShowParameter();
                addValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
                addValidRulePara.setFormId(IDE_VALID_RULE_EDIT);
                addValidRulePara.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                addValidRulePara.setCustomParam(META_CONTEXT, this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT));
                addValidRulePara.setCustomParam("op", this.getView().getFormShowParameter().getCustomParams().get("op"));
                addValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEW_VALID_RULE));
                this.getView().showForm(addValidRulePara);
                break;
            }
            case "btnedit": {
                this.editValidRule();
                break;
            }
            case "btndel": {
                this.deleteValidRule();
                break;
            }
        }
    }

    private void deleteValidRule() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        int count = this.getModel().getEntryRowCount(ENTRY_KEY);
        if (rowKey >= 0 && count > 0) {
            this.getModel().deleteEntryRow(ENTRY_KEY, rowKey);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ValidRulesPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void editValidRule() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ValidRulesPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), ALL_ITEMS);
        boolean value = (Boolean)this.getModel().getValue(ENTRY_IS_INHERIT, rowKey);
        String lockType = this.getValidRulesExtensible();
        String isLock = "false";
        if (value) {
            if ("speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), ITEMS);
                isLock = "true";
            } else if ("lock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), ALL_ITEMS);
                isLock = "true";
            }
        }
        FormShowParameter editValidRulePara = new FormShowParameter();
        editValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
        editValidRulePara.setFormId(IDE_VALID_RULE_EDIT);
        if (rowKey <= -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ValidRulesPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (rowKey >= 0) {
            editValidRulePara.setCustomParam("Rule", this.getModel().getValue(F_RULE, rowKey));
        }
        editValidRulePara.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        editValidRulePara.setCustomParam(META_CONTEXT, this.getView().getFormShowParameter().getCustomParams().get(META_CONTEXT));
        editValidRulePara.setCustomParam("isLock", (Object)isLock);
        editValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_VALID_RULE));
        this.getView().showForm(editValidRulePara);
    }
}

