/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.operation.OperationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationType;
import kd.bos.metadata.entity.validation.ValidationTypeLoader;
import kd.bos.metadata.entity.validation.ValidationTypes;

public class ValidTypePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "EntryEntity";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject arg0) {
        block7: {
            ValidationTypes types;
            String appNumber = (String)this.getView().getFormShowParameter().getCustomParam("appnumber");
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
            String opType = (String)this.getView().getFormShowParameter().getCustomParam("optype");
            JSONObject op = (JSONObject)this.getView().getFormShowParameter().getCustomParam("op");
            String operationType = "";
            if (op != null) {
                operationType = (String)op.get((Object)"OperationType");
            }
            boolean formValidate = false;
            if (!StringUtils.isEmpty((Object)operationType)) {
                OperationTypes opTypes = OperationTypeLoader.loadAll();
                for (OperationType oType : opTypes.getOpTypes()) {
                    if (!operationType.equalsIgnoreCase(oType.getId())) continue;
                    formValidate = oType.isFormValidate();
                }
            }
            if ((types = ValidationTypeLoader.load((String)appNumber, (String)entityNumber, (String)opType)).getTypes().isEmpty()) break block7;
            IDataModel model = this.getModel();
            if (!formValidate) {
                model.batchCreateNewEntryRow(ENTRY_KEY, types.getTypes().size());
                int i = 0;
                for (ValidationType type : types.getTypes()) {
                    model.setValue("FRuleType", (Object)type.getId(), i);
                    model.setValue("FName", (Object)type.getName(), i);
                    model.setValue("desc", (Object)type.getDesc(), i);
                    ++i;
                }
            } else {
                int row = 0;
                for (ValidationType type : types.getTypes()) {
                    if (!type.isApplyForm()) continue;
                    model.batchCreateNewEntryRow(ENTRY_KEY, 1);
                    model.setValue("FRuleType", (Object)type.getId(), row);
                    model.setValue("FName", (Object)type.getName(), row);
                    model.setValue("desc", (Object)type.getDesc(), row);
                    ++row;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnData();
        }
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey >= 0) {
            HashMap<String, Object> rule = new HashMap<String, Object>();
            IDataModel model = this.getModel();
            rule.put("RuleType", model.getValue("FRuleType", rowKey));
            rule.put("Name", model.getValue("FName", rowKey));
            this.getView().returnDataToParent(rule);
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        if (ENTRY_KEY.equalsIgnoreCase(((Control)evt.getSource()).getKey())) {
            this.returnData();
        }
    }
}

