/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class WidgetSelectorPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String ENTRY_KEY = "EntryEntity";
    private static final String NUMBER = "number";
    private static final String ENTITY_ID = "entityid";

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.closeAndReturn();
        }
    }

    private void closeAndReturn() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            String widgetId = (String)this.getModel().getValue(NUMBER, rowIndex);
            HashMap para = new HashMap();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", widgetId);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject evt) {
        List widgetList;
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN")};
        String sql = "select b.FNumber,a.FNAME,b.FEntityId from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID where b.FMODELTYPE='WidgetFormModel' AND FLOCALEID = ?";
        try {
            widgetList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(WidgetSelectorPlugin.NUMBER, rs.getString(1));
                        map.put("name", rs.getString(2));
                        map.put(WidgetSelectorPlugin.ENTITY_ID, rs.getString(3));
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (widgetList != null && !widgetList.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRY_KEY, widgetList.size());
            int i = 0;
            for (Map form : widgetList) {
                model.setValue(NUMBER, form.get(NUMBER), i);
                model.setValue("name", form.get("name"), i);
                model.setValue(ENTITY_ID, form.get(ENTITY_ID), i++);
            }
        }
    }
}

