/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ApproverListColumnAp;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.DynamicTextListColumnAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListOperationColumnAp;
import kd.bos.metadata.list.MergeListColumnAp;
import kd.bos.metadata.list.VoucherNoListColumnAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.mservice.svc.picture.IPictureListColumnAp;
import kd.bos.util.StringUtils;

final class AliasConverterHelper {
    private static final String GRIDVIEW = "gridview";
    private static final String FSEQ = "fseq";

    AliasConverterHelper() {
    }

    static List<ControlAp<?>> getBillListColumnAps(List<Map<String, Object>> context, String billistapid) {
        FormMetadata formMetadata = FormTreeBuilder.deserialzeFormMetadata(context);
        formMetadata.createIndex();
        String gridviewId = null;
        if (StringUtils.isBlank((String)billistapid)) {
            gridviewId = formMetadata.getItem(GRIDVIEW) != null ? formMetadata.getItem(GRIDVIEW).getId() : "";
        } else {
            ControlAp item = formMetadata.getItem(billistapid);
            if (item instanceof BillListAp) {
                gridviewId = ((ControlAp)((BillListAp)item).getItems().get(0)).getId();
            }
        }
        ArrayList billListColumnAps = new ArrayList();
        for (ControlAp item : formMetadata.getItems()) {
            if (!item.getParentId().equals(gridviewId)) continue;
            billListColumnAps.add(item);
        }
        return billListColumnAps;
    }

    static Map<String, String> getBillListColumnApNameMap(List<Map<String, Object>> context, String billlistapid) {
        ArrayList listcolumns = new ArrayList();
        List<ControlAp<?>> billListColumnAps = AliasConverterHelper.getBillListColumnAps(context, billlistapid);
        for (ControlAp<?> billListColumnAp : billListColumnAps) {
            AliasConverterHelper.traverseGetSubControlAp(billListColumnAp, listcolumns);
        }
        HashMap<String, String> billListColumnApNameMap = new HashMap<String, String>(listcolumns.size());
        for (ControlAp controlAp : listcolumns) {
            if (!(controlAp instanceof ListColumnAp)) continue;
            billListColumnApNameMap.put(((ListColumnAp)controlAp).getListFieldId(), controlAp.getName().getLocaleValue());
        }
        return billListColumnApNameMap;
    }

    private static void traverseGetSubControlAp(ControlAp<?> ap, List<ControlAp<?>> listcolumns) {
        if (ap instanceof ContainerAp) {
            List subControlAps = ((ContainerAp)ap).getItems();
            for (ControlAp subControlAp : subControlAps) {
                if (AliasConverterHelper.isListColumn(subControlAp)) continue;
                if (subControlAp instanceof MergeListColumnAp || subControlAp instanceof ListColumnGroupAp) {
                    AliasConverterHelper.traverseGetSubControlAp(subControlAp, listcolumns);
                    continue;
                }
                AliasConverterHelper.getListColumnAp(listcolumns, subControlAp);
            }
        } else {
            AliasConverterHelper.getListColumnAp(listcolumns, ap);
        }
    }

    private static void getListColumnAp(List<ControlAp<?>> listcolumns, ControlAp<?> subControlAp) {
        if (subControlAp instanceof ListColumnAp && !FSEQ.equals(((ListColumnAp)subControlAp).getListFieldId())) {
            listcolumns.removeIf(item -> ((ListColumnAp)subControlAp).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            listcolumns.add(subControlAp);
        }
    }

    private static boolean isListColumn(ControlAp<?> ap) {
        return ap instanceof IPictureListColumnAp || ap instanceof DynamicTextListColumnAp || ap instanceof ListOperationColumnAp || ap instanceof VoucherNoListColumnAp || ap instanceof ApproverListColumnAp;
    }
}

