/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.AbstractPropertyConverter;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.utils.DbTypeConverter;

public class DefValueConverter
extends AbstractPropertyConverter {
    private static final Log log = LogFactory.getLog(DefValueConverter.class);
    private static final String DEF_VALUE_DESIGN = "DefValueDesign";
    static Map<String, Map<String, String>> dateAlias = new HashMap<String, Map<String, String>>();
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    static final Set<String> baseDataTypes;
    static final Map<String, String> functionTypes;

    @Override
    public Object convert(Object value) {
        String queryName;
        if (StringUtils.isNotBlank((Object)value) && StringUtils.isNotBlank((CharSequence)(queryName = this.queryName(value)))) {
            return queryName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String queryName(Object value) {
        String name = "";
        if (!(this.context instanceof List)) return name;
        List ctx = (List)this.context;
        if (ctx.isEmpty()) return name;
        if (ctx.get(0) instanceof List && (ctx = (List)ctx.get(0)).isEmpty()) {
            return name;
        }
        String type = (String)((Map)ctx.get(0)).get("_Type_");
        if (this.isBaseDataType(type)) {
            Map defValueDesign = (Map)((Map)ctx.get(0)).get(DEF_VALUE_DESIGN);
            if (defValueDesign == null) return name;
            String param = (String)defValueDesign.get("FuncParameter");
            if (param == null) {
                return name;
            }
            if (functionTypes.containsKey(param)) {
                return functionTypes.get(param);
            }
            try {
                Map defValueItem = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
                Object nameObject = defValueItem.get("name");
                if (nameObject instanceof Map) {
                    LocaleString localName = LocaleString.fromMap((Map)((Map)nameObject));
                    return localName.getLocaleValue();
                }
                name = (String)defValueItem.get("name");
                String baseEntityId = (String)((Map)ctx.get(0)).get("BaseEntityId");
                Object id = defValueItem.get("id");
                if (id == null) return name;
                if (!StringUtils.isNotBlank((CharSequence)baseEntityId)) return name;
                String entityNumber = MetadataDao.getEntityNumberById((String)baseEntityId);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (!(mainEntityType instanceof BasedataEntityType)) return name;
                BasedataEntityType entityType = (BasedataEntityType)mainEntityType;
                String nameProperty = entityType.getNameProperty();
                if (!StringUtils.isNotEmpty((CharSequence)nameProperty)) return name;
                if (entityType.getProperty(nameProperty) == null) return name;
                QFilter idFilter = new QFilter(entityType.getPrimaryKey().getName(), "=", DbTypeConverter.safeConvert((int)entityType.getPrimaryKey().getDbType(), id));
                Map data = BusinessDataReader.loadFromCache((String)entityNumber, (String)nameProperty, (QFilter[])new QFilter[]{idFilter});
                if (data == null) return name;
                if (data.isEmpty()) return name;
                Iterator iterator = data.values().iterator();
                while (iterator.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)iterator.next();
                    name = dynamicObject.getString(nameProperty);
                }
                return name;
            }
            catch (KDException e) {
                log.info(e.getMessage());
                return name;
            }
        } else {
            if (!type.equals("DateField")) {
                if (!type.equals("DateTimeField")) return name;
            }
            if (!(((Map)ctx.get(0)).get(DEF_VALUE_DESIGN) instanceof Map)) return name;
            Map defValueDesign = (Map)((Map)ctx.get(0)).get(DEF_VALUE_DESIGN);
            if (!StringUtils.isNotBlank((CharSequence)dateAlias.get(type).get(defValueDesign.get("FuncType")))) return "";
            String string = dateAlias.get(type).get(defValueDesign.get("FuncType"));
            return string;
        }
    }

    private boolean isBaseDataType(String type) {
        return baseDataTypes.contains(type);
    }

    static {
        HashMap<String, String> dateFieldAlias = new HashMap<String, String>();
        dateFieldAlias.put("getToday", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u7528\u6237\u65f6\u533a", (String)"DefValueConverter_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateFieldAlias.put("toDate", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u6307\u5b9a\u65f6\u533a", (String)"DefValueConverter_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateFieldAlias.put("getTodaySysTZ", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u670d\u52a1\u5668\u65f6\u533a", (String)"DefValueConverter_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateFieldAlias.put("getTodayOrgTZ", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u7ec4\u7ec7\u65f6\u533a", (String)"DefValueConverter_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        HashMap<String, String> dateTimeAlias = new HashMap<String, String>();
        dateTimeAlias.put("toDate", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u6307\u5b9a\u65e5\u671f", (String)"DefaultValueEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateTimeAlias.put("getNow", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u65f6\u95f4", (String)"DefValueConverter_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateTimeAlias.put("getNow", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u548c\u65f6\u95f4", (String)"DefValueConverter_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateTimeAlias.put("getNowUserTZ", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u65f6\u95f4-\u7528\u6237\u65f6\u533a", (String)"DefValueConverter_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateTimeAlias.put("getNowOrgTZ", ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u65f6\u95f4-\u7ec4\u7ec7\u65f6\u533a", (String)"DefValueConverter_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        dateAlias.put("DateField", dateFieldAlias);
        dateAlias.put("DateTimeField", dateTimeAlias);
        baseDataTypes = new HashSet<String>(){
            {
                this.add("BasedataField");
                this.add("MaterielField");
                this.add("CurrencyField");
                this.add("CityField");
                this.add("GroupField");
                this.add("UnitField");
                this.add("OrgField");
                this.add("UserField");
                this.add("AssistantField");
            }
        };
        functionTypes = new HashMap<String, String>(){
            {
                this.put("#CurrentOrg#", ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7", (String)"DefValueConverter_4", (String)DefValueConverter.BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                this.put("#CurrentCity#", ResManager.loadKDString((String)"\u5f53\u524d\u57ce\u5e02", (String)"DefValueConverter_5", (String)DefValueConverter.BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                this.put("#CurrentUser#", ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237", (String)"DefValueConverter_6", (String)DefValueConverter.BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        };
    }
}

