/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.AbstractPropertyConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.OrgServiceHelper;

public class OrgRelationPropertyConverter
extends AbstractPropertyConverter {
    private static final Log log = LogFactory.getLog(OrgRelationPropertyConverter.class);

    @Override
    public Object convert(Object value) {
        if (value == null || !(value instanceof List) && !((ArrayList)value).isEmpty() || ((ArrayList)value).size() < 1) {
            return null;
        }
        List list = (List)value;
        StringBuilder alias = new StringBuilder();
        Map item = (Map)list.get(list.size() - 1);
        try {
            if (item.get("Type") != null) {
                String typeName = this.getRelationItemTypeName(String.valueOf(((Map)item.get("Type")).get("Number")));
                alias.append(alias.length() == 0 ? alias.toString() : ";").append(typeName);
            }
            if (item.get("Direct") != null) {
                String directName = this.getDirectDisplayName(String.valueOf(((Map)item.get("Direct")).get("Index")));
                alias.append(alias.length() == 0 ? alias.toString() : ";").append(directName);
            }
            if (item.get("Org") != null) {
                String name = this.getFieldsNameMapping().get(String.valueOf(((Map)item.get("Org")).get("Number")));
                alias.append(alias.length() == 0 ? alias.toString() : ";").append(name);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return alias.toString();
    }

    private String getRelationItemTypeName(String typeNumber) {
        if (typeNumber == null) {
            return "";
        }
        List allType = OrgServiceHelper.getAllOrgRelationType();
        for (Map it : allType) {
            if (!StringUtils.equals((CharSequence)typeNumber, (CharSequence)it.getOrDefault("number", ""))) continue;
            return it.getOrDefault("name", "");
        }
        return typeNumber;
    }

    private Map<String, String> getFieldsNameMapping() {
        if (this.context == null) {
            return new HashMap<String, String>();
        }
        if (this.context instanceof List) {
            List infos = (List)this.context;
            if (infos.isEmpty()) {
                return new HashMap<String, String>(3);
            }
            HashMap<String, String> mapping = new HashMap<String, String>(10);
            List entityItems = (List)infos.get(0);
            for (Map item : entityItems) {
                mapping.put(item.getOrDefault("Key", "").toString(), item.getOrDefault("Name", "").toString());
            }
            return mapping;
        }
        return new HashMap<String, String>(3);
    }

    private String getDirectDisplayName(String type) {
        if ("toorg".equals(type)) {
            return ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u53d7\u6258\u65b9", (String)"OrgRelationPropertyConverter_1", (String)"bos-designer-plugin", (Object[])new Object[0]);
        }
        if ("fromorg".equals(type)) {
            return ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7\u662f\u59d4\u6258\u65b9", (String)"OrgRelationPropertyConverter_2", (String)"bos-designer-plugin", (Object[])new Object[0]);
        }
        return type;
    }
}

