/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.AbstractPropertyConverter;

public class PluginsConverter
extends AbstractPropertyConverter {
    private static final String ROW_KEY = "RowKey";
    String localeId = "zh_CN";
    private static final String KINGSCRIPT_SUFFIX = ".ts";

    @Override
    public Object convert(Object value) {
        if (!(value instanceof List) || ((List)value).isEmpty()) {
            return null;
        }
        List ops = (List)value;
        this.sortPlugins(ops);
        StringBuilder alias = new StringBuilder();
        for (Map op : ops) {
            String className;
            String string = className = op.get("ClassName") == null ? "" : op.get("ClassName").toString();
            if (className.endsWith(KINGSCRIPT_SUFFIX)) {
                alias.append(alias.length() == 0 ? alias.toString() : ",").append(className.substring(className.lastIndexOf("/") + 1));
                continue;
            }
            alias.append(alias.length() == 0 ? alias.toString() : ",").append(className.substring(className.lastIndexOf(".") + 1));
        }
        return alias.toString();
    }

    private void sortPlugins(List<Map<String, Object>> plugins) {
        Collections.sort(plugins, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Integer rowkey1 = 0;
                Integer rowkey2 = 0;
                if (StringUtils.isNotBlank((Object)o1.get(PluginsConverter.ROW_KEY))) {
                    rowkey1 = (Integer)o1.get(PluginsConverter.ROW_KEY);
                }
                if (StringUtils.isNotBlank((Object)o2.get(PluginsConverter.ROW_KEY))) {
                    rowkey2 = (Integer)o2.get(PluginsConverter.ROW_KEY);
                }
                return rowkey1.compareTo(rowkey2);
            }
        });
    }
}

