/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.AbstractPropertyConverter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mservice.svc.attach.IAttachmentPanelAp;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class PrintBindFieldConverter
extends AbstractPropertyConverter {
    private static final String DATA_SOURCE = "DataSource";

    @Override
    public Object convert(Object value) {
        String alias = null;
        if (value != null) {
            alias = this.getAliasFast(String.valueOf(value));
        }
        return alias;
    }

    private String getCurEntityId() {
        List items;
        String curEntityId = null;
        List context = (List)this.context;
        if (context != null && !context.isEmpty() && (items = (List)context.get(0)).get(0) != null) {
            curEntityId = (String)((Map)items.get(0)).get("EntityId");
        }
        return curEntityId;
    }

    private Map<String, Object> getDataSource() {
        Map<String, Object> mpDs = new HashMap<String, Object>();
        List context = (List)this.context;
        if (context != null && !context.isEmpty() && context.size() > 1) {
            List dataSource = (List)context.get(1);
            if (dataSource == null || dataSource.isEmpty() || context.size() == 3 && ((Map)((List)context.get(2)).get(0)).containsKey(DATA_SOURCE)) {
                dataSource = (List)context.get(2);
            }
            Map entityId = (Map)((List)context.get(0)).get(0);
            mpDs.putAll(entityId);
            if (dataSource != null && !dataSource.isEmpty() && dataSource.get(0) != null) {
                Object ds = ((Map)dataSource.get(0)).get(DATA_SOURCE);
                if (ds instanceof Map) {
                    mpDs = (Map)ds;
                } else {
                    try {
                        Map mapData = (Map)SerializationUtils.fromJsonString((String)((String)ds), Map.class);
                        mpDs = mapData;
                    }
                    catch (Exception e) {
                        mpDs.put("key", ds.toString());
                        if ("attachpanel".equals(ds)) {
                            mpDs.put("type", "10");
                        }
                        if (ds.toString().contains("workflow.approveline")) {
                            mpDs.put("type", "4");
                        }
                        if (ds.toString().contains("workflow.activity")) {
                            mpDs.put("type", "8");
                        }
                        mpDs.put("type", "1");
                    }
                }
            }
        }
        return mpDs;
    }

    private Map<String, Object> getCustomFields() {
        List context = (List)this.context;
        if (context != null && !context.isEmpty()) {
            List dataSource = (List)context.get(1);
            if (dataSource == null || dataSource.isEmpty() || context.size() == 3 && ((Map)((List)context.get(2)).get(0)).containsKey(DATA_SOURCE)) {
                dataSource = (List)context.get(2);
            }
            if (dataSource != null && !dataSource.isEmpty() && dataSource.get(0) != null) {
                Object ds = ((Map)dataSource.get(0)).get(DATA_SOURCE);
                HashMap<String, Object> mpds = new HashMap<String, String>();
                if (ds instanceof Map) {
                    mpds = (Map)ds;
                } else {
                    mpds.put("key", ds.toString());
                    mpds.put("type", "1");
                }
                return mpds;
            }
        }
        return null;
    }

    private String getAliasFromMap(Map<String, Object> tree, String key) {
        String alias = null;
        if (tree != null && !tree.isEmpty()) {
            if (key.equals(tree.get("Id"))) {
                return (String)tree.get("Name");
            }
            alias = this.getAliasFromList((List)tree.get("Items"), key);
        }
        return alias;
    }

    private String getAliasFromList(List<Object> items, String key) {
        if (items != null && !items.isEmpty()) {
            for (Map map : items) {
                String alias = this.getAliasFromMap(map, key);
                if (alias == null) continue;
                return alias;
            }
        }
        return null;
    }

    private String getAliasFast(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return "";
        }
        ArrayList<String> aliases = new ArrayList<String>();
        Map<String, Object> ds = this.getDataSource();
        if (ds.isEmpty()) {
            return "";
        }
        String dsKey = (String)ds.get("key");
        String dsType = (String)ds.get("type");
        String entityId = (String)ds.get("EntityId");
        if ("4".equals(dsType)) {
            Map fieldMap;
            String aliasName;
            if ("workflow.approveline".equals(dsKey) && StringUtils.isNotBlank((CharSequence)(aliasName = (String)(fieldMap = WorkflowServiceHelper.getApprovalRecordMeta()).get(key)))) {
                aliases.add(aliasName);
            }
        } else if ("8".equals(dsType)) {
            if ("workflow.activity".equals(dsKey)) {
                String entityNumber = MetadataDao.getNumberById((String)entityId);
                Collection approveActivities = WorkflowServiceHelper.getPrintMetaEntityNumber((String)entityNumber);
                String[] newKey = key.split("\\_");
                String bizIdentifyKey = newKey[0];
                String activity = newKey[1];
                Stream<Map> filterActivity = approveActivities.stream().filter(p -> bizIdentifyKey.equals(p.get("bizIdentifyKey")));
                Optional<Map> optActivity = filterActivity.findFirst();
                if (optActivity.isPresent()) {
                    Map matchedActivity = optActivity.get();
                    String activityName = (String)matchedActivity.get("activityName");
                    Map printMeta = (Map)matchedActivity.get("printMeta");
                    String tt = (String)printMeta.get(activity);
                    aliases.add(activityName + "." + tt);
                }
            }
        } else if ("10".equals(dsType)) {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)this.getCurEntityId(), (MetaCategory)MetaCategory.Form);
            for (ControlAp element : formMetadata.getItems()) {
                if (!(element instanceof IAttachmentPanelAp) || !StringUtils.equals((CharSequence)key, (CharSequence)element.getKey())) continue;
                aliases.add(element.getName().getLocaleValue());
                break;
            }
        } else if ("7".equals(dsType)) {
            String queryEntityId = MetadataDao.getIdByNumber((String)dsKey, (MetaCategory)MetaCategory.Entity);
            if (StringUtils.isNotBlank((CharSequence)queryEntityId)) {
                MetadataReader reader = new MetadataReader(false);
                EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(queryEntityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
                QueryEntity rootEntiry = (QueryEntity)entityMetadata.getRootEntity();
                List mainSelectFields = rootEntiry.getSelectFields();
                for (QuerySelectField selectfield : mainSelectFields) {
                    if (!selectfield.getAlias().equals(key)) continue;
                    aliases.add(selectfield.getDisplayName());
                }
            }
        } else if ("9".equals(dsType)) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)dsKey);
            String[] keySet = StringUtils.split((String)key, (String)".");
            LinkedList<String> keys = new LinkedList<String>();
            for (int i = 0; i < keySet.length; ++i) {
                keys.offer(keySet[i]);
            }
            this.findAlias((DynamicObjectType)dt, keys, aliases);
        } else if (!"5".equals(dsType)) {
            MainEntityType dt = EntityMetadataCache.getDataEntityTypeById((String)this.getCurEntityId());
            String[] keySet = StringUtils.split((String)key, (String)".");
            LinkedList<String> keys = new LinkedList<String>();
            for (int i = 0; i < keySet.length; ++i) {
                keys.offer(keySet[i]);
            }
            this.findAlias((DynamicObjectType)dt, keys, aliases);
        }
        return aliases.stream().collect(Collectors.joining("."));
    }

    private void findAlias(DynamicObjectType dt, Queue<String> keys, List<String> alias) {
        BasedataProp prop;
        MainEntityType baseDT;
        if (dt == null || keys.isEmpty()) {
            return;
        }
        String key = keys.poll();
        DynamicProperty tarProp = dt.getProperty(key);
        if (tarProp == null && (baseDT = EntityMetadataCache.getDataEntityType((String)dt.getName())) != null) {
            tarProp = baseDT.findProperty(key);
        }
        if (tarProp instanceof BasedataProp) {
            prop = (BasedataProp)tarProp;
            LocaleString displayName = prop.getDisplayName();
            if (displayName != null) {
                alias.add(displayName.getLocaleValue());
            }
            this.findAlias((DynamicObjectType)prop.getComplexType(), keys, alias);
        } else if (tarProp instanceof MulBasedataProp) {
            prop = (MulBasedataProp)tarProp;
            LocaleString displayName = prop.getDisplayName();
            if (displayName != null) {
                alias.add(displayName.getLocaleValue());
            }
            this.findAlias(prop.getDynamicCollectionItemPropertyType(), keys, alias);
        } else if (tarProp instanceof EntryProp) {
            prop = (EntryProp)tarProp;
            LocaleString displayName = prop.getDisplayName();
            if (displayName != null) {
                alias.add(displayName.getLocaleValue());
            }
            this.findAlias(prop.getDynamicCollectionItemPropertyType(), keys, alias);
        } else if (tarProp instanceof DynamicProperty) {
            if ("seq".equals(tarProp.getName())) {
                alias.add(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"PrintBindFieldConverter_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            } else {
                LocaleString displayName = tarProp.getDisplayName();
                if (displayName != null) {
                    alias.add(displayName.getLocaleValue());
                }
            }
        }
    }
}

