/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.designer.property.alias.AbstractPropertyConverter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.report.ReportCommFilterPanelAp;
import kd.bos.metadata.report.ReportMoreFilterPanelAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.util.CollectionUtils;

public class ReportInitialFieldConverter
extends AbstractPropertyConverter {
    private static final String INITIAL_HIDE = "initialHide";
    private static final String FIELD_KEY = "fieldKey";

    @Override
    public Object convert(Object value) {
        EntityMetadata entityMetadata;
        if (!(value instanceof List)) {
            return null;
        }
        List context = (List)this.context;
        FormMetadata listMetadata = FormTreeBuilder.deserialzeFormMetadata((List)((List)context.get(0)));
        Map<String, LocaleString> canSetFields = this.canSetFields(listMetadata, entityMetadata = FormTreeBuilder.deserializeEntityMetadata((List)((List)context.get(1))));
        if (CollectionUtils.isEmpty(canSetFields)) {
            return null;
        }
        List hideField = (List)value;
        Map defaultFieldsMap = null;
        if (!CollectionUtils.isEmpty((Collection)hideField)) {
            defaultFieldsMap = hideField.stream().collect(Collectors.toMap(item -> item.get(FIELD_KEY).toString(), Function.identity()));
        }
        LinkedHashSet<String> aliasSet = new LinkedHashSet<String>(canSetFields.size() - hideField.size());
        for (Map.Entry<String, LocaleString> field : canSetFields.entrySet()) {
            LocaleString name;
            Map fieldValue;
            String fieldKey = field.getKey();
            Map map = fieldValue = defaultFieldsMap == null ? null : (Map)defaultFieldsMap.get(fieldKey);
            if (fieldValue != null && !CollectionUtils.isEmpty((Map)fieldValue) && fieldValue.getOrDefault(INITIAL_HIDE, false).booleanValue() || (name = canSetFields.get(fieldKey)) == null) continue;
            aliasSet.add(name.toString());
        }
        return String.join((CharSequence)";", aliasSet);
    }

    private Map<String, LocaleString> canSetFields(FormMetadata listMetadata, EntityMetadata entityMetadata) {
        List<ControlAp<?>> commonFilterColumnAps = this.getCommonFilterColumnAp(listMetadata);
        LinkedHashMap<String, LocaleString> canSetField = new LinkedHashMap<String, LocaleString>(16);
        HashMap<String, String> radioGroupField = new HashMap<String, String>(16);
        this.getFieldList(commonFilterColumnAps, entityMetadata, canSetField, radioGroupField);
        return canSetField;
    }

    private void getFieldList(List<ControlAp<?>> commonFilterColumnAps, EntityMetadata entityMetadata, Map<String, LocaleString> canSetField, Map<String, String> radioGroupField) {
        for (ControlAp<?> ap : commonFilterColumnAps) {
            if (ap instanceof FlexPanelAp || ap instanceof AdvConAp || ap instanceof AdvConChildPanelAp) {
                this.getFieldList(((ContainerAp)ap).getItems(), entityMetadata, canSetField, radioGroupField);
                continue;
            }
            if (!(ap instanceof FieldAp)) continue;
            FieldAp fieldAp = (FieldAp)ap;
            Field field = entityMetadata.getFieldByKey(fieldAp.getKey());
            if (field instanceof RadioGroupField) {
                radioGroupField.put(fieldAp.getId(), fieldAp.getKey());
            } else if (field instanceof RadioField && canSetField.containsKey(radioGroupField.get(((RadioField)field).getGroup()))) continue;
            canSetField.put(fieldAp.getKey(), fieldAp.getName());
        }
    }

    private List<ControlAp<?>> getCommonFilterColumnAp(FormMetadata listMetadata) {
        ArrayList commonFilterColumnAps = new ArrayList();
        listMetadata.createIndex();
        for (ControlAp item : listMetadata.getItems()) {
            if (item instanceof ReportCommFilterPanelAp) {
                commonFilterColumnAps.addAll(((ReportCommFilterPanelAp)item).getItems());
            }
            if (!(item instanceof ReportMoreFilterPanelAp)) continue;
            commonFilterColumnAps.addAll(((ReportMoreFilterPanelAp)item).getItems());
        }
        return commonFilterColumnAps;
    }
}

