/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.alias;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.designer.property.alias.AbstractPropertyConverter;
import kd.bos.designer.property.alias.AliasConverterHelper;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.list.ApproverListColumnAp;
import kd.bos.metadata.list.DynamicTextListColumnAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListOperationColumnAp;
import kd.bos.metadata.list.MergeListColumnAp;
import kd.bos.metadata.list.VoucherNoListColumnAp;
import kd.bos.mservice.svc.picture.IPictureListColumnAp;

public class SortSettingConverter
extends AbstractPropertyConverter {
    private static final String FSEQ = "fseq";

    @Override
    public Object convert(Object value) {
        if (!(value instanceof List) || ((List)value).isEmpty()) {
            return null;
        }
        StringBuilder alias = new StringBuilder();
        List<ControlAp<?>> billListColumnAps = AliasConverterHelper.getBillListColumnAps((List)this.context, null);
        ArrayList canSortField = new ArrayList();
        for (ControlAp<?> ap : billListColumnAps) {
            if (this.isListColumn(ap)) continue;
            if (ap instanceof MergeListColumnAp || ap instanceof ListColumnGroupAp) {
                this.traverseGetSubControlAp(ap, canSortField);
                continue;
            }
            if (!(ap instanceof ListColumnAp) || FSEQ.equals(((ListColumnAp)ap).getListFieldId())) continue;
            canSortField.removeIf(item -> ((ListColumnAp)ap).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            canSortField.add(ap);
        }
        for (Map fieldSort : (List)value) {
            String listFieldId = (String)fieldSort.get("FieldName");
            for (ControlAp controlAp : canSortField) {
                if (!((ListColumnAp)controlAp).getListFieldId().equals(listFieldId)) continue;
                alias.append(alias.length() == 0 ? alias.toString() : "; ").append(controlAp.getName().getLocaleValue());
            }
        }
        return alias.toString();
    }

    private void traverseGetSubControlAp(ControlAp<?> ap, List<ControlAp<?>> canSortField) {
        List subControlAps = ((ContainerAp)ap).getItems();
        for (ControlAp subControlAp : subControlAps) {
            if (this.isListColumn(subControlAp)) continue;
            if (subControlAp instanceof MergeListColumnAp || subControlAp instanceof ListColumnGroupAp) {
                this.traverseGetSubControlAp(subControlAp, canSortField);
                continue;
            }
            if (!(subControlAp instanceof ListColumnAp) || FSEQ.equals(((ListColumnAp)subControlAp).getListFieldId())) continue;
            canSortField.removeIf(item -> ((ListColumnAp)subControlAp).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            canSortField.add(subControlAp);
        }
    }

    private boolean isListColumn(ControlAp<?> ap) {
        return ap instanceof IPictureListColumnAp || ap instanceof DynamicTextListColumnAp || ap instanceof ListOperationColumnAp || ap instanceof VoucherNoListColumnAp || ap instanceof ApproverListColumnAp;
    }
}

