/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.common;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class IdeSingleSelectFieldPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String ENTRY_KEY = "entryfield";
    private static final String VALUE_KEY = "value";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void afterCreateNewData(EventObject e) {
        List lstFields = (List)this.getView().getFormShowParameter().getCustomParam(VALUE_KEY);
        if (lstFields != null && lstFields.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRY_KEY, lstFields.size());
            int i = 0;
            for (Map form : lstFields) {
                model.setValue("id", form.get("Id"), i);
                model.setValue("number", form.get("Key"), i);
                model.setValue("name", form.get("Name"), i);
                model.setValue("type", form.get("_Type_"), i);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (src instanceof Button) {
            Button btn = (Button)src;
            switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
                case "btnok": {
                    this.returnData();
                    break;
                }
                case "btncancel": {
                    this.cancel();
                    break;
                }
            }
        }
    }

    private void cancel() {
        this.getView().close();
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && row >= 0) {
            HashMap<String, String> OrgRelationOrg = new HashMap<String, String>();
            OrgRelationOrg.put("Id", (String)this.getModel().getValue("id", row));
            OrgRelationOrg.put("Name", (String)this.getModel().getValue("name", row));
            OrgRelationOrg.put("Number", (String)this.getModel().getValue("number", row));
            OrgRelationOrg.put("Type", (String)this.getModel().getValue("type", row));
            this.getView().returnDataToParent(OrgRelationOrg);
        } else {
            this.getView().returnDataToParent((Object)0);
        }
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnData();
    }
}

