/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.designer.property.formruleactiontypes.BaseTreeFormPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.orm.util.CollectionUtils;

public class BaseMulPropSetPlugin
extends BaseTreeFormPlugin
implements IBizRuleEditor {
    static final String entryKey = "entryentity";
    static final String clearAll = "clearall";
    static final String deleteRow = "deleterow";
    static final String fieldName = "fieldname";
    static final String fieldValue = "fieldvalue";
    static final String nameKey = "namekey";
    static final String barProp = "bar_prop";
    private static final String PROPERTY_NAME = "PropertyName";
    private static final String PROPERTY_VALUE = "PropertyValue";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CHECK_NODES = "checkNodes";

    public BaseMulPropSetPlugin() {
        this.keyType = 2;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{barProp});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        this.getPageCache().put("context", SerializationUtils.toJsonString((Object)formContext));
        String billKey = (String)((Map)formContext.get(0)).get("Key");
        this.getPageCache().put("billKey", billKey);
        IDataModel model = this.getModel();
        model.deleteEntryData(entryKey);
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(formContext);
        formMetadata.createIndex();
        for (String key : this.checkNodeIds) {
            String fieldId;
            TreeNode node = this.root.getTreeNode(key, 16);
            boolean isControlKey = Boolean.FALSE;
            if (node == null && StringUtils.isNotBlank((CharSequence)(fieldId = this.getFieldIdByControlKey(key, formMetadata.getItems()))) && this.root.getTreeNode(fieldId, 16) != null) {
                node = this.root.getTreeNode(fieldId, 16);
                isControlKey = Boolean.TRUE;
            }
            if (node == null || node.getChildren() != null && !node.getChildren().isEmpty() || node.getId().equals(billKey)) continue;
            int row = model.createNewEntryRow(entryKey);
            model.setValue(nameKey, (Object)node.getText(), row);
            for (Map map : this.listMap) {
                if (!node.getId().equals(map.get("Id")) && (!isControlKey || !key.equals(map.get("Id")))) continue;
                model.setValue(fieldName, map.get(PROPERTY_NAME), row);
                model.setValue(fieldValue, map.get(PROPERTY_VALUE), row);
            }
        }
    }

    private String getFieldIdByControlKey(String controlKey, List<ControlAp<?>> controlAps) {
        if (StringUtils.isBlank((CharSequence)controlKey) || CollectionUtils.isEmpty(controlAps)) {
            return null;
        }
        String fieldId = null;
        for (ControlAp<?> controlAp : controlAps) {
            ListColumnAp listColumnAp;
            if (!(controlAp instanceof ListColumnAp) || !controlKey.equals((listColumnAp = (ListColumnAp)controlAp).getKey())) continue;
            fieldId = listColumnAp.getListFieldId();
            break;
        }
        return fieldId;
    }

    public void itemClick(ItemClickEvent evt) {
        String keyClick = evt.getItemKey();
        ArrayList list = new ArrayList();
        if (deleteRow.equals(keyClick)) {
            AbstractGrid abstractGrid = (AbstractGrid)this.getControl(entryKey);
            int[] currIndex = abstractGrid.getEntryState().getSelectedRows();
            if (currIndex.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5b57\u6bb5\u884c\u3002", (String)"BaseMulPropSetPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            ArrayList<String> rowsKey = new ArrayList<String>(10);
            for (int i : currIndex) {
                String namekey = (String)this.getModel().getValue(nameKey, i);
                String key = namekey.substring(namekey.lastIndexOf("(") + 1, namekey.lastIndexOf(")"));
                rowsKey.add(key);
            }
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            treeView.uncheckNodes(rowsKey);
            this.getModel().deleteEntryRows(entryKey, currIndex);
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)treeView.getTreeState().getCheckedNodeIds()));
        } else if (clearAll.equalsIgnoreCase(keyClick)) {
            this.getModel().deleteEntryData(entryKey);
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            List selectedChecks = tree.getTreeState().getCheckedNodeIds();
            tree.uncheckNodes(selectedChecks);
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(list));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        this.selectTreeNode(evt.getChecked());
    }

    private void selectTreeNode(boolean select) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("fieldTree"), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        ArrayList currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        ArrayList selList = new ArrayList();
        selList.addAll(currChecks);
        IDataModel model = this.getModel();
        if (select) {
            if (checkNodes.isEmpty() || selList.removeAll(checkNodes)) {
                currChecks.clear();
                currChecks = selList;
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    String billKey = this.getPageCache().get("billKey");
                    if (node == null || node.getChildren() != null && !node.getChildren().isEmpty() || node.getId().equals(billKey)) continue;
                    int row = model.createNewEntryRow(entryKey);
                    model.setValue(nameKey, (Object)node.getText(), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = model.getEntryRowCount(entryKey) - 1; i >= 0; --i) {
                String namekey = (String)model.getValue(nameKey, i);
                String key = namekey.substring(namekey.lastIndexOf("(") + 1, namekey.lastIndexOf(")"));
                if (!checkNodes.contains(key)) continue;
                rows.add(i);
            }
            if (!rows.isEmpty()) {
                model.deleteEntryRows(entryKey, rows.stream().mapToInt(h -> h).toArray());
            }
        }
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    public List<Map<String, Object>> entryRows(String serviceTypeId, BeforeClosedEvent e) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int count = this.getModel().getEntryRowCount(entryKey);
        if (count < 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u4e00\u884c\u6570\u636e\u3002", (String)"BaseMulPropSetPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            for (int i = 0; i < count; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                String namekey = (String)this.getModel().getValue(nameKey, i);
                String key = namekey.substring(namekey.lastIndexOf("(") + 1, namekey.lastIndexOf(")"));
                String propertyName = (String)this.getModel().getValue(fieldName, i);
                String propertyValue = (String)this.getModel().getValue(fieldValue, i);
                if (StringUtils.isBlank((CharSequence)propertyName) || StringUtils.isBlank((CharSequence)propertyValue)) {
                    this.getView().getParentView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\uff0c\u5c5e\u6027\u540d\u5c5e\u6027\u503c\u8bf7\u586b\u5199\u5b8c\u6574\u3002", (String)"BaseMulPropSetPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1), Integer.valueOf(5000));
                    e.setCancel(true);
                    return new ArrayList<Map<String, Object>>();
                }
                if (serviceTypeId.contains("Field")) {
                    map.put("_Type_", "ClientProperty");
                }
                map.put("Id", key);
                map.put(PROPERTY_NAME, propertyName);
                map.put(PROPERTY_VALUE, propertyValue);
                list.add(map);
            }
        }
        return list;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        HashMap<String, String> exp = new HashMap<String, String>();
        List<Object> controlList = new ArrayList();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serviceTypeId = (String)customParams.get("serviceTypeId");
        int controlType = (Integer)this.getView().getFormShowParameter().getCustomParams().get("controlType");
        if (controlType == 1 || controlType == 2) {
            controlList = this.entryRows(serviceTypeId, e);
            exp.put("ClientProperties", SerializationUtils.toJsonString(controlList));
        }
        this.getView().returnDataToParent(exp);
    }

    public String getOutConfig() {
        HashMap<String, String> exp = new HashMap<String, String>();
        ArrayList controlList = new ArrayList();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serviceTypeId = (String)customParams.get("serviceTypeId");
        int controlType = (Integer)this.getView().getFormShowParameter().getCustomParams().get("controlType");
        if (controlType == 1 || controlType == 2) {
            int count = this.getModel().getEntryRowCount(entryKey);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String namekey = (String)this.getModel().getValue(nameKey, i);
                    String key = namekey.substring(namekey.lastIndexOf("(") + 1, namekey.lastIndexOf(")"));
                    String propertyName = (String)this.getModel().getValue(fieldName, i);
                    String propertyValue = (String)this.getModel().getValue(fieldValue, i);
                    if (serviceTypeId.contains("Field")) {
                        map.put("_Type_", "ClientProperty");
                    }
                    map.put("Id", key);
                    map.put(PROPERTY_NAME, propertyName);
                    map.put(PROPERTY_VALUE, propertyValue);
                    controlList.add(map);
                }
            }
            exp.put("ClientProperties", SerializationUtils.toJsonString(controlList));
        }
        return SerializationUtils.toJsonString(exp);
    }
}

