/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.formruleactiontypes.FieldTreeSearchUtil;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class ClearValuePlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
IBizRuleEditor,
F7SelectedListRemoveListener,
SearchEnterListener {
    private static final long serialVersionUID = -6264470238648123248L;
    private static final String KEY_SELECTEDFIELD = "f7selectedlistap";
    private static final String EXPRESSION = "Expression";
    private static final String FIELD_TREE = "fieldTree";
    private static final String SEARCH_AP = "searchap";

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl("TreeViewAp");
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(KEY_SELECTEDFIELD);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        Search searchEdit = (Search)this.getControl(SEARCH_AP);
        searchEdit.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map value;
        if (this.getView().getFormShowParameter().getCustomParams().get("context") == null || this.getView().getFormShowParameter().getCustomParams().get("metaType") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ClearValuePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        List contextEntitymeata = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        PropertyEditHelper helper = new PropertyEditHelper();
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeBDRefProp(false);
        option.addInvalidClassTypes(MuliLangTextField.class);
        option.addInvalidClassTypes(BasedataPropField.class);
        boolean isEntityDesign = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("isEntityDesign"));
        String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get("itemId");
        if (isEntityDesign) {
            option.setCurrentEntity(itemId);
        } else {
            option.setCurrentEntity(helper.getItemId(this.getView()));
        }
        option.setIncludeParentEntity(false);
        option.setIncludeChildEntity(false);
        TreeNode root = FormTreeBuilder.buildEntityFieldsTree((List)contextEntitymeata, (EntityFieldTreeBuildOption)option);
        TreeView tree = (TreeView)this.getView().getControl("TreeViewAp");
        root.setIsOpened(true);
        tree.addNode(root);
        tree.expand(root.getId());
        Object valueOb = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (valueOb != null && (value = (Map)SerializationUtils.fromJsonString((String)((String)valueOb), Map.class)).containsKey(EXPRESSION)) {
            String expression = value.get(EXPRESSION).toString();
            List nodes = Arrays.stream(expression.split(":")).map(id -> this.findNodeById(root, (String)id)).collect(Collectors.toList());
            tree.checkNodes(nodes);
            this.restoreExpression();
        }
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        this.restoreExpression();
    }

    public boolean checkConfig() {
        return true;
    }

    public String getOutConfig() {
        IFormView parent = this.getView().getParentView();
        IPageCache cache = (IPageCache)parent.getService(IPageCache.class);
        return cache.get("expression");
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        Object param = evt.getParam();
        if (param instanceof String) {
            tree.uncheckNode(param.toString());
        } else {
            tree.getTreeState().getSelectedNodeId().forEach(arg_0 -> ((TreeView)tree).uncheckNode(arg_0));
        }
        this.restoreExpression();
    }

    private TreeNode findNodeById(TreeNode root, String id) {
        if (root == null) {
            return null;
        }
        if (root.getId().equals(id)) {
            return root;
        }
        List children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (TreeNode childNode : children) {
            TreeNode tar = this.findNodeById(childNode, id);
            if (tar == null) continue;
            return tar;
        }
        return null;
    }

    private void restoreExpression() {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(KEY_SELECTEDFIELD);
        List checkedNodes = tree.getTreeState().getCheckedNodes();
        checkedNodes.removeIf(item -> Boolean.TRUE.equals(item.get("isParent")) || item.get("children") != null);
        f7SelectedList.addItems(checkedNodes.stream().map(node -> new ValueTextItem(String.valueOf(node.get("id")), String.valueOf(node.get("text")))).collect(Collectors.toList()));
        IFormView parent = this.getView().getParentView();
        IPageCache cache = (IPageCache)parent.getService(IPageCache.class);
        HashMap<String, String> map = new HashMap<String, String>();
        String result = checkedNodes.stream().map(item -> item.get("id").toString()).collect(Collectors.joining(":"));
        map.put(EXPRESSION, result);
        cache.put("expression", SerializationUtils.toJsonString(map));
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        FieldTreeSearchUtil.doSearch(searchText, rootNode, this.getView());
    }
}

