/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.clientrules.RuleTriggerContainer;
import kd.bos.designer.property.formruleactiontypes.BaseTreeFormPlugin;
import kd.bos.designer.property.formruleactiontypes.FieldTreeSearchUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.exception.CheckResultInfo;
import kd.bos.metadata.exception.ErrorInfo;

public class DisplayStyleSetPlugin
extends BaseTreeFormPlugin
implements IBizRuleEditor,
SearchEnterListener {
    static final String entryKey = "entryentity";
    static final String clearAll = "clearall";
    static final String deleteRow = "deleterow";
    static final String fieldFontSize = "fontSize";
    static final String fieldFontColor = "foreColor";
    static final String fieldBackColor = "backgroundColor";
    static final String nameKey = "namekey";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CONTEXT = "context";
    private static final String BACKGROUND_COLOR = "BackgroundColor";
    private static final String FORE_COLOR = "ForeColor";
    private static final String CHECK_NODES = "checkNodes";
    private static final String ROW_INDEX = "rowIndex";
    private static final String OLD_VALUE = "oldValue";
    private boolean isCallBack = false;
    private static final String CONTROLID = "controlKey";
    private static final String VALUE_FONTSIZE = "ValueFontSize";
    private static final String VALUE_FORECOLOR = "ValueForeColor";
    private static final String VALUE_BACKGROUNDCOLOR = "ValueBackgroundColor";
    private static final String SEARCH_AP = "searchap";
    private static final String FIELD_TREE = "fieldTree";

    private void showSelectedCount() {
        int count = this.getModel().getEntryRowCount(entryKey);
        Label countLabel = (Label)this.getControl("selectedcount");
        countLabel.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%d\uff09\u9879", (String)"DisplayStyleSetPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), count));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{clearAll, deleteRow});
        Search searchEdit = (Search)this.getControl(SEARCH_AP);
        searchEdit.addEnterListener((SearchEnterListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        this.getPageCache().put(CONTEXT, SerializationUtils.toJsonString((Object)formContext));
        String serviceTypeId = (String)this.getView().getFormShowParameter().getCustomParams().get("serviceTypeId");
        String fromTag = (String)this.getView().getFormShowParameter().getCustomParam("fromTag");
        if (RuleTriggerContainer.List.toString().equals(fromTag)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"valuefontsize", "valueforecolor", "valuebackgroundcolor"});
        }
        String billKey = (String)((Map)formContext.get(0)).get("Key");
        this.getPageCache().put("billKey", billKey);
        IDataModel model = this.getModel();
        model.deleteEntryData(entryKey);
        for (String key : this.checkNodeIds) {
            TreeNode node = this.root.getTreeNode(key, 16);
            ArrayList<ComboItem> bgCombolist = new ArrayList<ComboItem>();
            ArrayList<ComboItem> bcCombolist = new ArrayList<ComboItem>();
            ArrayList<ComboItem> vbgCombolist = new ArrayList<ComboItem>();
            ArrayList<ComboItem> vfcCombolist = new ArrayList<ComboItem>();
            if (node == null || node.getChildren() != null && !node.getChildren().isEmpty() || node.getId().equals(billKey)) continue;
            int row = model.createNewEntryRow(entryKey);
            model.setValue(CONTROLID, (Object)node.getId(), row);
            model.setValue(nameKey, (Object)node.getText(), row);
            for (Map map : this.listMap) {
                if (!node.getId().equals(map.get("Id"))) continue;
                bgCombolist.add(new ComboItem(new LocaleString((String)map.get(BACKGROUND_COLOR)), (String)map.get(BACKGROUND_COLOR)));
                bcCombolist.add(new ComboItem(new LocaleString((String)map.get(FORE_COLOR)), (String)map.get(FORE_COLOR)));
                vbgCombolist.add(new ComboItem(new LocaleString((String)map.get(VALUE_BACKGROUNDCOLOR)), (String)map.get(VALUE_BACKGROUNDCOLOR)));
                vfcCombolist.add(new ComboItem(new LocaleString((String)map.get(VALUE_FORECOLOR)), (String)map.get(VALUE_FORECOLOR)));
                model.setValue(fieldFontSize, map.get("FontSize"), row);
                model.setValue(fieldFontColor, map.get(FORE_COLOR), row);
                model.setValue(fieldBackColor, map.get(BACKGROUND_COLOR), row);
                model.setValue(VALUE_FONTSIZE, map.get(VALUE_FONTSIZE), row);
                model.setValue(VALUE_FORECOLOR, map.get(VALUE_FORECOLOR), row);
                model.setValue(VALUE_BACKGROUNDCOLOR, map.get(VALUE_BACKGROUNDCOLOR), row);
            }
            this.resetComboItems(fieldBackColor, bgCombolist);
            this.resetComboItems(fieldFontColor, bcCombolist);
            this.resetComboItems(VALUE_BACKGROUNDCOLOR, vbgCombolist);
            this.resetComboItems(VALUE_FORECOLOR, vfcCombolist);
        }
        if (serviceTypeId.startsWith("Set") || serviceTypeId.startsWith("ClientSet")) {
            this.showSelectedCount();
        }
    }

    public void click(EventObject evt) {
        String keyClick = ((Control)evt.getSource()).getKey();
        ArrayList list = new ArrayList();
        if (deleteRow.equals(keyClick)) {
            AbstractGrid abstractGrid = (AbstractGrid)this.getControl(entryKey);
            int[] currIndex = abstractGrid.getEntryState().getSelectedRows();
            if (currIndex.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u5b57\u6bb5\u884c\u3002", (String)"DisplayStyleSetPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            ArrayList<String> rowsKey = new ArrayList<String>(10);
            for (int i : currIndex) {
                String key = (String)this.getModel().getValue(CONTROLID, i);
                rowsKey.add(key);
            }
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            treeView.uncheckNodes(rowsKey);
            this.getModel().deleteEntryRows(entryKey, currIndex);
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)treeView.getTreeState().getCheckedNodeIds()));
        } else if (clearAll.equalsIgnoreCase(keyClick)) {
            this.getModel().deleteEntryData(entryKey);
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            List selectedChecks = tree.getTreeState().getCheckedNodeIds();
            tree.uncheckNodes(selectedChecks);
            this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(list));
        }
        this.showSelectedCount();
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        this.selectTreeNode(evt.getChecked());
    }

    private void selectTreeNode(boolean select) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        ArrayList currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        ArrayList selList = new ArrayList();
        selList.addAll(currChecks);
        IDataModel model = this.getModel();
        if (select) {
            if (checkNodes.isEmpty() || selList.removeAll(checkNodes)) {
                currChecks.clear();
                currChecks = selList;
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    String billKey = this.getPageCache().get("billKey");
                    if (node == null || node.getChildren() != null && !node.getChildren().isEmpty() || node.getId().equals(billKey)) continue;
                    int row = model.createNewEntryRow(entryKey);
                    model.setValue(nameKey, (Object)node.getText(), row);
                    model.setValue(CONTROLID, (Object)node.getId(), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            ArrayList<Integer> rows = new ArrayList<Integer>();
            for (int i = model.getEntryRowCount(entryKey) - 1; i >= 0; --i) {
                String id = (String)this.getModel().getValue(CONTROLID, i);
                if (!checkNodes.contains(id)) continue;
                rows.add(i);
            }
            if (!rows.isEmpty()) {
                model.deleteEntryRows(entryKey, rows.stream().mapToInt(h -> h).toArray());
            }
        }
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
        this.showSelectedCount();
    }

    public List<Map<String, Object>> entryRows(String serviceTypeId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int count = this.getModel().getEntryRowCount(entryKey);
        if (count < 1) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6570\u636e\u3002", (String)"DisplayStyleSetPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else {
            for (int i = 0; i < count; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                String id = (String)this.getModel().getValue(CONTROLID, i);
                String fontSize = (String)this.getModel().getValue(fieldFontSize, i);
                String foreColor = (String)this.getModel().getValue(fieldFontColor, i);
                String backColor = (String)this.getModel().getValue(fieldBackColor, i);
                String valueFontSize = (String)this.getModel().getValue(VALUE_FONTSIZE, i);
                String valueForeColor = (String)this.getModel().getValue(VALUE_FORECOLOR, i);
                String valueBackgroundColor = (String)this.getModel().getValue(VALUE_BACKGROUNDCOLOR, i);
                if (serviceTypeId.contains("Field")) {
                    map.put("_Type_", "DisplayStyle");
                }
                map.put("Id", id);
                map.put(BACKGROUND_COLOR, backColor);
                map.put(FORE_COLOR, foreColor);
                map.put("FontSize", fontSize);
                map.put(VALUE_BACKGROUNDCOLOR, valueBackgroundColor);
                map.put(VALUE_FORECOLOR, valueForeColor);
                map.put(VALUE_FONTSIZE, valueFontSize);
                list.add(map);
            }
        }
        return list;
    }

    private void resetComboItems(String key, List<ComboItem> combolist) {
        ComboProp comboProp = (ComboProp)this.getModel().getProperty(key);
        List items = comboProp.getComboItems();
        ComboEdit comboEdit = (ComboEdit)this.getControl(key);
        ArrayList newCombolist = new ArrayList();
        items.forEach(obj -> {
            ComboItem comboItem = new ComboItem(obj.getName(), obj.getValue());
            newCombolist.add(comboItem);
        });
        combolist.forEach(obj -> {
            if (newCombolist.contains(new ComboItem(new LocaleString(""), obj.getValue()))) {
                return;
            }
            ComboItem comboItem = new ComboItem(obj.getCaption(), obj.getValue());
            newCombolist.add(comboItem);
        });
        comboEdit.setComboItems(newCombolist);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        if (this.isCallBack || !"userdefine".equals(newValue)) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("null".equals(newValue)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("formrulepanel");
        formShowParameter.setFormId("ide_displayformate");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "comfirm"));
        formShowParameter.setCustomParam(CONTEXT, customParams.get(CONTEXT));
        formShowParameter.setCustomParam(ROW_INDEX, (Object)rowIndex);
        formShowParameter.setCustomParam("fs", (Object)12);
        formShowParameter.setCustomParam("bc", (Object)"#FFFFFF");
        formShowParameter.setCustomParam("fc", (Object)"#212121");
        formShowParameter.setCustomParam("fromTag", this.getView().getFormShowParameter().getCustomParam("fromTag"));
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put(OLD_VALUE, e.getChangeSet()[0].getOldValue());
        value.put(ROW_INDEX, rowIndex);
        value.put("propName", e.getProperty().getName());
        this.getPageCache().put(OLD_VALUE, SerializationUtils.toJsonString(value));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ArrayList<ComboItem> bcCombolist;
        ArrayList<ComboItem> bgCombolist;
        String retData = (String)e.getReturnData();
        if (retData == null) {
            String oldValue;
            String value = this.getPageCache().get(OLD_VALUE);
            Map valMap = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                valMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            }
            if ("null".equals(oldValue = String.valueOf(valMap.get(OLD_VALUE)))) {
                oldValue = "";
            }
            String propName = String.valueOf(valMap.get("propName"));
            int index = (Integer)valMap.get(ROW_INDEX);
            this.getModel().setValue(propName, (Object)oldValue, index);
            return;
        }
        this.isCallBack = true;
        Map map = (Map)SerializationUtils.fromJsonString((String)retData, Map.class);
        int rowIndex = (Integer)map.remove(ROW_INDEX);
        if (map.get("bc") != null) {
            bgCombolist = new ArrayList<ComboItem>();
            bgCombolist.add(new ComboItem(new LocaleString(map.get("bc").toString()), map.get("bc").toString()));
            this.resetComboItems(fieldBackColor, bgCombolist);
            this.getModel().setValue(fieldBackColor, map.get("bc"), rowIndex);
        }
        if (map.get("fs") != null) {
            this.getModel().setValue(fieldFontSize, map.get("fs"), rowIndex);
        }
        if (map.get("fc") != null) {
            bcCombolist = new ArrayList<ComboItem>();
            bcCombolist.add(new ComboItem(new LocaleString(map.get("fc").toString()), map.get("fc").toString()));
            this.resetComboItems(fieldFontColor, bcCombolist);
            this.getModel().setValue(fieldFontColor, map.get("fc"), rowIndex);
        }
        if (map.get("vbc") != null) {
            bgCombolist = new ArrayList();
            bgCombolist.add(new ComboItem(new LocaleString(map.get("vbc").toString()), map.get("vbc").toString()));
            this.resetComboItems(VALUE_BACKGROUNDCOLOR, bgCombolist);
            this.getModel().setValue(VALUE_BACKGROUNDCOLOR, map.get("vbc"), rowIndex);
        }
        if (map.get("vfs") != null) {
            this.getModel().setValue(VALUE_FONTSIZE, map.get("vfs"), rowIndex);
        }
        if (map.get("vfc") != null) {
            bcCombolist = new ArrayList();
            bcCombolist.add(new ComboItem(new LocaleString(map.get("vfc").toString()), map.get("vfc").toString()));
            this.resetComboItems(VALUE_FORECOLOR, bcCombolist);
            this.getModel().setValue(VALUE_FORECOLOR, map.get("vfc"), rowIndex);
        }
        this.isCallBack = false;
        super.closedCallBack(e);
    }

    public String getOutConfig() {
        HashMap<String, String> exp = new HashMap<String, String>();
        List<Object> controlList = new ArrayList();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serviceTypeId = (String)customParams.get("serviceTypeId");
        int controlType = (Integer)this.getView().getFormShowParameter().getCustomParams().get("controlType");
        if (controlType == 1) {
            controlList = this.entryRows(serviceTypeId);
            exp.put("DisplayStyles", SerializationUtils.toJsonString(controlList));
        } else if (controlType == 2) {
            controlList = this.entryRows(serviceTypeId);
            exp.put("Controls", SerializationUtils.toJsonString(controlList));
        }
        return SerializationUtils.toJsonString(exp);
    }

    public CheckResultInfo checkConfigAndReturn() {
        CheckResultInfo resultInfo = new CheckResultInfo(true);
        int count = this.getModel().getEntryRowCount(entryKey);
        if (count < 1) {
            resultInfo.setSuccess(false);
            resultInfo.setInfo(new ErrorInfo(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6570\u636e\u3002", (String)"DisplayStyleSetPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        }
        return resultInfo;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        FieldTreeSearchUtil.doSearch(searchText, rootNode, this.getView());
    }
}

