/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;

public class FieldTreeSearchUtil {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    protected static void doSearch(String searchText, TreeNode rootNode, IFormView view) {
        List treeNodes;
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String searchNodesCacheKey = view.getPageId() + "_searchNodes";
        String matchNodesCacheKey = view.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = view.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = view.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"FieldTreeSearchUtil_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)view.getControl("treeviewap");
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                FieldTreeSearchUtil.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                FieldTreeSearchUtil.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private static void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        FieldTreeSearchUtil.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
    }

    private static void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        TreeNode p;
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid) && (p = rootNode.getTreeNode(parentid)) != null) {
            FieldTreeSearchUtil.expandParents(treeView, rootNode, p);
            treeView.expand(parentid);
        }
    }
}

