/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.UnitConvertDTO;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.rule.FillQtyAction;
import kd.bos.metadata.entity.rule.IBizRuleEditor;

public class FillQtyPlugin
extends AbstractFormPlugin
implements IBizRuleEditor {
    private static final String KEY_SRCQTY_FIELD = "srcqty";
    private static final String KEY_DISTQTY_FIELD = "distqty";
    private static final String KEY_ENTITY = "entryentity";
    private static final String CONTEXT = "context";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CLOSE_FAILED = "closeFailed";

    public void afterCreateNewData(EventObject e) {
        List unitConvertDTOs;
        FillQtyAction fillQtyActionMeta;
        String expression;
        if (this.getView().getFormShowParameter().getCustomParams().get(CONTEXT) == null || this.getView().getFormShowParameter().getCustomParams().get("metaType") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"FillQtyPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        List contextEntitymeata = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)contextEntitymeata);
        List entitys = entityMetadata.getEntitys();
        ArrayList allQtyFields = new ArrayList();
        for (Entity entity : entitys) {
            List qtyFields = entity.getItems().stream().filter(item -> item instanceof QtyField).map(qtyField -> new ComboItem(((QtyField)qtyField).getName(), qtyField.getKey())).collect(Collectors.toList());
            allQtyFields.addAll(qtyFields);
        }
        ComboEdit srcqty = (ComboEdit)this.getView().getControl(KEY_SRCQTY_FIELD);
        srcqty.setComboItems(allQtyFields);
        ComboEdit distqty = (ComboEdit)this.getView().getControl(KEY_DISTQTY_FIELD);
        distqty.setComboItems(allQtyFields);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.isNotBlank((CharSequence)(expression = (fillQtyActionMeta = (FillQtyAction)JSON.parseObject((String)value, FillQtyAction.class)).getExpression())) && (unitConvertDTOs = JSON.parseArray((String)expression, UnitConvertDTO.class)) != null && unitConvertDTOs.size() > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTITY, unitConvertDTOs.size());
            for (int i = 0; i < unitConvertDTOs.size(); ++i) {
                UnitConvertDTO unitConvertDTO = (UnitConvertDTO)unitConvertDTOs.get(i);
                this.getModel().setValue(KEY_DISTQTY_FIELD, (Object)unitConvertDTO.getDistQtyField(), i);
                this.getModel().setValue(KEY_SRCQTY_FIELD, (Object)unitConvertDTO.getSrcQtyField(), i);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (!this.checkValidity()) {
            event.setCancel(true);
            return;
        }
        this.getPageCache().put(CLOSE_FAILED, null);
        DynamicObjectCollection col = this.getModel().getEntryEntity(KEY_ENTITY);
        if (col == null || col.isEmpty()) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Expression", this.getExpression());
        this.getView().returnDataToParent(map);
    }

    private boolean checkValidity() {
        List contextEntitymeata = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)contextEntitymeata);
        MainEntityType dt = entityMetadata.buildDataEntityType();
        Map allFields = dt.getAllFields();
        int rows = this.getModel().getEntryRowCount(KEY_ENTITY);
        for (int i = 0; i < rows; ++i) {
            String distQty = (String)this.getModel().getValue(KEY_DISTQTY_FIELD, i);
            String srcQty = (String)this.getModel().getValue(KEY_SRCQTY_FIELD, i);
            if (StringUtils.isBlank((CharSequence)distQty) || StringUtils.isBlank((CharSequence)srcQty)) {
                this.getPageCache().put(CLOSE_FAILED, String.format(ResManager.loadKDString((String)"\u5728\u7b2c%d\u884c\u4e2d\uff0c\u539f\u6570\u91cf\u548c\u76ee\u6807\u6570\u91cf\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"FillQtyPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return false;
            }
            if (StringUtils.equals((CharSequence)distQty, (CharSequence)srcQty)) {
                this.getPageCache().put(CLOSE_FAILED, String.format(ResManager.loadKDString((String)"\u5728\u7b2c%d\u884c\u4e2d\uff0c\u539f\u6570\u91cf\u548c\u76ee\u6807\u6570\u91cf\u4e0d\u80fd\u76f8\u540c\u3002", (String)"FillQtyPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return false;
            }
            if (Objects.equals(((IDataEntityProperty)allFields.get(distQty)).getParent().getName(), ((IDataEntityProperty)allFields.get(srcQty)).getParent().getName())) continue;
            this.getPageCache().put(CLOSE_FAILED, String.format(ResManager.loadKDString((String)"\u5728\u7b2c%d\u884c\u4e2d\uff0c\u539f\u6570\u91cf\u548c\u76ee\u6807\u6570\u91cf\u4e0d\u5728\u540c\u4e00\u4e2a\u5b9e\u4f53\u4e0a\uff0c\u4e0d\u5141\u8bb8\u6362\u7b97\u3002", (String)"FillQtyPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }

    public String getOutConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Expression", this.getExpression());
        return SerializationUtils.toJsonString(map);
    }

    public boolean checkConfig() {
        if (!this.checkValidity()) {
            return false;
        }
        DynamicObjectCollection col = this.getModel().getEntryEntity(KEY_ENTITY);
        return col != null && col.isEmpty();
    }

    private String getExpression() {
        ArrayList<UnitConvertDTO> unitConvertDTOs = new ArrayList<UnitConvertDTO>();
        for (DynamicObject entryMap : this.getModel().getEntryEntity(KEY_ENTITY)) {
            UnitConvertDTO unitConvertDTO = new UnitConvertDTO();
            unitConvertDTO.setSrcQtyField((String)entryMap.get(KEY_SRCQTY_FIELD));
            unitConvertDTO.setDistQtyField((String)entryMap.get(KEY_DISTQTY_FIELD));
            unitConvertDTOs.add(unitConvertDTO);
        }
        return JSON.toJSONString(unitConvertDTOs);
    }
}

