/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.entity.rule.IBizRuleEditor;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class FormulaEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
IBizRuleEditor {
    private static final String formulatxt = "formulatxt";
    private static final String[] OPERATER = new String[]{"=", "+", "-", "*", "/", "<", ">"};
    private static final String BACKSPACE = "backspace";
    static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        private static final long serialVersionUID = 2684322634410225042L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("less", "<");
            this.put("greater", ">");
            this.put("lessequal", "<=");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("leftparentheses", "(");
            this.put("rightparentheses", ")");
            this.put("and", "AND");
            this.put("or", "OR");
            this.put("if", "IF(,,)");
            this.put("clr", "CLR");
            this.put(FormulaEdit.BACKSPACE, "Backspace");
        }
    };
    private static final String META_TYPE = "metaType";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        Button btn = null;
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toLowerCase();
            btn = (Button)this.getControl(key);
            btn.addClickListener((ClickListener)this);
        }
        btn = (Button)this.getControl("btnok");
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getControl("btncancel");
        btn.addClickListener((ClickListener)this);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode root = null;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object treeNode = showParameter.getCustomParam("treeNode");
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        if (treeNode instanceof String) {
            String hideRootNode = (String)showParameter.getCustomParam("hideRootNode");
            tree.setRootVisible(!Boolean.parseBoolean(hideRootNode));
            try {
                root = (TreeNode)JSONUtils.cast((String)((String)treeNode), TreeNode.class);
            }
            catch (IOException ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
            }
        } else {
            if (this.getView().getFormShowParameter().getCustomParam("context") == null || this.getView().getFormShowParameter().getCustomParam(META_TYPE) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"FormulaEdit_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            List context = this.getEntityItems();
            boolean isOnlyHeader = true;
            EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
            option.setOnlyBillHead(isOnlyHeader);
            root = FormTreeBuilder.buildEntityFieldsTree((List)context, (EntityFieldTreeBuildOption)option);
            this.getPageCache().put("context", SerializationUtils.toJsonString((Object)context));
        }
        root.setIsOpened(true);
        tree.addNode(root);
        String formula = this.getInputConfig();
        this.getModel().setValue(formulatxt, (Object)formula);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.closeAndReturn();
        } else if ("btncancel".equalsIgnoreCase(key)) {
            this.getView().close();
        } else if (key != null) {
            this.operation(key);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (e.getNodeId() != null && !"".equals(e.getNodeId().toString().trim())) {
            String character = e.getNodeId().toString();
            FormulaEditHelper.insertExpression(this.getView(), "treeviewap", formulatxt, character);
        }
    }

    public boolean checkConfig() {
        Object formula = this.getModel().getValue(formulatxt);
        if (StringUtils.isEmpty((String)((String)formula))) {
            String expression = ((String)formula).trim();
            try {
                FormulaEngine.parseFormula((String)expression);
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\uff1a%s\u3002", (String)"FormulaEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                return false;
            }
        }
        return true;
    }

    public String getOutConfig() {
        String formula = (String)this.getModel().getValue(formulatxt);
        return formula;
    }

    public void operation(String xx) {
        String character = operationCharacter.get(xx);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue(formulatxt, (Object)"");
            FormulaEditHelper.setCursorIndex(this.getView(), formulatxt, 0);
        } else if (BACKSPACE.equalsIgnoreCase(character)) {
            FormulaEditHelper.backSpaceExpression(this.getView(), xx, formulatxt);
        } else {
            FormulaEditHelper.insertExpression(this.getView(), xx, formulatxt, character);
        }
    }

    private void closeAndReturn() {
        Object formula = this.getModel().getValue(formulatxt);
        if (!StringUtils.isEmpty((String)((String)formula))) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object treeNode = showParameter.getCustomParam("treeNode");
            String expression = ((String)formula).trim();
            if (treeNode == null) {
                try {
                    FormulaEngine.parseFormula((String)expression);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\uff1a%s\u3002", (String)"FormulaEdit_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), e.getMessage()));
                    return;
                }
            }
            HashMap<String, Object> para = new HashMap<String, Object>();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            para.put("itemId", parameter.getCustomParam("itemId"));
            para.put(META_TYPE, parameter.getCustomParam(META_TYPE));
            para.put("propertyName", parameter.getCustomParam("propertyName"));
            para.put("rowIndex", parameter.getCustomParam("rowIndex"));
            para.put("fieldKey", parameter.getCustomParam("fieldKey"));
            para.put("value", expression);
            this.getView().returnDataToParent(para);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaEdit_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }
}

