/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.formruleactiontypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.StyleCss;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.kflow.api.IFlowDesignService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class KFlowSelectUtils {
    private static final String BIZ_APP_ENTITY = "bos_devportal_bizapp";
    private static final String MASTER_ID = "masterid";

    public static void init(String appId, BeforeF7SelectEvent evt) {
        KFlowSelectUtils.filterKFlow(appId, evt);
        KFlowSelectUtils.setStyle(evt);
    }

    private static void filterKFlow(String appId, BeforeF7SelectEvent evt) {
        List ids;
        IFlowDesignService service = (IFlowDesignService)ServiceFactory.getService(IFlowDesignService.class);
        ArrayList<String> queryAppIds = new ArrayList<String>(10);
        queryAppIds.add(appId);
        List<String> extendAppIds = KFlowSelectUtils.getExtendAppIds(appId);
        List<String> inheritAppIds = KFlowSelectUtils.getInheritAppIds(appId);
        if (!CollectionUtils.isEmpty(extendAppIds)) {
            queryAppIds.addAll(extendAppIds);
        }
        if (!CollectionUtils.isEmpty(inheritAppIds)) {
            queryAppIds.addAll(inheritAppIds);
        }
        if (!CollectionUtils.isEmpty((Collection)(ids = service.loadInstances(queryAppIds)))) {
            evt.addCustomQFilter(new QFilter("id", "in", (Object)ids));
        } else {
            evt.addCustomQFilter(new QFilter("id", "is null", (Object)""));
        }
    }

    private static void setStyle(BeforeF7SelectEvent evt) {
        FormShowParameter parameter = evt.getFormShowParameter();
        StyleCss css = new StyleCss();
        css.setWidth("710px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
    }

    private static List<String> getExtendAppIds(String bizAppId) {
        String selectFields = "id";
        String masterId = KFlowSelectUtils.getMasterId(bizAppId);
        QFilter[] filters = new QFilter[]{new QFilter(MASTER_ID, "=", (Object)masterId)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BIZ_APP_ENTITY, (String)selectFields, (QFilter[])filters);
        ArrayList<String> extendAppIds = new ArrayList<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    private static String getMasterId(String bizAppId) {
        String masterId = bizAppId;
        String selectFields = "masterid,type";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)bizAppId)};
        DynamicObject object = QueryServiceHelper.queryOne((String)BIZ_APP_ENTITY, (String)selectFields, (QFilter[])filters);
        if (object != null && "2".equals(object.getString("type")) && StringUtils.isNotBlank((CharSequence)object.getString(MASTER_ID))) {
            masterId = object.getString(MASTER_ID);
        }
        return masterId;
    }

    private static List<String> getInheritAppIds(String bizAppId) {
        ArrayList<String> inheritIds = new ArrayList<String>(5);
        String selectFields = "id,inheritpath";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)bizAppId)};
        DynamicObject object = QueryServiceHelper.queryOne((String)BIZ_APP_ENTITY, (String)selectFields, (QFilter[])filters);
        String pathStr = object.getString("inheritpath");
        if (StringUtils.isNotBlank((CharSequence)pathStr)) {
            String[] paths;
            for (String path : paths = pathStr.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                inheritIds.add(path);
            }
        }
        return inheritIds;
    }
}

